<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\EmailData;


class EmailController extends Controller
{
  public function index()
  {
    if(Auth::user()->hasRole('Admin')){
        $em = EmailData::where('type',"app_sub")->get();
        $em_p = EmailData::where('type',"proc_sub")->get();
        return view('email.index')->with(compact('em','em_p'));
    }
    echo 'Not allowed';
  }
   public function save(Request $request)
  {
    if(Auth::user()->hasRole('Admin')){
        // Helper to normalize and validate a mixed input (array of emails or delimited string values)
        $normalize = function ($input) {
            $candidates = [];
            if (is_array($input)) {
                foreach ($input as $v) {
                    if (is_string($v)) {
                        $parts = preg_split('/[\s,;]+/', trim($v));
                        if ($parts) $candidates = array_merge($candidates, $parts);
                    }
                }
            } elseif (is_string($input)) {
                $candidates = preg_split('/[\s,;]+/', trim($input));
            }
            $out = [];
            foreach ($candidates as $addr) {
                $addr = strtolower(trim((string)$addr));
                if ($addr !== '' && filter_var($addr, FILTER_VALIDATE_EMAIL)) {
                    $out[] = $addr;
                }
            }
            return array_values(array_unique($out));
        };

        // App submit list
        EmailData::where('type','app_sub')->delete();
        $appList = $normalize($request->input('app_submit'));
        foreach ($appList as $addr) {
            $em = new EmailData();
            $em->email = $addr;
            $em->type  = 'app_sub';
            $em->save();
        }

        // Processor submit list
        EmailData::where('type','proc_sub')->delete();
        $procList = $normalize($request->input('proc_submit'));
        foreach ($procList as $addr) {
            $em = new EmailData();
            $em->email = $addr;
            $em->type  = 'proc_sub';
            $em->save();
        }
        
        return redirect()->back()->with('success', 'Email Added Successfully!');
    }
    echo 'Not allowed';
  }
  
}
