<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Imports\UsersImport;
use App\Imports\LendersImport;
use App\Imports\DealsImport;
use Maatwebsite\Excel\Facades\Excel;


class ImportController extends Controller
{
  public function index()
  {
    if(Auth::user()->hasRole('Admin')){
        return view('import.index');
    }
    echo 'Not allowed';
  }
  public function add(Request $request)
  {
        if(isset($request->user)){
            Excel::import(new UsersImport, request()->file('user'));
        }
        if(isset($request->lender)){
            Excel::import(new LendersImport, request()->file('lender'));
        }
        if(isset($request->deal)){
            Excel::import(new DealsImport, request()->file('deal'));
        }
      return redirect()->back()->with('success', 'Imported Successfully!');
  }
  
}
