<?php

namespace App\Http\Controllers;

use App\Models\Team;
use App\Models\User;
use App\Models\UserTeam;
use App\Models\TeamLeader;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class TeamController extends Controller
{
    public function index()
    {
        if(!auth()->user()->hasRole('Admin')){
            $User_team_id=UserTeam::where('user_id', auth()->user()->id)->pluck('team_id')->toArray();
            $teams = Team::whereIn('id', $User_team_id)->with('leader')->get();
            return view('team.user_index', compact('teams'));
        }
        $teams = Team::with('leader', 'users')->get();
        $users = User::get();
        return view('team.index', compact('teams', 'users'));
    }
    public function store(Request $request)
    {
        $team = Team::create([
            'name' => $request->name,
        ]);
    
        $team_leaders = $request->input('team_leader_id', []);
        $members = $request->input('members', []);
    
        // add the team leaders to the team
        foreach ($team_leaders as $leader_id) {
            UserTeam::create([
                'team_id' => $team->id,
                'user_id' => $leader_id,
                'is_leader' => true,
            ]);
            TeamLeader::create([
                'team_id' => $team->id,
                'leader_id' => $leader_id,
            ]);
            $User = User::find($leader_id);
            $User->update([
                'team_lead' => 1,
            ]);
            $User->assignRole('Team_Lead');
        }
    
        // add the members to the team
        foreach ($members as $member_id) {
            UserTeam::create([
                'team_id' => $team->id,
                'user_id' => $member_id,
                'is_leader' => false,
            ]);
        }
        $users = User::whereHas('roles', function ($query) {
            $query->whereIn('name', ['Admin', 'Processor']);
        })->get();
        foreach ($users as $member_id) {
            UserTeam::create([
                'team_id' => $team->id,
                'user_id' => $member_id->id,
                'is_leader' => false,
            ]);
        }
        return redirect()->route('team.index');
    }


    public function show(Team $team)
    {
        $team_leaders = $team->users()->where('user_team.is_leader', true)->get();
        $members = $team->users()->where('user_team.is_leader', false)->get();
        return view('team.show', compact('team', 'team_leaders', 'members'));
    }

    // public function makeLeader(User $user, Team $team)
    // {
    //     $userTeam = UserTeam::where('team_id', $team->id)
    //         ->where('user_id', $user->id)
    //         ->first();

    //     if (!$userTeam) {
    //         abort(404);
    //     }

    //     $userTeam->update(['is_leader' => true]);

    //     return redirect()->back();
    // }
    public function get_team($id)
    {
        $team = Team::find($id);
        // $team_leaders = $team->users()->pluck('users.id')->toArray();
        $members = $team->users()->pluck('users.id')->toArray();
    
        return response()->json([
            // 'team_leaders' => $team_leaders,
            'members' => $members,
        ]);
        
        
    }
    public function destroy(Request $request)
    {
        UserTeam::where('team_id', $request->id)->delete();
        // delete the team
        $team = Team::find($request->id);
        $team->delete();
    
        return response()->json('success');
    }
    public function update(Request $request)
    {
        $request->validate([
            'name' => 'required',
        ]);
        // dd($request->all());
        $team = Team::find($request->id);
        $team_leaders = $request->input('team_leader_id', []);
        // update the team name
        $team->update([
            'name' => $request->name,
        ]);
    
        // delete all existing team members
        $team->userTeams()->delete();
        TeamLeader::where('team_id', $team->id)->delete();
        // add the team leaders to the team
        foreach ($team_leaders as $leader_id) {
            UserTeam::create([
                'team_id' => $team->id,
                'user_id' => $leader_id,
                'is_leader' => true,
            ]);
            TeamLeader::create([
                'team_id' => $team->id,
                'leader_id' => $leader_id,
            ]);
            $User = User::find($leader_id);
            $User->update([
                'team_lead' => 1,
            ]);
            $User->assignRole('Team_Lead');
        }
    
        // add the members to the team
        if ($request->has('members')) {
            foreach ($request->members as $member_id) {
                UserTeam::create([
                    'team_id' => $team->id,
                    'user_id' => $member_id,
                    'is_leader' => false,
                ]);
            }
        }
        $users = User::whereHas('roles', function ($query) {
            $query->whereIn('name', ['Admin', 'Processor']);
        })->get();
        foreach ($users as $member_id) {
            UserTeam::create([
                'team_id' => $team->id,
                'user_id' => $member_id->id,
                'is_leader' => false,
            ]);
        }
    
        return response()->json(true);
    }


}
