<?php

namespace App\Imports;

use App\Models\Lender;
use Carbon\Carbon;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithStartRow;

class LendersImport implements ToModel,WithStartRow
{
    /**
     * @return int
     */
    public function startRow(): int
    {
        return 2;
    }
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        for($i=0;$i<count($row);$i++){
            if($row[$i]=="NULL" || $row[$i]=="null" || $row[$i]=="Null" || isset($row[$i])==false){
                $row[$i]=null;
            }
        }
        return new Lender([
            'deal_id'=>$row[0],
            'company_name'=>$row[1],
            'primary_contact'=>$row[2],
            'code'=>$row[3],
            'phone'=>$row[4],
            'email'=>$row[5],
            'assigned'=>$row[6],
            'password'=>$row[7],
            'email2'=>$row[8],
            'last_contacted'=>$row[9],
            'processed_by'=>$row[10],
            'notes'=>$row[11],
            'funded_amount'=>$row[12],
            'funded_date' => $row[13] ? Carbon::createFromDate(1900, 1, 1)->addDays($row[13] - 2)->toDateString() : null,
            'date_sent' => $row[14] ? Carbon::createFromDate(1900, 1, 1)->addDays($row[14] - 2)->toDateString() : null,
            'status'=>$row[15],
            'position'=>$row[16],
        ]);
    }
}
