<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Deal extends Model
{
    use HasFactory;
    protected $fillable = [
        'sale_rep',
        'sale_rep2',
        'company_name',
        'primary_contact',
        'marchant_name',
        'phone_number',
        'cell_phone',
        'email',
        'request_amount',
        'lead_source',
        'lender_rule',
        'industry',
        'application_industry',
        'loan_purpose',
        'application_purpose',
        'existing_loans',
        'annual_revenue',
        'average_balance',
        'business_start_date',
        'state',
        'credit_score',
        'quick_add_notes',
        'date_submitted',
        'last_contacted',
        'lender_notes',
        'borrower',
        'borrower_status',
        'add_lender',
        'fixed',
        'status',
        'team_id',
        'seen_by_processor'
    ];    
    protected $guarded = [];
    /**
     * Get the lender_notes associated with the notes.
     */
    public function files()
    {
        return $this->hasMany(DealFiles::class);
    }
    // public function lenders()
    // {
    //     return $this->hasMany(Lender::class);
    // }
    // public function lenders()
    // {
    //     return $this->hasMany(Lender::class)->where('old', '!=', 1);
    // }
    public function lenders()
    {
        return $this->belongsToMany(Lender::class)->withPivot('old','date_sent','status','id','note','amount')->withTimestamps()->wherePivot('old', '!=', 1);
    }
    public function lenders_old()
    {
        return $this->belongsToMany(Lender::class)->withPivot('old','date_sent','status','id','note','amount')->withTimestamps()->wherePivot('old', '=', 1);
    }

    // public function teamLeaderDeals($teamLeaderId)
    // {
    //     return $this->join('users', 'deals.salesperson_id', '=', 'users.id')
    //                 ->where('users.team_leader_id', $teamLeaderId)
    //                 ->get();
    // }
    public function team()
    {
        return $this->belongsTo(Team::class);
    }
}
