<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class Loan extends Model
{
    use HasFactory;

    protected $fillable = [
        'loan_number',
        'deal_id',
        'lender_id',

        'funded_amount',
        'requested_amount',
        'balance',
        'rate',
        'total_amount',

        'day_of_week',
        'payment_frequency',
        'total_commision',
        'total_bonus',
        'bonus_office',
        'bonus_rep1',
        'commision_office',
        'payments',
        'points',
        'date_funded',
        'date_updated',

        'sale_rep',
        'sale_rep2',
        'status',
        'note',
        'history',
    ];

    protected $casts = [
        'funded_amount'     => 'float',
        'requested_amount'  => 'float',
        'balance'           => 'float',
        'rate'              => 'float',
        'points'            => 'float',
        'total_amount'      => 'float',
        'total_commision'   => 'float',
        'total_bonus'       => 'float',
        'bonus_office'      => 'float',
        'bonus_rep1'        => 'float',
        'commision_office'  => 'float',
        'payments'          => 'integer',
        'date_funded'       => 'date',
        'date_updated'      => 'date',
    ];

    public function getDateFundedAttribute($value)
    {
        if (!$value || $value === '0000-00-00') return null;
        return $value instanceof Carbon ? $value : Carbon::parse($value);
    }
    public function getDateUpdatedAttribute($value)
    {
        if (!$value || $value === '0000-00-00') return null;
        return $value instanceof Carbon ? $value : Carbon::parse($value);
    }

    public function lender() { return $this->belongsTo(Lender::class); }
    public function deal()   { return $this->belongsTo(Deal::class); }
}
