<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Team extends Model
{
    protected $fillable = [
        'name', 'team_leader_id'
    ];

    // public function leader()
    // {
    //     return $this->belongsTo(User::class, 'team_leader_id');
    // }
    public function leader()
    {
        return $this->belongsToMany(User::class, 'team_leader', 'team_id', 'leader_id');
    }

    public function users()
    {
        return $this->hasManyThrough(
            User::class,
            UserTeam::class,
            'team_id',
            'id',
            'id',
            'user_id'
        );
    }
    

    public function userTeams()
    {
        return $this->hasMany(UserTeam::class);
    }
}
