<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDealLenderTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('deal_lender', function (Blueprint $table) {
           $table->id();
            $table->unsignedBigInteger('deal_id');
            $table->unsignedBigInteger('lender_id');
            $table->boolean('old')->nullable();
            $table->date('date_sent')->nullable();
            $table->integer('amount')->nullable();
            $table->string('status')->nullable();
            $table->string('note')->nullable();
            $table->foreign('deal_id')->references('id')->on('deals')->onDelete('cascade');
            $table->foreign('lender_id')->references('id')->on('lenders')->onDelete('cascade');
            $table->timestamps();
        });
    }


    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('deal_lender');
    }
}
