<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('deals', function (Blueprint $table) {
            $table->string('lead_source')->nullable();
            $table->string('lender_rule')->nullable();
            $table->string('cell_phone')->nullable();
            $table->string('industry')->nullable();
            $table->string('application_industry')->nullable();
            $table->string('loan_purpose')->nullable();
            $table->string('application_purpose')->nullable();
            $table->integer('existing_loans')->nullable();
            $table->bigInteger('annual_revenue')->nullable();
            $table->string('average_balance')->nullable();
            $table->date('business_start_date')->nullable();
            $table->string('state')->nullable();
            $table->integer('credit_score')->nullable();
            $table->text('quick_add_notes')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('deals', function (Blueprint $table) {
            $table->dropColumn([
                'lead_source',
                'lender_rule',
                'cell_phone',
                'industry',
                'application_industry',
                'loan_purpose',
                'application_purpose',
                'existing_loans',
                'annual_revenue',
                'average_balance',
                'business_start_date',
                'state',
                'credit_score',
                'quick_add_notes',
            ]);
        });
    }
};
