<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('loans', function (Blueprint $table) {
            $table->decimal('points', 8, 2)->nullable()->after('funded_amount');
        });
        DB::statement("
            UPDATE loans
            SET points = ROUND((total_commision / funded_amount) * 100, 2)
            WHERE funded_amount IS NOT NULL
              AND funded_amount <> 0
              AND total_commision IS NOT NULL
        ");
    }

    public function down(): void
    {
        Schema::table('loans', function (Blueprint $table) {
            $table->dropColumn('points');
        });
    }
};
