<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('commissions', function (Blueprint $table) {
            if (!Schema::hasColumn('commissions', 'loan_id')) {
                $table->unsignedBigInteger('loan_id')->nullable()->after('lender_id');
                $table->foreign('loan_id')->references('id')->on('loans')->onDelete('cascade');
                $table->unique('loan_id', 'commissions_loan_id_unique');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('commissions', function (Blueprint $table) {
            if (Schema::hasColumn('commissions', 'loan_id')) {
                // drop unique
                $table->dropUnique('commissions_loan_id_unique');
                // drop foreign key (name may be auto-generated; ensure compatibility)
                try {
                    $table->dropForeign(['loan_id']);
                } catch (\Throwable $e) {
                    // ignore
                }
                $table->dropColumn('loan_id');
            }
        });
    }
};
