<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('commissions', function (Blueprint $table) {
            if (!Schema::hasColumn('commissions', 'sales_rep_cm')) {
                $table->decimal('sales_rep_cm', 20, 2)->unsigned()->nullable()->after('amount');
            }
            if (!Schema::hasColumn('commissions', 'team_leader_cm')) {
                $table->decimal('team_leader_cm', 20, 2)->unsigned()->nullable()->after('sales_rep_cm');
            }
        });
    }

    public function down(): void
    {
        Schema::table('commissions', function (Blueprint $table) {
            if (Schema::hasColumn('commissions', 'team_leader_cm')) {
                $table->dropColumn('team_leader_cm');
            }
            if (Schema::hasColumn('commissions', 'sales_rep_cm')) {
                $table->dropColumn('sales_rep_cm');
            }
        });
    }
};
