<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('commissions', function (Blueprint $table) {
            if (!Schema::hasColumn('commissions', 'sales_rep_paid')) {
                $table->boolean('sales_rep_paid')->default(false)->after('sales_rep_cm');
            }
            if (!Schema::hasColumn('commissions', 'team_leader_paid')) {
                $table->boolean('team_leader_paid')->default(false)->after('team_leader_cm');
            }
        });
    }

    public function down(): void
    {
        Schema::table('commissions', function (Blueprint $table) {
            if (Schema::hasColumn('commissions', 'team_leader_paid')) {
                $table->dropColumn('team_leader_paid');
            }
            if (Schema::hasColumn('commissions', 'sales_rep_paid')) {
                $table->dropColumn('sales_rep_paid');
            }
        });
    }
};
