<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use App\Models\User;

class SpatiePermissionSanitySeeder extends Seeder
{
    public function run()
    {
        $perm = Permission::firstOrCreate(['name'=>'view dashboard','guard_name'=>'web']);
        $role = Role::firstOrCreate(['name'=>'admin','guard_name'=>'web']);
        $role->givePermissionTo($perm);

        $user = User::find(1); // Change ID if needed
        if ($user) {
            $user->assignRole('admin');
        }
    }
}
