<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CustomUrl extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
        'posting_url',
        'email',
        'update_existing_contacts',
        'update_field',
        'url_id',
        'user_id',
        'project_id',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function project()
    {
        return $this->belongsTo(Project::class);
    }

    public function fieldMappings()
    {
        return $this->hasMany(FieldMapping::class);
    }
}
