<!DOCTYPE html>
<html lang="en">

<head>
    <x-projecthead />

    @section('title')
        Custom Urls(webhooks)
    @endsection
</head>

<body>
    <x-projectnavbar />
    <div class="tableContainer">
        <div class="tab-content" id="nav-tabContent">
            <div class="tab-pane fade show active pt-2" id="nav-contact" role="tabpanel" aria-labelledby="nav-home-tab">
                <div class="actimeproject" style="border-radius: 0px !important;">



                    <div class="tableWrapper projectTable" style="height: fit-content !important;">
                        <div class="table-content table-responsive" style='margin: auto;'>
                            <table class="table table-borded table-bordered active-users table-hover my-contacts"
                                style="width: 100%" id='table-list'>
                                <thead class='table'>
                                    <tr class="tabelHeader">
                                        <th></th>
                                        <th>
                                            Name
                                        </th>
                                        <th>Description</th>
                                        {{-- <th>Email (Click to Open)</th> --}}
                                        <th>Email</th>
                                        <th>Posting Url</th>


                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($customUrls as $url)
                                        <tr id='row-{{$url->id}}'>
                                            <td >
                                                <ion-icon class='closeicon delete_user cursor-pointer' 
                                                    name='close-circle-outline' onclick="delete_url('{{url('delete-custom-url/'.$url->id)}}','{{$url->id}}')">
                                                </ion-icon>
                                      
                                                <a href="{{url('edit-custom-url/'.$url->id)}}">
                                                    <ion-icon class='closeicon delete_user mr-2' name='create-outline'>
                                                    </ion-icon>
                                                </a>
                                            </td>
                                            <td>{{ $url->name }}</td>
                                            <td>{{ $url->description }}</td>
                                            <td>{{ $url->email }}</td>
                                            <td>{{ $url->posting_url }}</td>

                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>
   
    <script>
        function delete_url(url,id){
          
            return new swal({
                text: "You won't be able to recover this record?",
                title: "Are you sure?",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#DD6B55",
                confirmButtonText: "Yes, delete it!",
                showLoaderOnConfirm: true,
            }).then((result) => { 
                result = result.isConfirmed;    
                if(result == true || result == "true")
                {
                    $.ajax({
                        method: 'GET',
                        url: url,
                        success: function () {
                            tr = $('#row-'+id).remove();
                            
                        
                           ;
                            return new swal("Deleted!", "Your record has been deleted.", "success");
                        },
                        error: function (jqXhr) {
                            return new swal("Oops", "Something went wrong.", "error");
                        }
                    });
                }
            })
        }
        </script>
    <x-projectfooter />
</body>

</html>
