<!DOCTYPE html>
<html lang="en">

<head>
    <x-projecthead />

    @section('title')
        Custom Url(webhook)
    @endsection
</head>

<body>
    <x-projectnavbar />

    <div class="container">
        <form action="{{url('update-custom-url/'.$customUrl->id)}}" method="POST">
            @csrf
            <div class="card">
                <div class="card-header">
                    <h3>Update Custom Url(webhook)</h3>
                </div>
                @if (Session::has('error'))
                    <div class="alert alert-danger m-2">{{ Session::get('error') }}</div>
                @elseif(Session::has('success'))
                    <div class="alert alert-success m-2">{{ Session::get('success') }}</div>
                @else
                @endif

                <div class="card-body">
                    <div class="container">
                        <div class="row">
                            <div class="col-md-12">
                                <label for="name">Name</label>
                                <input type="text" id="name" name="name" value="{{ $customUrl->name }}"
                                    class="form-control" required>
                                <input type="hidden" id="dd" name="url_id" value="{{ $customUrl->url_id }}"
                                    class="form-control">
                                <label for="desc">Description</label>
                                <input type="text" id="desc" name="desc"
                                    value="{{ $customUrl->description }}" class="form-control">
                                <label for="url">Posting Url</label>
                                <input type="text" id="url" name="url" class="form-control"
                                    value="{{ config('app.url') }}/web/post?id={{ $customUrl->url_id }}" readonly>
                                <label for="email">Email for Result Code</label>
                                <input type="email" id="email" name="email" value="{{ $customUrl->email }}"
                                    class="form-control">

                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-header">
                    <h3>Options</h3>
                </div>
                <div class="card-body">
                    <div class="container">
                        <div class="row">
                            <div class="col-md-12">
                                <label for="update">Update Existing Contacts</label>
                                <input type="checkbox" name="updateContact" id="update"
                                    checked="@php
$customUrl->update_existing_contacts?true:false @endphp">

                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <p>Update Contacts that have matching values for this field: </p>

                            </div>
                            <div class="col-md-6">
                                <select name="updatefield" id="" class="form-control">
                                    <option value="" selected disabled>Select field</option>
                                    @foreach ($columns as $column)
                                        <option value="{{ $column }}"
                                            @if ($column == $customUrl->update_field) selected @endif>
                                            {{ str_replace('_', ' ', ucwords($column, '_')) }}</option>
                                    @endforeach
                                </select>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-header">
                    <h3>Field Mappings</h3>
                </div>
                <div class="card-body">
                    <div class="container">
                        <div class="row">
                            <div class="col-md-12">
                                <button type="button" class="btn btn-primary mb-2" id="addFieldBtn">Add Field</button>

                                <div class="">
                                    <table class="display" style="width: 100%">
                                        <thead>
                                            <tr class="tabelHeader ">
                                                {{-- <th>
                                                <div class="d-flex align-items-center">
                                                    <input type="checkbox" class="mr-2" name=""
                                                        id="delete_multiple" /> Active
                                                </div>
                                            </th> --}}
                                                <th>SalesCallz Field</th>

                                                <th>Web form Field</th>

                                                <th>Default value</th>

                                            </tr>
                                        </thead>
                                        <tbody id="table-body">
                                            @foreach ($customUrl->fieldMappings as $item)
                                                <tr>
                                                    <td>
                                                        <select name="fields[]" id="" class="form-control"
                                                            required>
                                                            <option value="" disabled>Select field</option>
                                                            @foreach ($columns as $column)
                                                                <option value="{{ $column }}"
                                                                    @if ($column == $item->salescallz_field) selected @endif>
                                                                    {{ str_replace('_', ' ', ucwords($column, '_')) }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </td>
                                                    <td>
                                                        <input type="text" name="webfields[]" class="form-control"
                                                            value="{{ $item->web_form_field }}"
                                                            placeholder="Enter incoming field name" required>
                                                    </td>
                                                    <td>
                                                        <input type="text" value="{{ $item->default_value }}"
                                                            name="defaultvalues[]" class="form-control"
                                                            placeholder="Enter default value">
                                                    </td>
                                                    <td><button class="btn btn-danger"
                                                            onclick="removeRow(this)">Remove</button>
                                                    </td>
                                                </tr>
                                            @endforeach

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer">
                    <button type="submit" class="btn btn-lg float-right btn-primary mb-2">Update</button>
                </div>
            </div>
        </form>
    </div>




    <!-- Modal -->

    <x-projectfooter />
    <script>
        const addFieldBtn = document.getElementById('addFieldBtn');
        const tableBody = document.getElementById('table-body');

        addFieldBtn.addEventListener('click', function() {
            const newRow = `
        <tr>
            <td>
                <select name="fields[]" id="" class="form-control" required>
                                                    <option value=""  selected disabled>Select field</option>
                                                    @foreach ($columns as $column)
                                                        <option value="{{ $column }}">
                                                            {{ str_replace('_', ' ', ucwords($column, '_')) }}</option>
                                                    @endforeach
                                                </select>
            </td>
            <td>
                <input type="text" name="webfields[]" class="form-control" placeholder="Enter incoming field name" required>
            </td>
            <td>
                <input type="text" name="defaultvalues[]" class="form-control" placeholder="Enter default value">
            </td>
            <td><button class="btn btn-danger" onclick="removeRow(this)">Remove</button></td>
        </tr>
    `;
            tableBody.insertAdjacentHTML('beforeend', newRow);
        });




        function removeRow(button) {
            var row = button.parentNode.parentNode;
            row.parentNode.removeChild(row);
        }
    </script>

</body>

</html>
