require('./bootstrap');

console.info('File app.js loaded');
$(document).ready(function () {

    // Split(['#one', '#two', '#three', '#four'], {
    //     sizes: [24, 23, 24, 24],

    //     gutterSize: 5,
    //     expandToMin: true,
    //     cursor: 'col-resize',
    // })


    $('.sub-btn').click(function () {
        $(this).next('.sub-menu').slideToggle();
        $(this).find('.dropdown').toggleClass('rotate');
    });
    $('#toggle-sidebar').click(function () {
        let isCollapsed = document.documentElement.classList.toggle('sidebar-collapsed');
        localStorage.setItem('sidebar_collapsed', isCollapsed ? '1' : '0');
    });

    // Update lender information
    // $('.edit_lender').click(function () {
    //     var id = $(this).data('id');
    //     $.ajax({
    //         type: 'GET',
    //         url: 'lender/edit/' + id,
    //         success: function (result) {
    //             //alert(result.phone);
    //             $('#lender_id').val(result.id);
    //             $('#company_name1').val(result.company_name);
    //             $('#primary_contact1').val(result.primary_contact);
    //             $('#email1').val(result.email);
    //             $('#email12').val(result.email2);
    //             $('#phone1').val(result.phone);
    //             $('#code1').val(result.code);
    //             $('#last_contacted1').val(result.last_contacted);
    //             $('#position1').val(result.position);
    //             $('#edit_lender').modal('show');
    //         }
    //     });
    //     $('#lender_save').click(function (e) {
    //         e.preventDefault();
    //         $.ajaxSetup({
    //             headers: {
    //                 'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
    //             }
    //         });
    //         var formadata = {
    //             id: $('#lender_id').val(),
    //             company_name: $('#company_name1').val(),
    //             primary_contact: $('#primary_contact1').val(),
    //             email: $('#email1').val(),
    //             email2: $('#email12').val(),
    //             phone: $('#phone1').val(),
    //             code: $('#code1').val(),
    //             password: $('#password1').val(),
    //             email_password: $('#email_password1').val(),
    //             last_contacted: $('#last_contacted1').val(),
    //             status: $('#status1').val(),
    //             position: $('#position1').val(),
    //         };
    //         $.ajax({
    //             type: 'PUT',
    //             url: 'lender/update',
    //             data: formadata,
    //             success: function (result) {

    //                 Swal.fire(
    //                     'Updated!',
    //                     'Lender has been Updated.',
    //                     'success'
    //                 );
    //                 location.reload();
    //             }
    //         });


    //     })
    // });
    // Update Employee Info
    $('.edit_employee').click(function () {
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
            }
        });
        var id = $(this).attr('data-id');

        $.ajax({
            type: 'GET',
            url: 'employee/edit/' + id,
            success: function (result) {

                $('#employee_id').val(result.user.id);
                $('#name1').val(result.user.name);
                $('#email1').val(result.user.email);
                $('#phone1').val(result.user.phone);
                $('#emp_select').val(result.role_id);
                $('#emp_select').text(result.role_id);
                $('#role_id1', 'selected').val(result.role_id);
                $('#app_slug1').val(result.app_slug);
                $('#status1').val(result.user.status);
                $('#edit_employee').modal('show');

            }
        });
        $('#save_employee').click(function (e) {
            e.preventDefault();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
                }
            });
            var formadata = {
                id: $('#employee_id').val(),
                name: $('#name1').val(),

                email: $('#email1').val(),
                password: $('#password1').val(),
                phone: $('#phone1').val(),
                role_id: $('#role_id1').val(),
                status: $('#status1').val(),
                email_password: $('#email_password1').val(),
                app_slug: $('#app_slug1').val(),

            };

            $.ajax({
                type: 'PUT',
                url: 'employee/update',
                data: formadata,
                success: function (result) {
                    console.log(result);
                    if(result == 'error'){
                        Swal.fire(
                            'Error!',
                            'App slug duplicate error',
                            'error'
                        );
                    }
                    else{
                        Swal.fire(
                            'Updated!',
                            'Employee has been Updated.',
                            'success'
                        );
                    }
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                },
                error : function(){
                    Swal.fire(
                        'Error!',
                        'in error',
                        'error'
                    );
                }
            });


        })
    });
    $('#save_edited_team').click(function (e) {
        e.preventDefault();
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
            }
        });
        var form_data = $('#team_edit').serializeArray();
        var members = [];
        $.each($('input[name="members[]"]:checked'), function(){
            members.push($(this).val());
        });
        form_data.push({name: "members", value: members});

        var formadata = {
            id: $('#edit_team_id').val(),
            name: $('#edit_team_name').val(),
            team_leader_id: $('#edit_team_leader').val(),
            members :  members
        };
        $.ajax({
            type: 'PUT',
            url: 'team/update',
            data: formadata,
            success: function (result) {

                Swal.fire(
                    'Updated!',
                    'Team has been Updated.',
                    'success'
                );
                location.reload();
            }
        });


    })
    $("#add_deal").on("hidden.bs.modal", function() { $(this).find('form').trigger("reset"); });
    //Update Deal
    $('.edit_deal').click(function () {
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
            }
        });
        var id = $(this).attr('data-id');
        $('#deal_id_edit').val(id);

        $.ajax({
            type: 'GET',
            url: 'deal/edit/' + id,
            success: function (result) {
                // alert(result);
                $('#deal_id').val(result.id);
                $('#sale_rep1').val(result.sale_rep);
                $('#sale_rep21').val(result.sale_rep2);
                $('#company_name1').val(result.company_name);
                $('#marchant_name1').val(result.marchant_name);
                $('#email1').val(result.email);
                $('#phone_number1').val(result.phone_number);
                $('#requested_amount1').val(result.request_amount);
                $('#date_submitted1').val(result.date_submitted);
                $('#last_contacted1').val(result.last_contacted);
                $('#lender_notes').val(result.lender_notes);

                $('#edit_deal').modal('show');

            }
        });
        $('#save_deal').click(function (e) {
            e.preventDefault();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
                }
            });
            var formadata = {
                id: $('#deal_id').val(),
                sale_rep: $('#sale_rep1').val(),
                sale_rep2: $('#sale_rep21').val(),
                email: $('#email1').val(),
                phone_number: $('#phone_number1').val(),
                marchant_name: $('#marchant_name1').val(),
                company_name: $('#company_name1').val(),
                request_amount: $('#requested_amount1').val(),
                status: $('#status1').val(),
                lender_notes: $('#lender_notes').val(),
                date_submitted: $('#date_submitted1').val(),
                last_contacted: $('#last_contacted1').val()

            };

            $.ajax({
                type: 'PUT',
                url: 'deal/update',
                data: formadata,
                success: function (result) {

                    Swal.fire(
                        'Updated!',
                        'Deal has been Updated.',
                        'success'
                    );
                    location.reload();
                }
            });


        })
    });
    // Delete Lender
    $('.delete_lender').click(function () {
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
            }
        });
        var id = $(this).attr('data-id');
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    type: 'DELETE',
                    url: 'lender/delete',
                    data: { id: id },
                    success: function (result) {
                        if (result == 'success') {

                            Swal.fire(
                                'Deleted!',
                                'Lender has been deleted.',
                                'success'
                            );
                            location.reload();
                        } else {
                            Swal.fire(
                                'Whoops!',
                                'Something Went Wrong.',
                                'warning'
                            );
                        }

                    }

                });

            }
        })
    });
    // Delete Employee
    $('.delete_employee').click(function () {
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
            }
        });
        var id = $(this).attr('data-id');
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    type: 'DELETE',
                    url: 'employee/delete',
                    data: { id: id },
                    success: function (result) {
                        if (result == 'success') {

                            Swal.fire(
                                'Deleted!',
                                'Employee has been deleted.',
                                'success'
                            );
                            location.reload();
                        } else {
                            Swal.fire(
                                'Whoops!',
                                'Something Went Wrong.',
                                'warning'
                            );
                        }

                    }

                });

            }
        })
    });
    // Delete Team
    $('.delete_team').click(function () {
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
            }
        });
        var id = $(this).attr('data-id');
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    type: 'DELETE',
                    url: 'team/delete?id=' + id,
                    success: function (result) {
                        if (result == 'success') {

                            Swal.fire(
                                'Deleted!',
                                'Team has been deleted.',
                                'success'
                            );
                            location.reload();
                        } else {
                            Swal.fire(
                                'Whoops!',
                                'Something Went Wrong.',
                                'warning'
                            );
                        }

                    }

                });

            }
        })
    });
    //Delete Deal
    $('.delete_deal').click(function () {
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
            }
        });
        var id = $(this).attr('data-id');
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    type: 'DELETE',
                    url: 'https://deals.salescallz.com/deal/delete',
                    data: { id: id },
                    success: function (result) {
                        if (result == 'success') {

                            Swal.fire(
                                'Deleted!',
                                'Deal has been deleted.',
                                'success'
                            );
                            window.location.replace('https://deals.salescallz.com/deals');
                        } else {
                            Swal.fire(
                                'Whoops!',
                                'Something Went Wrong.',
                                'warning'
                            );
                        }

                    }

                });

            }
        })
    });
    // store status
    $('.notes').on('blur' ,function (e) {
        var lender_id = $(this).data('id');
        var deal_id = $(this).data('deal_id');
        var note = $(this).val();
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
            }
        });
        $.ajax({
            type: 'POST',
            url: '/store_notes',
            data: { lender_id: lender_id, note: note, deal_id: deal_id },
            success: function (result) {
                // Swal.fire(
                //     'Success!',
                //     'Notes Send Successfuly.',
                //     'success'
                // );
            }
        })
    });
    $('.funded_amount').on('blur' , function (e) {
        // e.preventDefault();
        var lender_id = $(this).data('id');
        var deal_id = $(this).data('deal_id');
        var amount = $(this).val();
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
            }
        });
        $.ajax({
            type: 'POST',
            url: '/store_amount',
            data: { lender_id: lender_id, amount: amount , deal_id : deal_id},
            success: function (result) {
                // Swal.fire(
                //     'Success!',
                //     'Amount Send Successfuly.',
                //     'success'
                // );
            }
        })
    });
    // send email
    $('.send_email').click(function (e) {
        e.preventDefault();
        var lender_id = $(this).attr('data-id');
        var deal_id = $(this).attr('data-deal_id');

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
            }
        });
        $.ajax({
            type: 'POST',
            url: '/send_email',
            data: { lender_id: lender_id, deal_id: deal_id },
            success: function (result) {
                console.log(result);
                Swal.fire(
                    'Success!',
                    'Email Send Successfuly.',
                    'success'
                );
            }
        })


    });
    // send email
    $('.send_mail_processor').click(function (e) {
        var deal_id = $(this).attr('data-id');
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
            }
        });
        $.ajax({
            type: 'POST',
            url: '/send_email_all',
            data: { deal_id: deal_id },
            success: function (result) {
                console.log(result);
                Swal.fire(
                    'Success!',
                    'Email Send Successfuly To Processor.',
                    'success'
                );
                $('#deal_tab_div').html(result);
            }
        })


    });

    $(document).on('submit', '#dealForm', function (e) {
        e.preventDefault();

        const mode = $('#hf_mode').val();
        const url  = (mode === 'edit') ? '/loans/update' : '/change_status';

        const payload = {
            lender_id:   $('#hf_lender_id').val(),
            deal_id:     $('#hf_deal_id').val(),
            status:      $('#hf_status').val() || 'Funded',
            funded_date: $('#fundedDate').val(),
            lender_name: $('#lenderName').val(),
            amount:      $('#amount').val(),
            term_length: $('#termLength').val(),
            term_unit:   $('#termUnit').val(),
            points:      $('#points').val(),
            rep:         $('#rep').val(),
            loan_type:   $('#loanType').val() || 'Advance'
        };

        if (mode === 'edit') {
            payload.loan_id = $('#hf_loan_id').val();
        }

        $.ajaxSetup({ headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') }});

        const $submit = $('#dealFormSubmit');
        const $spinner = $submit.find('.spinner-border');
        const $text = $submit.find('.submit-text');
        $submit.prop('disabled', true); $spinner.removeClass('d-none'); $text.addClass('d-none');

        $.post(url, payload)
            .done(function(){
                window.__dealModal?.hide();
                Swal.fire('Success!', mode === 'edit' ? 'Loan updated.' : 'Deal created.', 'success')
                    .then(() => window.location.reload());
            })
            .fail(function(xhr){
                const msg = xhr?.responseJSON?.message || 'Request failed.';
                $('#dealFormError').removeClass('d-none').text(msg);
            })
            .always(function(){
                $submit.prop('disabled', false); $spinner.addClass('d-none'); $text.removeClass('d-none');
            });
    });

    $(document).off('click', '.edit-loan').on('click', '.edit-loan', function (e) {
        e.preventDefault();
        const $btn = $(this);

        $('#hf_mode').val('edit');
        $('#hf_loan_id').val($btn.data('loan_id'));
        $('#hf_lender_id').val($btn.data('lender_id'));
        $('#hf_deal_id').val($btn.data('deal_id'));
        $('#hf_status').val($btn.data('status') || 'Funded');

        $('#lenderName').val($btn.data('lender_name') || '');
        $('#amount').val($btn.data('amount') || '');
        $('#fundedDate').val($btn.data('funded_date') || '');

        $('#termLength').val($btn.data('term_length') || '');
        $('#termUnit').val($btn.data('term_unit') || 'days');
        $('#points').val($btn.data('points') || '');

        const rep = $btn.data('rep') || '';
        if (rep) { $('#rep').val(rep); } else { $('#rep').val(''); }

        const lt = $btn.data('loan_type') || 'Advance';
        $('#loanType').val(lt || 'Advance');

        $('#dealFormError').addClass('d-none').text('');
        $('#dealAcceptModalLabel').text('Edit Deal Details');
        $('#dealFormSubmit .submit-text').text('Save Changes');

        (window.__dealModal || (window.__dealModal = new bootstrap.Modal(document.getElementById('dealAcceptModal'), {backdrop:'static'}))).show();
    });

    let dealAcceptModal;

    function ensureModalInstance() {
        if (!dealAcceptModal) {
            const modalEl = document.getElementById('dealAcceptModal');
            dealAcceptModal = new bootstrap.Modal(modalEl, { backdrop: 'static' });
        }
        return dealAcceptModal;
    }

    $(document).off('click', '.accept_button').on('click', '.accept_button', function (e) {
        e.preventDefault();
        const $btn = $(this);
        const $row = $btn.closest('tr');

        $('#hf_mode').val('create');
        $('#hf_loan_id').val('');

        $('#hf_lender_id').val($btn.data('id'));
        $('#hf_deal_id').val($btn.data('deal_id'));
        $('#hf_status').val('Funded');

        const lenderName = $btn.data('lender_name') || $row.find('.lender-name').text().trim() || '';
        $('#lenderName').val(lenderName);

        const inputValRaw = $('#fundedAmount').val()
        let amountFromInput = (inputValRaw !== undefined && inputValRaw !== null) ? String(inputValRaw).trim() : '';
        amountFromInput = amountFromInput ? amountFromInput.replace(/[^\d.]/g, '') : '';
        let amount = amountFromInput || $btn.data('amount') || '';
        $('#amount').val(amount);

        const today = new Date().toISOString().slice(0,10);
        $('#fundedDate').val(today);

        $('#termLength').val('');
        $('#termUnit').val('days');
        $('#points').val('');
        $('#loanType').val('Advance');

        $('#dealFormError').addClass('d-none').text('');
        $('#dealAcceptModalLabel').text('Submit Deal Details');
        $('#dealFormSubmit .submit-text').text('Submit Deal');

        (window.__dealModal || (window.__dealModal = new bootstrap.Modal(document.getElementById('dealAcceptModal'), {backdrop:'static'}))).show();
    });

    $(document).off('submit', '#dealForm').on('submit', '#dealForm', function (e) {
        e.preventDefault();

        if ($(this).data('submitting')) return;
        $(this).data('submitting', true);

        const $submit = $('#dealFormSubmit');
        const $spinner = $submit.find('.spinner-border');
        const $text = $submit.find('.submit-text');
        $submit.prop('disabled', true); $spinner.removeClass('d-none'); $text.addClass('d-none');

        $.ajaxSetup({ headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') }});

        const payload = {
            loan_id:     $('#hf_loan_id').val(),
            lender_id:   $('#hf_lender_id').val(),
            deal_id:     $('#hf_deal_id').val(),
            status:      $('#hf_status').val() || 'Funded',
            funded_date: $('#fundedDate').val(),
            lender_name: $('#lenderName').val(),
            amount:      $('#amount').val(),
            term_length: $('#termLength').val(),
            term_unit:   $('#termUnit').val(),
            points:      $('#points').val(),
            rep:         $('#rep').val(),
            loan_type:   $('#loanType').val() || 'Advance',
            requested_amount: $('#requestedAmount').val(),
            balance:          $('#balance').val()
        };

        const isEdit = Boolean(payload.loan_id);
        const url = isEdit ? '/loans/update' : '/change_status';

        $.post(url, payload)
            .done(function () {
                window.__dealModal?.hide();
                Swal.fire('Success!', isEdit ? 'Loan updated.' : 'Deal created.', 'success')
                    .then(() => window.location.reload());
            })
            .fail(function (xhr) {
                const msg = xhr?.responseJSON?.message || 'Request failed.';
                $('#dealFormError').removeClass('d-none').text(msg);
            })
            .always(function () {
                $('#dealForm').data('submitting', false);
                $submit.prop('disabled', false); $spinner.addClass('d-none'); $text.removeClass('d-none');
            });
    });

    $('.status').change(function () {
        var lender_id = $(this).attr('data-id');
        var deal_id = $(this).attr('data-deal_id');
        var status = $(this).children("option:selected").val();
        if(status != '-'){
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: 'POST',
                url: '/update_status',
                data: { lender_id: lender_id, status: status , deal_id:deal_id},
                success: function (result) {
                    Swal.fire(
                        'Success!',
                        'Status has been changed.',
                        'success'
                    );
                    $('#deal_tab_div').html(result);
                }
            })
        }
    })
    $('.offerModal').click(function () {
        var lender_id = $(this).data('lender_id');
        var deal_id = $(this).attr('data-deal_id');
        $('#offerModal input[name="lender_id"]').val(lender_id);
        $('#offerModal input[name="deal_id"]').val(deal_id);
    });
    $('.btn-download').click(function(e) {
        // e.preventDefault();
        var file_id = $(this).data('id');
        var deal_id = $(this).data('deal_id');
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
            }
        });
        $.ajax({
            url: '/download_file/add_note',
            type: 'POST',
            data: {
                file_id: file_id ,
                deal_id: deal_id
            },
            success: function(response) {
            },
            error: function(xhr, status, error) {
            }
        });
    });
    $('#send-sales-note').click(function() {
        var details = $('#sales-note-detail').val();
        var deal_id = $(this).data('deal_id');

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
            }
        });
        $.ajax({
            url: '/sale_note/add_note',
            method: 'POST',
            data: { details: details, deal_id: deal_id },
            success: function(response) {
                Swal.fire(
                    'Success!',
                    'Sale note has been added.',
                    'success'
                );
                location.reload();
            },
            error: function(xhr, status, error) {
                // handle error response
            }
        });
    });
    $('#select_all_send_mail').click(function(e) {
        // get all checked lender_mail
        var checked = [];
        var deal_id = $(this).attr('data-id');
        $('.lender_mail').each(function() {
            if ($(this).is(':checked')) {
                checked.push($(this).val());
            }
        });
        if(checked.length == 0){
            Swal.fire(
                'Error!',
                'Please Select Atleast One Lender',
                'error'
            );
            return false;
        }
        else{
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: 'POST',
                url: '/send_email_all_selected',
                data: { lender_ids: checked , deal_id:deal_id },
                success: function (result) {
                    Swal.fire(
                        'Success!',
                        'Email Send Successfuly To All Selected Lenders',
                        'success'
                    );
                    $('.lender_mail').each(function() {
                        if ($(this).is(':checked')) {
                            $(this).prop('checked',false);
                        }
                    });
                }
            })
        }

    });
});
$(document).on('click', '.edit_lender', function (e) {
    e.preventDefault();
    var id = $(this).data('id');
    $.ajax({
        type: 'GET',
        url: '/lender/edit/' + id,
        success: function (result) {
            $('#lender_id').val(result.id);
            $('#company_name1').val(result.company_name);
            $('#primary_contact1').val(result.primary_contact);
            $('#email1').val(result.email);
            $('#email2_edit').val(result.email2);
            $('#phone1').val(result.phone);
            $('#last_contacted1').val(result.last_contacted);
            $('#edit_min_time_in_business').val(result.min_time_in_business);
            $('#edit_min_revenue').val(result.min_revenue);
            $('#edit_max_revenue').val(result.max_revenue);
            $('#edit_accepts_defaults').prop('checked', !!result.accepts_defaults);
            $('#edit_min_credit_score').val(result.min_credit_score);
            $('#edit_max_nsf_per_month').val(result.max_nsf_per_month);
            $('#edit_min_deposits_per_month').val(result.min_deposits_per_month);
            $('#edit_excluded_industries').val(result.excluded_industries).trigger('change');
            $('#edit_excluded_states').val(result.excluded_states).trigger('change');
            $('#edit_has_integrated_api').prop('checked', !!result.has_integrated_api);
            $('#edit_api_key').val(result.api_key);

            // Positions checkboxes
            for (let i = 1; i <= 9; i++) {
                $('#edit_position' + i).prop('checked', false);
            }
            if (Array.isArray(result.positions)) {
                result.positions.forEach(function (v) {
                    $('#edit_position' + v).prop('checked', true);
                });
            }

            // Submission type
            if (result.submission_type === 'api') {
                $('#edit_submission_type').val('api');
                $('#edit_submission_type_api').prop('checked', true);
                $('#edit_submission_type_email').prop('checked', false);
            } else {
                $('#edit_submission_type').val('email');
                $('#edit_submission_type_email').prop('checked', true);
                $('#edit_submission_type_api').prop('checked', false);
            }

            $('#edit_lender').modal('show');
        }
    });
});

// Save changes handler
$(document).on('click', '#lender_save', function (e) {
    e.preventDefault();
    var form = $('#lender_edit');
    var formData = form.serialize();

    $.ajax({
        type: 'POST',
        url: form.attr('action'),
        data: formData,
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        success: function (data) {
            $('#edit_lender').modal('hide');
            location.reload();
        },
        error: function (xhr) {
            alert('Update failed');
        }
    });
});

$(function () {
    const csrf = $('meta[name=csrf-token]').attr('content');
    const BASE = '';


    $('#addUser').on('click', function (e) {
        e.preventDefault();
        $.get(`/permissions/all`, function (all) {
            const emptyUser = {
                first_name:'',
                last_name:'',
                email:'',
                email2:'',
                phone:'',
                commission_rate:'',
                team_leader_commission_rate:'',
                team_leader_id: '',
                roles:[],
                permissions:[]
            };
            $('#userModalTitle').text('Create User');
            renderUserForm('create', emptyUser, all, null);
            $('#userModal').modal('show');
        });
    });


    $(document).on('click', '.edit-user', function (e) {
        e.preventDefault();
        const id = $(this).data('id');
        $.get(`/users/${id}/edit`, function (data) {
            $.get(`/permissions/all`, function (all) {
                const user = { ...data.user, roles: data.roles || [], permissions: data.permissions || [], team_leader_id: data.team_leader_id || '' };
                $('#userModalTitle').text('Edit User');
                renderUserForm('edit', user, all, id);
                $('#userModal').modal('show');
            });
        });
    });


    function renderUserForm(mode, user, all, id) {
        const isCreate = mode === 'create';
        const actionUrl = isCreate ? `/users` : `/users/${id}`;
        const methodSpoof = isCreate ? '' : `<input type="hidden" name="_method" value="PUT">`;
        const passwordFields = isCreate ? `
      <div class="mb-3"><label>Password</label><input type="password" class="form-control" name="password"></div>
      <div class="mb-3"><label>Confirm Password</label><input type="password" class="form-control" name="password_confirmation"></div>
    ` : '';

        const form = `
      <form id="userForm" action="${actionUrl}" method="POST">
        <input type="hidden" name="_token" value="${csrf}">
        ${methodSpoof}

        <div class="row">
          <div class="col-md-6"><div class="mb-3">
            <label>First Name</label>
            <input type="text" class="form-control" name="first_name" value="${user.first_name || ''}">
          </div></div>
          <div class="col-md-6"><div class="mb-3">
            <label>Last Name</label>
            <input type="text" class="form-control" name="last_name" value="${user.last_name || ''}">
          </div></div>
        </div>

        <div class="mb-3"><label>Email 1</label>
          <input type="email" class="form-control" name="email" value="${user.email || ''}">
        </div>
        
        <div class="mb-3"><label>Email 2</label>
          <input type="email" class="form-control" name="email2" value="${user.email2 || ''}">
        </div>
        <div class="mb-3"><label>Phone</label>
          <input type="text" class="form-control" name="phone" value="${user.phone || ''}">
        </div>
        <div class="row">
          <div class="col-md-6">
            <div class="mb-3"><label>Commission Rate</label>
              <input type="number" step="0.01" class="form-control" name="commission_rate" value="${user.commission_rate ?? ''}">
            </div>
          </div>
          <div class="col-md-6" id="tlCommissionRateGroup" style="${((user.roles||[]).includes('Team_Lead')) ? '' : 'display:none;'}">
            <div class="mb-3"><label>Team Lead Commission Rate</label>
              <input type="number" step="0.01" class="form-control" name="team_leader_commission_rate" value="${user.team_leader_commission_rate ?? ''}">
            </div>
          </div>
        </div>

        <div class="mb-3"><label>Team Leader</label>
          <select class="form-select" name="team_leader_id">
            <option value="">-- Select Team Leader --</option>
            ${((all.team_leaders||[]).map(tl => 
            `<option value="${tl.id}" ${String(user.team_leader_id||'')===String(tl.id)?'selected':''}>${tl.name}</option>`
        )   .join(''))}
          </select>
        </div>

        ${passwordFields}

        <div class="mb-3"><label>Roles</label>
          <select class="form-select" name="roles[]" multiple>
            ${all.roles.map(r => `<option value="${r.name}" ${(user.roles||[]).includes(r.name)?'selected':''}>${r.name}</option>`).join('')}
          </select>
        </div>

        <div class="mb-3"><label>Permissions</label>
          <select class="form-select" name="permissions[]" multiple>
            ${all.permissions.map(p => `<option value="${p.name}" ${(user.permissions||[]).includes(p.name)?'selected':''}>${p.name}</option>`).join('')}
          </select>
        </div>

        <button type="submit" class="btn btn-primary">${isCreate ? 'Create' : 'Save'}</button>
      </form>
    `;

        $('#userFormContainer').html(form);

        // Toggle Team Lead commission field based on selected roles
        const $roles = $('#userForm select[name="roles[]"]');
        function syncTlField() {
            const vals = $roles.val() || [];
            const show = vals.includes('Team_Lead');
            $('#tlCommissionRateGroup').toggle(show);
        }
        $roles.on('change', syncTlField);
        syncTlField();

        $('#userForm').off('submit').on('submit', function (e) {
            e.preventDefault();
            $.ajax({
                url: actionUrl,
                type: 'POST',
                data: $(this).serialize(),
                headers: { 'X-CSRF-TOKEN': csrf },
                success: function (res) { if (res.success) location.reload(); },
                error: function (xhr) { console.error(xhr.responseText || xhr.statusText); }
            });
        });
    }

    // Delete
    let deleteId = null;
    $(document).on('click', '.delete-user', function (e) {
        e.preventDefault();
        deleteId = $(this).data('id');
        $('#deleteUserModal').modal('show');
    });
    $('#confirmDeleteUser').on('click', function () {
        if (!deleteId) return;
        $.ajax({
            url: `/users/${deleteId}`,
            type: 'DELETE',
            data: { _token: csrf },
            success: res => { if (res.success) location.reload(); }
        });
    });

    // Toggle status
    $(document).on('click', '.toggle-status', function (e) {
        e.preventDefault();
        const id = $(this).data('id');
        $.post(`/users/${id}/toggle-status`, { _token: csrf }, function (res) {
            if (res.success) location.reload();
        });
    });
});


$(document).ready(function() {
    $('.gutter-horizontal').remove();
    var sizes="{{$size}}";
    sizes=sizes.split(',').map(Number);
    function calcSize(tab,type){
        if(tab==='new'){
            return sizes;
        }
        num=0;
        switch(tab){
            case 'one':
                num=0;
                break;
            case 'two':
                num=1;
                break;
            case 'three':
                num=2;
                break;
            case 'four':
                num=3;
                break;

        }
        if(type != 'open'){
            sizes[num]=0;
        }
        else{
            sizes[num]=1;
        }
        var totalZero=sizes.filter(v => v === 0).length;
        var each_size= (100-(totalZero*4))/(sizes.length-totalZero);
        for(var i=0;i<sizes.length;i++){
            if(sizes[i]!==0){
                sizes[i]=each_size;
            }
        }
        return sizes;
    }
    function tabSizeCalc(num,type){
        var size=calcSize(num,type);
        var name=['one', 'two', 'three', 'four'];
        for (var i = 0; i < size.length; i++) {
            $('#'+name[i]).animate({ width: size[i] + '%' });

        }
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $.ajax({
            type: 'POST',
            url: '/store_sizes',
            data: { sizes: sizes },
            success: function(response) {
            }
        });
    }
    tabSizeCalc('new','open');


    $('.collapse-button_one, .collapse-button_two, .collapse-button_three, .collapse-button_four').click(function() {
        var target = $(this).parent().attr('id');
        $('#' + target).toggle();
        if ($('#' + target).is(':visible')) {
            $('#' + target).prev().remove();
            tabSizeCalc(target,'open');
        } else {
            var title='';
            switch(target){
                case 'one':
                    var title = 'SEARCH RESULTS';
                    break;
                case 'two':
                    var title = 'BORROWER & OPEN DEAL INFO';
                    break;
                case 'three':
                    var title = 'SELECTD LENDER';
                    break;
                case 'four':
                    var title = 'PREVIOUS LOANS';
                    break;
            }

            var titleBar = '<div id="new_'+target+'" style="width: 4%; display: inline-block; background: linear-gradient(to right, #BCBCBC, #E7E7E7);height: 100%;">  <div class="collapse-button" id="collapse_button_new_'+target+'"> <i class="fa fa-chevron-right"></i> </div><b><p class="text-info" style="writing-mode: vertical-rl;">' + title + '</p></b></div>';

            $('#' + target).before(titleBar);
            tabSizeCalc(target,'close');
            $('#collapse_button_new_'+target).click(function(){
                $('#' + target).toggle();
                $('#' + target).prev().remove();
                tabSizeCalc(target,'open');
            })
        }
    });
    const numberToString = {
        1: 'one',
        2: 'two',
        3: 'three',
        4: 'four'
    };
    for (var i = 1; i < (sizes.length + 1) ; i++) {
        if (sizes[i-1] === 0) {
            $('.collapse-button_' + numberToString[i]).trigger('click');
        }
    }
    $('#company_search').select2();
});
