@extends('layouts.app')
@section('title')
    Commissions
@endsection
@section('content')
@include('partials.navbar')
<div class="content-wrapper">
    @include('partials.sidebar')
    <main class="main-container" id="main_container">
        <div class="container-fluid w-100">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <div>
                                <h5 class="text-info">Commissions</h5>
                            </div>
                        </div>
                        <div class="card-body">

                            <!-- Summary Dashboard -->
                            <div class="row mb-3">
                                <div class="col-md-3">
                                    <div class="card text-white bg-primary">
                                        <div class="card-body">
                                            <div class="d-flex justify-content-between align-items-center">
                                                <div>
                                                    <div class="small">💼 Total Commission</div>
                                                    <div class="h5 mb-0">${{ number_format((float)($totalCommission ?? 0), 2) }}</div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="card text-white bg-secondary">
                                        <div class="card-body">
                                            <div class="small">⏳ Total Commission Lender</div>
                                            <div class="h5 mb-0">${{ number_format((float)($totalCommissionLender ?? 0), 2) }}</div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="card text-white bg-success">
                                        <div class="card-body">
                                            <div class="small">👤 Total Commission User</div>
                                            <div class="h5 mb-0">${{ number_format((float)($totalCommissionUser ?? 0), 2) }}</div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="card text-white bg-info">
                                        <div class="card-body">
                                            <div class="small">Count Of Deals</div>
                                            <div class="h5 mb-0">{{ (int)($countDeals ?? 0) }}</div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <form method="GET" action="{{ route('commissions.index') }}" class="mb-3">
                                <div class="row g-2">
                                    <div class="col-md-3">
                                        <label>Lender</label>
                                        <select name="lender_id" class="form-control">
                                            <option value="">All</option>
                                            @foreach($lenders as $lender)
                                                <option value="{{ $lender->id }}" {{ request('lender_id') == $lender->id ? 'selected' : '' }}>{{ $lender->company_name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-md-3">
                                        <label>User</label>
                                        <select name="user_id" class="form-control">
                                            <option value="">All</option>
                                            @foreach($users as $user)
                                                <option value="{{ $user->id }}" {{ request('user_id') == $user->id ? 'selected' : '' }}>{{ $user->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-md-3">
                                        <label>Lender Payment Status</label>
                                        <select name="lender_payment_status" class="form-control">
                                            <option value="">All</option>
                                            <option value="paid" {{ request('lender_payment_status') === 'paid' ? 'selected' : '' }}>Paid</option>
                                            <option value="unpaid" {{ request('lender_payment_status') === 'unpaid' ? 'selected' : '' }}>Unpaid</option>
                                            <option value="partial" {{ request('lender_payment_status') === 'partial' ? 'selected' : '' }}>Partial</option>
                                        </select>
                                    </div>
                                    <div class="col-md-3">
                                        <label>User Payment Status</label>
                                        <select name="user_status" class="form-control">
                                            <option value="">All</option>
                                            <option value="paid" {{ request('user_status') === 'paid' ? 'selected' : '' }}>Paid</option>
                                            <option value="unpaid" {{ request('user_status') === 'unpaid' ? 'selected' : '' }}>Unpaid</option>
                                            <option value="partial" {{ request('user_status') === 'partial' ? 'selected' : '' }}>Partial</option>
                                        </select>
                                    </div>
                                    <div class="col-md-3">
                                        <label>Funded Date From</label>
                                        <input type="date" name="date_from" class="form-control" value="{{ request('date_from') }}">
                                    </div>
                                    <div class="col-md-3">
                                        <label>Funded Date To</label>
                                        <input type="date" name="date_to" class="form-control" value="{{ request('date_to') }}">
                                    </div>
                                    <div class="col-md-3">
                                        <label>Paid Date From</label>
                                        <input type="date" name="paid_from" class="form-control" value="{{ request('paid_from') }}">
                                    </div>
                                    <div class="col-md-3">
                                        <label>Paid Date To</label>
                                        <input type="date" name="paid_to" class="form-control" value="{{ request('paid_to') }}">
                                    </div>
                                    <div class="col-md-4">
                                        <label>Search</label>
                                        <input type="text" name="search" class="form-control" placeholder="Search by deal, lender, user, loan #" value="{{ request('search') }}">
                                    </div>
                                    <div class="col-md-2 align-self-end">
                                        <button type="submit" class="btn btn-primary w-100">Filter</button>
                                    </div>
                                </div>
                            </form>

                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Funded date</th>
                                        <th>Deal</th>
                                        <th>Lender</th>
                                        <th>Funded Amount</th>
                                        <th>Points</th>
                                        <th>Total CM</th>
                                        <th>Sales Rep</th>
                                        <th>Sales Rep CM</th>
                                        <th>Team Leader</th>
                                        <th>Team Leader CM</th>
                                        <th>Remainder</th>
                                        <th>Paid Amount</th>
                                        <th>Paid At</th>
                                        <th>Action</th>

{{--                                        <th>User</th>--}}
{{--                                        <th>Amount</th>--}}
{{--                                        <th>Status</th>--}}
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($commissions as $commission)

                                        @php
                                            $loan = $commission->loan;
                                            $fundedAmount = optional($loan)->funded_amount ?? null;
                                            $points = optional($loan)->points ?? null;
                                            $totalCm = optional($loan)->total_commision ?? null;


                                            $salesRepName = $commission->user->name ?? '';
                                            // Use stored values from commissions table
                                            $salesRepCm = is_numeric($commission->sales_rep_cm ?? null) ? (float)$commission->sales_rep_cm : null;

                                            // Team Leader
                                            $leaderId = $leaderInfoByDeal[$commission->deal_id]['leader_id'] ?? null;
                                            $leaderName = $leaderInfoByDeal[$commission->deal_id]['leader_name'] ?? '';
                                            $leaderCm = is_numeric($commission->team_leader_cm ?? null) ? (float)$commission->team_leader_cm : null;

                                            // Remainder: Total CM – Amount Paid
                                            $remainder = null;
                                            if (!is_null($totalCm)) {
                                                $amountPaid = is_numeric($commission->amount_paid ?? null) ? (float)$commission->amount_paid : 0.0;
                                                $remainder = (float)$totalCm - $amountPaid;
                                            }
                                        @endphp
                                        <tr>
                                            <td>{{ optional(optional($loan)->date_funded)->format('Y-m-d') }}</td>
                                            <td>{{ $commission->deal->company_name ?? '' }}</td>
                                            <td>{{ optional($commission->lender)->company_name ?? optional($commission->lender)->name ?? '' }}</td>
                                            <td>{{ !is_null($fundedAmount) ? number_format($fundedAmount, 2) : '' }}</td>
                                            <td>{{ !is_null($points) ? number_format($points, 2) : '' }}</td>
                                            <td>{{ !is_null($totalCm) ? number_format($totalCm, 2) : '' }}</td>
                                            <td>{{ $salesRepName }}</td>

                                            <td>
                                                @if(!is_null($salesRepCm))
                                                    <div>{{ number_format((float)$salesRepCm, 2) }}</div>
                                                    <label class="small mb-0">
                                                        <input type="checkbox" class="cm-paid-toggle" data-id="{{ $commission->id }}" data-field="sales_rep_paid" {{ ($commission->sales_rep_paid ?? false) ? 'checked' : '' }}>
                                                        <span class="cm-paid-label">{{ ($commission->sales_rep_paid ?? false) ? 'Paid' : 'Unpaid' }}</span>
                                                    </label>
                                                @endif
                                            </td>

                                            <td>{{ $leaderName }}</td>
                                            <td>
                                                @if(!is_null($leaderCm))
                                                    <div>{{ number_format((float)$leaderCm, 2) }}</div>
                                                    <label class="small mb-0">
                                                        <input type="checkbox" class="cm-paid-toggle" data-id="{{ $commission->id }}" data-field="team_leader_paid" {{ ($commission->team_leader_paid ?? false) ? 'checked' : '' }}>
                                                        <span class="cm-paid-label">{{ ($commission->team_leader_paid ?? false) ? 'Paid' : 'Unpaid' }}</span>
                                                    </label>
                                                @endif
                                            </td>
                                            <td>{{ !is_null($remainder) ? number_format($remainder, 2) : '' }}</td>
                                            <td>{{ !is_null($commission->amount_paid) ? number_format((float)$commission->amount_paid, 2) : '' }}</td>
                                            <td>{{ optional($commission->paid_at)->format('Y-m-d') }}</td>
                                            <td>
                                                @if($commission->status !== 'paid')
                                                    <form method="POST" action="{{ route('commissions.markPaid') }}" style="display:inline-block;">
                                                        @csrf
                                                        <input type="hidden" name="id" value="{{ $commission->id }}">
                                                        <input type="number" name="amount_paid" placeholder="Amount" step="0.01" min="0" required>
                                                        <button type="submit" class="btn btn-success btn-sm">Mark Paid</button>
                                                    </form>
                                                    <form method="POST" action="{{ route('commissions.markPartial') }}" style="display:inline-block;">
                                                        @csrf
                                                        <input type="hidden" name="id" value="{{ $commission->id }}">
                                                        <input type="number" name="amount_paid" placeholder="Amount" step="0.01" min="0" required>
                                                        <button type="submit" class="btn btn-warning btn-sm">Mark Partial</button>
                                                    </form>
                                                @endif
                                            </td>
                                            
{{--                                            <td>{{ $commission->user->name ?? '' }}</td>--}}
{{--                                            <td>{{ $commission->amount }}</td>--}}
{{--                                            <td>{{ ucfirst($commission->status) }}</td>--}}
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>

                            <script>
                                document.addEventListener('change', function (e) {
                                    const cb = e.target.closest('.cm-paid-toggle');
                                    if (!cb) return;
                                    const id = cb.getAttribute('data-id');
                                    const field = cb.getAttribute('data-field');
                                    const value = cb.checked ? 1 : 0;
                                    const labelEl = cb.parentElement.querySelector('.cm-paid-label');
                                    fetch("{{ route('commissions.toggleCmPaid') }}", {
                                        method: 'POST',
                                        headers: {
                                            'Content-Type': 'application/json',
                                            'Accept': 'application/json',
                                            'X-CSRF-TOKEN': "{{ csrf_token() }}",
                                        },
                                        body: JSON.stringify({ id, field, value })
                                    })
                                    .then(res => res.ok ? res.json() : Promise.reject())
                                    .then(json => {
                                        if (json && json.ok) {
                                            if (labelEl) labelEl.textContent = json.value ? 'Paid' : 'Unpaid';
                                        } else {
                                            cb.checked = !cb.checked;
                                            alert('Failed to update.');
                                        }
                                    })
                                    .catch(() => {
                                        cb.checked = !cb.checked;
                                        alert('Failed to update.');
                                    });
                                });
                            </script>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
</div>
@endsection
