@extends('layouts.app')
@section('title')
    Emails
@endsection

@section('scripts')
<script>
$(document).ready(function() {
    $('.select_2').select2({
        tags: true,
        tokenSeparators: [',', ' '],
        width: '100%'
    });
});
</script>
@endsection
@section('content')
    @include('partials.navbar')
    <div class="content-wrapper">
        @include('partials.sidebar')

        <main class="main-container" id="main_container">
            <div class="container-fluid w-100">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <div>
                                    <h5 class="text-info">Emails</h5>
                                </div>
                                <div class="d-flex justify-content-between align-items-center">
                                    <div class="ms-2">
                                        <span>
                                            <i class='bx bx-cog'></i>
                                        </span>
                                    </div>
                                    <div class="ms-2">
                                        <span>
                                            <i class='fas fa-caret-down'></i>
                                        </span>
                                    </div>
                                    <div class="ms-2">
                                        <span>
                                            <i class='fas fa-sync'></i>
                                        </span>
                                    </div>

                                </div>

                            </div>
                            <div class="card-body">
                                <div class="table-wrapper">
                                    <div class="row">
                                        <form action="{{route('email.add')}}" method="post">
                                            @csrf
                                            <div class="row mb-2">
                                                <label for="app_submit" class="col-sm-2 col-form-label">Emails for App Submit</label>
                                                <div class="col-sm-9">
                                                    <select class="form-control form-control-sm select_2" multiple name="app_submit[]">
                                                        @foreach($em as $item)
                                                              <option value={{$item->email}} selected>{{$item->email}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                @error('app_submit')
                                                    <p class="text-danger fw-semibold">{{ $message }}</p>
                                                @enderror
                                            </div>
                                            <div class="row mb-2">
                                                <label for="proc_submit" class="col-sm-2 col-form-label">Emails for Processor</label>
                                                <div class="col-sm-9">
                                                    <select class="form-control form-control-sm select_2" multiple name="proc_submit[]">
                                                        @foreach($em_p as $item)
                                                              <option value={{$item->email}} selected>{{$item->email}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                @error('proc_submit')
                                                    <p class="text-danger fw-semibold">{{ $message }}</p>
                                                @enderror
                                            </div>
                                            <div class="modal-footer">
                                                <input type="submit" class="btn submit_button" value="Save">
                                            </div>
                                        </form>


                                    </div>
                                </div>

                            </div>
                        </div>

                    </div>
                </div>
            </div>
    </div>
    </div>
    </main>
    </div>

    @if (Session::has('success'))
        <script>
            Swal.fire({
                position: 'top-end',
                icon: 'success',
                title: "{!! Session::get('success') !!}",
                showConfirmButton: false,
                timer: 1500
            });
        </script>
    @endif
    @if (Session::has('error'))
        <script>
            Swal.fire({
                position: 'top-end',
                icon: 'error',
                title: "{!! Session::get('error') !!}",
                showConfirmButton: false,
                timer: 1500
            });
        </script>
    @endif
    @push('custom-scripts')
        <script>
            $(document).ready(function() {
                $('.select_2').select2({
                  tags: true
                });
            });
        </script>
    @endpush
@endsection
