<!doctype html>
<html lang="en">
<head>

    {{-- --- PRELOAD SAFETY: prevent sidebar flash BEFORE CSS loads --- --}}
    <style>
        /* Hide sidebar + main content before CSS loads */
        html:not(.loaded) .sidebar,
        html:not(.loaded) .main-container {
            opacity: 0 !important;
        }

        /* Smooth fade-in after page is fully ready */
        html.loaded .sidebar,
        html.loaded .main-container {
            opacity: 1 !important;
            transition: opacity 0.15s ease-in-out;
        }
    </style>

    {{-- MUST BE FIRST — restore saved collapsed state BEFORE CSS renders --}}
    <script>
        (function () {
            if (localStorage.getItem('sidebar_collapsed') === '1') {
                document.documentElement.classList.add('sidebar-collapsed');
            }
        })();
    </script>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title','Funders CRM')</title>

    <link rel="shortcut icon" href="{{ asset('files/salesdeals.png') }}">

    {{-- MAIN COMPILED CSS --}}
    <link rel="stylesheet" href="{{ mix('/css/app.css') }}">

    {{-- External CSS --}}
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://golden-layout.com/files/latest/css/goldenlayout-base.css" />

    @yield('header-custom-tags')
</head>

<body>

    @yield('content')

    {{-- JS Libraries --}}
    <script src="https://kit.fontawesome.com/a2afe66590.js" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/split.js/1.6.0/split.min.js"></script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.3/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>

    {{-- Compiled App JS --}}
    <script src="{{ mix('/js/app.js') }}" defer></script>

    @stack('scripts')
    @yield('scripts')

    {{-- page fully ready → reveal sidebar + main --}}
    <script>
        window.addEventListener("load", function () {
            document.documentElement.classList.add("loaded");
        });
    </script>

</body>
</html>
