@extends('layouts.app')
@section('title')
    Selected Lender
@endsection
@section('header-custom-tags')
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<style>
    #one, #two, #three, #four {
        min-width: 0;
        box-sizing: border-box;
        width: auto;
    }
</style>
@endsection
@section('content')

    @include('partials.navbar')

    <div class="wrapper">
        @include('partials.sidebar')
        <main class="main-container" id="main_container">
            <div class="container-fluid pt-2" style="height: 100%;">
                <div class="row " style="overflow-x: auto; height: 100%; flex-wrap: nowrap;">
                    
                    <div id="one">
                        <div class="collapse-button_one" id="collapse_button">
                            <i class="fa fa-chevron-left"></i>
                        </div>
                        @include('partials.deal')
                        @include('partials.deal_modal')
                    </div>
                    
                    <div id="two" >  
                        <div class="collapse-button_two" id="collapse_button">
                            <i class="fa fa-chevron-left"></i>
                        </div>
                        @include('partials.lender')
                    </div>
                    
                    <div id="three">
                        <div class="collapse-button_three" id="collapse_button">
                            <i class="fa fa-chevron-left"></i>
                        </div>
                        @include('partials.offer_modal')
                        @include('partials.rep')
                    </div>
                    @include('partials.offer_modal')
                    @include('partials.assign_lender')

                    <div id="four">
                        <div class="collapse-button_four" id="collapse_button">
                            <i class="fa fa-chevron-left"></i>
                        </div>
                        @include('partials.loan')
                    </div>

                </div>
                
            </div>
        </main>
    </div>

    @push('custom-scripts')
        <script type="text/javascript" src="{{ URL::asset('assets/js/custom-scripts.js') }}"></script>
        @if (Session::has('success'))
            <script>
                $(document).ready(function() {
                    Swal.fire({
                        position: 'top-end',
                        icon: 'success',
                        title: "{!! Session::get('success') !!}",
                        showConfirmButton: false,
                        timer: 1500
                    });
                });
            </script>
        @endif
    @endpush    

@endsection
