 <div class="modal fade" id="add_deal" tabindex="-1" aria-labelledby="add_deal" aria-hidden="true">
     <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable">
         <div class="modal-content">
             <div class="modal-header">
                 <h1 class="modal-title fs-5" id="add_deal">New Deal</h1>
                 <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
             </div>
             <div class="modal-body">
                 <form method="POST" action="{{route('add_deal')}}" enctype="multipart/form-data" id="new_deal">
                     @csrf
                     <div class="row g-3">
                         <!-- Left column: form fields -->
                         <div class="col-12 col-lg-7">
                             <div class="vstack gap-2">
                                 <div>
                                     <label for="lead_source" class="form-label">Lead Source</label>
                                     <select class="form-select form-select-sm" id="lead_source" name="lead_source">
                                         <option value="" selected>Select lead source</option>
                                         <option>Inbound</option>
                                         <option>Outbound</option>
                                         <option>Referral</option>
                                         <option>Partner</option>
                                     </select>
                                 </div>
                                 <div>
                                     <label for="lender_rule" class="form-label">Lender Rule</label>
                                     <select class="form-select form-select-sm" id="lender_rule" name="lender_rule">
                                         <option value="" selected>Select lender rule</option>
                                         <option>Auto</option>
                                         <option>Manual</option>
                                     </select>
                                 </div>
                                 <div>
                                     <label for="sale_rep" class="form-label">Sales Rep <span class="text-danger">*</span></label>
                                     <select class="form-select form-select-sm" id="sale_rep" name="sale_rep" required>
                                         <option value="" {{ old('sale_rep', '') === '' ? 'selected' : '' }}>Select</option>
                                         @foreach ($reps as $item)
                                             <option value="{{$item->name}}" {{ old('sale_rep','jenkins, Rob') === $item->name ? 'selected' : '' }}>{{$item->name}}</option>
                                         @endforeach
                                     </select>
                                     @error('sale_rep')<p class="text-danger fw-semibold">{{$message}}</p>@enderror
                                 </div>
                                 <div>
                                     <label for="sale_rep2" class="form-label">Sales Rep 2</label>
                                     <select class="form-select form-select-sm" name="sale_rep2" id="sale_rep2">
                                         <option value="" selected>Select</option>
                                         @foreach ($reps as $item)
                                             <option value="{{$item->name}}">{{$item->name}}</option>
                                         @endforeach
                                     </select>
                                     @error('sale_rep2')<p class="text-danger fw-semibold">{{$message}}</p>@enderror
                                 </div>
                                 <div>
                                     <label for="company_name" class="form-label">Company Name <span class="text-danger">*</span></label>
                                     <input type="text" class="form-control form-control-sm" name="company_name" value="{{old('company_name')}}" id="company_name" required>
                                     @error('company_name')<p class="text-danger fw-semibold">{{$message}}</p>@enderror
                                 </div>
                                 <div>
                                     <label for="marchant_name" class="form-label">Merchant Name <span class="text-danger">*</span></label>
                                     <input type="text" class="form-control form-control-sm" name="marchant_name" value="{{old('marchant_name')}}" id="marchant_name" required>
                                     @error('merchant_name')<p class="text-danger fw-semibold">{{$message}}</p>@enderror
                                 </div>
                                 <div>
                                     <label for="email" class="form-label">Email Address <span class="text-danger">*</span></label>
                                     <input type="email" class="form-control form-control-sm" name="email" value="{{old('email')}}" id="email" required>
                                     @error('email')<p class="text-danger fw-semibold">{{$message}}</p>@enderror
                                 </div>
                                 <div>
                                     <label for="phone_number" class="form-label">Phone Number <span class="text-danger">*</span></label>
                                     <input type="text" class="form-control form-control-sm" name="phone_number" value="{{old('phone_number')}}" id="phone_number" required>
                                     @error('phone_number')<p class="text-danger fw-semibold">{{$message}}</p>@enderror
                                 </div>
                                 <div>
                                     <label for="cell_phone" class="form-label">Cell Phone</label>
                                     <input type="text" class="form-control form-control-sm" name="cell_phone" id="cell_phone" value="{{old('cell_phone')}}">
                                 </div>
                                 <div>
                                     <label for="requested_amount" class="form-label">Requested Amount <span class="text-danger">*</span></label>
                                     <input type="number" class="form-control form-control-sm" name="request_amount" value="{{old('request_amount')}}" id="requested_amount" required>
                                     @error('requested_amount')<p class="text-danger fw-semibold">{{$message}}</p>@enderror
                                 </div>
                                 <div>
                                     <label for="industry" class="form-label">Industry <span class="text-danger">*</span></label>
                                     <select class="form-select form-select-sm" id="industry" name="industry" required>
                                         <option value="" selected>Select industry</option>
                                         <option>Construction</option>
                                         <option>Retail</option>
                                         <option>Restaurant</option>
                                         <option>Healthcare</option>
                                         <option>Other</option>
                                     </select>
                                 </div>
                                 <div>
                                     <label for="application_industry" class="form-label">Application Industry</label>
                                     <input type="text" class="form-control form-control-sm" id="application_industry" name="application_industry" value="{{ old('application_industry') }}">
                                 </div>
                                 <div>
                                     <label for="loan_purpose" class="form-label">Loan Purpose <span class="text-danger">*</span></label>
                                     <select class="form-select form-select-sm" id="loan_purpose" name="loan_purpose" required>
                                         <option value="" selected>Select purpose</option>
                                         <option>Working Capital</option>
                                         <option>Expansion</option>
                                         <option>Equipment</option>
                                         <option>Refinance</option>
                                         <option>Other</option>
                                     </select>
                                 </div>
                                 <div>
                                     <label for="application_purpose" class="form-label">Application Purpose</label>
                                     <input type="text" class="form-control form-control-sm" id="application_purpose" name="application_purpose" value="{{ old('application_purpose') }}">
                                 </div>
                                 <div>
                                     <label for="existing_loans" class="form-label">Number of Existing Loans</label>
                                     <input type="number" class="form-control form-control-sm" id="existing_loans" name="existing_loans" value="{{ old('existing_loans') }}">
                                 </div>
                                 <div>
                                     <label for="annual_revenue" class="form-label">Annual Revenue</label>
                                     <input type="number" class="form-control form-control-sm" id="annual_revenue" name="annual_revenue" value="{{ old('annual_revenue') }}">
                                 </div>
                                 <div>
                                     <label for="average_balance" class="form-label">Average Balance</label>
                                     <input type="text" class="form-control form-control-sm" id="average_balance" name="average_balance" placeholder="we will try to get from bank statement" value="{{ old('average_balance') }}">
                                 </div>
                                 <div>
                                     <label for="business_start_date" class="form-label">Business Start Date</label>
                                     <input type="date" class="form-control form-control-sm" id="business_start_date" name="business_start_date" value="{{ old('business_start_date') }}">
                                 </div>
                                 <div>
                                     <label for="state" class="form-label">State / Province <span class="text-danger">*</span></label>
                                     <select class="form-select form-select-sm" id="state" name="state" required>
                                         <option value="" selected>Select state</option>
                                         <option>AL</option>
                                         <option>AK</option>
                                         <option>AZ</option>
                                         <option>AR</option>
                                         <option>CA</option>
                                         <option>CO</option>
                                         <option>CT</option>
                                         <option>DE</option>
                                         <option>FL</option>
                                         <option>GA</option>
                                         <option>HI</option>
                                         <option>ID</option>
                                         <option>IL</option>
                                         <option>IN</option>
                                         <option>IA</option>
                                         <option>KS</option>
                                         <option>KY</option>
                                         <option>LA</option>
                                         <option>ME</option>
                                         <option>MD</option>
                                         <option>MA</option>
                                         <option>MI</option>
                                         <option>MN</option>
                                         <option>MS</option>
                                         <option>MO</option>
                                         <option>MT</option>
                                         <option>NE</option>
                                         <option>NV</option>
                                         <option>NH</option>
                                         <option>NJ</option>
                                         <option>NM</option>
                                         <option>NY</option>
                                         <option>NC</option>
                                         <option>ND</option>
                                         <option>OH</option>
                                         <option>OK</option>
                                         <option>OR</option>
                                         <option>PA</option>
                                         <option>RI</option>
                                         <option>SC</option>
                                         <option>SD</option>
                                         <option>TN</option>
                                         <option>TX</option>
                                         <option>UT</option>
                                         <option>VT</option>
                                         <option>VA</option>
                                         <option>WA</option>
                                         <option>WV</option>
                                         <option>WI</option>
                                         <option>WY</option>
                                         <option>Other</option>
                                     </select>
                                 </div>
                                 <div>
                                     <label for="credit_score" class="form-label">Credit Score <span class="text-danger">*</span></label>
                                     <input type="number" class="form-control form-control-sm" id="credit_score" name="credit_score" value="{{ old('credit_score') }}" min="300" max="850" step="1" inputmode="numeric" required>
                                     @error('credit_score')<p class="text-danger fw-semibold">{{$message}}</p>@enderror
                                 </div>
                                 <div>
                                     <label for="status" class="form-label">Status</label>
                                     <input type="text" class="form-control form-control-sm" id="status" name="status" value="{{ old('status','Submitted') }}">
                                 </div>
                                 <div>
                                     <label for="date_submitted" class="form-label">Date Submitted</label>
                                     <input type="date" class="form-control form-control-sm" id="date_submitted" name="date_submitted" value="{{ old('date_submitted','2025-09-04') }}">
                                 </div>
                                 <div>
                                     <label for="quick_add_notes" class="form-label">Quick Add Notes</label>
                                     <textarea class="form-control form-control-sm" id="quick_add_notes" name="quick_add_notes" rows="3" placeholder="Enter a new note here to be">{{ old('quick_add_notes') }}</textarea>
                                 </div>
                             </div>
                         </div>

                         <!-- Right column: file drop area -->
                         <div class="col-12 col-lg-5">
                             <div id="deal-drop-zone" class="border border-2 border-dashed rounded-3 p-4 text-center" style="border-style: dashed !important; min-height: 300px; display: flex; flex-direction: column; justify-content: center; align-items: center; gap: 10px; cursor: pointer;">
                                 <div class="fw-semibold">Drop files here!</div>
                                 <div class="text-muted small">Drop the files you’d like to upload, paste an image, or Select files</div>
                                 <label class="btn btn-outline-secondary btn-sm mt-2 mb-2">
                                     Select files
                                     <input type="file" id="files" name="files[]" class="d-none" multiple>
                                 </label>
                             </div>
                             <ul id="selected-files" class="list-unstyled small text-start w-100 mt-2" style="max-height: 120px; overflow: auto;"></ul>
                         </div>

                     </div>
                 </form>
             </div>
             <div class="modal-footer d-flex justify-content-end">
                 <button type="submit" form="new_deal" name="submit_d" value="simple" class="btn btn-success">Submit Deal</button>
                 <button type="submit" form="new_deal" name="submit_d" value="notify" class="btn btn-success ms-2">Submit & Notify Processor</button>
             </div>
         </div>
     </div>
 </div>

 <script>
 (function() {
     const dropZone = document.getElementById('deal-drop-zone');
     const fileInput = document.getElementById('files');
     const list = document.getElementById('selected-files');
     const form = document.getElementById('new_deal');

     if (!dropZone || !fileInput) return;

     // Visual helpers
     const setHighlight = (on) => {
         dropZone.style.backgroundColor = on ? 'rgba(25,135,84,0.06)' : '';
         dropZone.style.borderColor = on ? '#198754' : '';
     };

     // Open picker when clicking the zone (but ignore clicks on inner label which already opens it)
     dropZone.addEventListener('click', (e) => {
         // If user clicked the label or input, let default happen
         if (e.target.tagName.toLowerCase() === 'label' || e.target.tagName.toLowerCase() === 'input') return;
         fileInput.click();
     });

     // Prevent default browser behavior for drag & drop
     ['dragenter', 'dragover', 'dragleave', 'drop'].forEach(eventName => {
         dropZone.addEventListener(eventName, (e) => {
             e.preventDefault();
             e.stopPropagation();
         });
     });

     ['dragenter', 'dragover'].forEach(eventName => {
         dropZone.addEventListener(eventName, () => setHighlight(true));
     });
     ;['dragleave', 'drop'].forEach(eventName => {
         dropZone.addEventListener(eventName, () => setHighlight(false));
     });

     dropZone.addEventListener('drop', (e) => {
         const dt = e.dataTransfer;
         if (!dt || !dt.files || !dt.files.length) return;
         assignFiles(dt.files);
     });

     // Paste support (images/files from clipboard)
     dropZone.addEventListener('paste', (e) => {
         const items = e.clipboardData && e.clipboardData.items ? e.clipboardData.items : [];
         const files = [];
         for (let i = 0; i < items.length; i++) {
             const it = items[i];
             if (it.kind === 'file') {
                 const f = it.getAsFile();
                 if (f) files.push(f);
             }
         }
         if (files.length) {
             assignFiles(files);
         }
     });

     // When user selects via picker, accumulate with any previously selected files
     let __prevPickerSnapshot = [];
     fileInput.addEventListener('click', () => {
         // Snapshot currently selected files before the picker opens (so we can merge later)
         __prevPickerSnapshot = fileInput.files ? Array.from(fileInput.files) : [];
     });
     fileInput.addEventListener('change', (e) => {
         const dt = new DataTransfer();
         // Add previously selected files snapshot (if any)
         if (__prevPickerSnapshot && __prevPickerSnapshot.length) {
             __prevPickerSnapshot.forEach(f => dt.items.add(f));
         } else if (fileInput._persistedFiles && fileInput._persistedFiles.length) {
             // Fallback: if snapshot wasn't captured, use persisted files we track
             fileInput._persistedFiles.forEach(f => dt.items.add(f));
         }
         // Add newly picked files
         Array.from(e.target.files || []).forEach(f => dt.items.add(f));

         fileInput.files = dt.files;
         // Persist for next interactions
         fileInput._persistedFiles = Array.from(fileInput.files);
         __prevPickerSnapshot = [];
         refreshList(fileInput.files);
     });

     function assignFiles(newFiles) {
         // Merge existing and new files into a single DataTransfer
         const dt = new DataTransfer();
         // Keep previously chosen
         if (fileInput.files && fileInput.files.length) {
             for (let i = 0; i < fileInput.files.length; i++) {
                 dt.items.add(fileInput.files[i]);
             }
         }
         // Add new ones
         for (let i = 0; i < newFiles.length; i++) {
             dt.items.add(newFiles[i]);
         }
         fileInput.files = dt.files;
         // Persist for later picker merges and consistency
         fileInput._persistedFiles = Array.from(fileInput.files);
         refreshList(fileInput.files);
     }

     function refreshList(files) {
         if (!list) return;
         // Preserve previous selections
         const prevSelections = Array.from(list.querySelectorAll('select[name="file_types[]"]')).map(sel => sel.value);
         list.innerHTML = '';
         if (!files || !files.length) return;
         Array.from(files).forEach((f, idx) => {
             const li = document.createElement('li');
             li.className = 'd-flex align-items-center justify-content-between gap-2 mb-1';

             const nameSpan = document.createElement('span');
             nameSpan.textContent = (idx + 1) + '. ' + f.name + ' (' + formatBytes(f.size) + ')';

             const select = document.createElement('select');
             select.name = 'file_types[]';
             select.className = 'form-select form-select-sm';
             select.style.maxWidth = '220px';

             const options = [
                 { value: '', label: 'Select type' },
                 { value: 'Application', label: 'Application' },
                 { value: 'Driver’s License', label: 'Driver’s License' },
                 { value: 'Bank Statement', label: 'Bank Statement' },
                 { value: 'Voided Check', label: 'Voided Check' },
                 { value: 'Tax Return', label: 'Tax Return' },
                 { value: 'Other', label: 'Other' },
             ];
             options.forEach(opt => {
                 const o = document.createElement('option');
                 o.value = opt.value;
                 o.textContent = opt.label;
                 select.appendChild(o);
             });
             if (prevSelections[idx]) {
                 select.value = prevSelections[idx];
             }

             li.appendChild(nameSpan);
             li.appendChild(select);
             list.appendChild(li);
         });
     }

     function formatBytes(bytes) {
         if (bytes === 0) return '0 B';
         const k = 1024;
         const sizes = ['B', 'KB', 'MB', 'GB', 'TB'];
         const i = Math.floor(Math.log(bytes) / Math.log(k));
         return parseFloat((bytes / Math.pow(k, i)).toFixed(2)) + ' ' + sizes[i];
     }
 })();
 </script>
 