@php
  \Log::debug('Rendering lender_modal.blade.php: Add Lender modal partial loaded');
@endphp
<!-- Add Lender Modal -->
<div class="modal fade" id="add_lender" tabindex="-1" aria-labelledby="add_lender_label" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <form action="{{ route('add_lender') }}" method="POST">
        @csrf
        <div class="modal-header">
          <h1 class="modal-title fs-5" id="add_lender_label">Add Lender</h1>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>

        <div class="modal-body">
          <div class="row mb-2">
            <label for="company_name_add" class="col-sm-2 col-form-label">Company Name</label>
            <div class="col-sm-10">
              <input type="text" class="form-control form-control-sm" name="company_name" id="company_name_add" value="{{ old('company_name') }}" required>
            </div>
            @error('company_name') <p class="text-danger fw-semibold">{{ $message }}</p> @enderror
          </div>

          <div class="row mb-2">
            <label for="primary_contact" class="col-sm-2 col-form-label">Primary Contact</label>
            <div class="col-sm-10">
              <input type="text" class="form-control form-control-sm" name="primary_contact" id="primary_contact" value="{{ old('primary_contact') }}">
            </div>
            @error('primary_contact') <p class="text-danger fw-semibold">{{ $message }}</p> @enderror
          </div>

          <div class="row mb-2">
            <label for="phone" class="col-sm-2 col-form-label">Phone</label>
            <div class="col-sm-10">
              <input type="text" class="form-control form-control-sm" name="phone" id="phone" value="{{ old('phone') }}">
            </div>
            @error('phone') <p class="text-danger fw-semibold">{{ $message }}</p> @enderror
          </div>

          <div class="row mb-2">
            <label for="email" class="col-sm-2 col-form-label">Rep Email</label>
            <div class="col-sm-10">
              <input type="email" class="form-control form-control-sm" name="email" id="email" value="{{ old('email') }}">
            </div>
            @error('email') <p class="text-danger fw-semibold">{{ $message }}</p> @enderror
          </div>

          <div class="row mb-2">
            <label for="email2" class="col-sm-2 col-form-label">Submission Email</label>
            <div class="col-sm-10">
              <input type="email" class="form-control form-control-sm" name="email2" id="email2" value="{{ old('email2') }}">
            </div>
            @error('email2') <p class="text-danger fw-semibold">{{ $message }}</p> @enderror
          </div>

{{--          <div class="row mb-2">--}}
{{--            <label for="code" class="col-sm-2 col-form-label">Code</label>--}}
{{--            <div class="col-sm-10">--}}
{{--              <input type="text" class="form-control form-control-sm" name="code" id="code" value="{{ old('code') }}">--}}
{{--            </div>--}}
{{--            @error('code') <p class="text-danger fw-semibold">{{ $message }}</p> @enderror--}}
{{--          </div>--}}

          <div class="row mb-2">
            <label for="last_contacted" class="col-sm-2 col-form-label">Last Contacted</label>
            <div class="col-sm-10">
              <input type="date" class="form-control form-control-sm" name="last_contacted" id="last_contacted" value="{{ old('last_contacted') }}">
            </div>
            @error('last_contacted') <p class="text-danger fw-semibold">{{ $message }}</p> @enderror
          </div>

          <div class="row mb-2">
            <label for="position" class="col-sm-2 col-form-label">Positions</label>
            <div class="col-sm-10">
              <div class="d-flex flex-wrap gap-2">
                @for ($i = 1; $i <= 9; $i++)
                  <div class="form-check form-check-inline">
                    <input class="form-check-input" type="checkbox" name="positions[]" id="position{{ $i }}" value="{{ $i }}">
                    <label class="form-check-label me-2" for="position{{ $i }}">{{ $i }}</label>
                  </div>
                @endfor
              </div>
            </div>
          </div>

          <div class="row mb-2">
            <label for="min_time_in_business" class="col-sm-2 col-form-label">Min Time in Business (months)</label>
            <div class="col-sm-10">
              <input type="number" class="form-control form-control-sm" name="min_time_in_business" id="min_time_in_business" min="0">
            </div>
          </div>

          <div class="row mb-2">
            <label for="min_revenue" class="col-sm-2 col-form-label">Min Revenue</label>
            <div class="col-sm-5">
              <input type="number" class="form-control form-control-sm" name="min_revenue" id="min_revenue" min="0">
            </div>
            <label for="max_revenue" class="col-sm-2 col-form-label">Max Revenue</label>
            <div class="col-sm-3">
              <input type="number" class="form-control form-control-sm" name="max_revenue" id="max_revenue" min="0">
            </div>
          </div>

          <div class="row mb-2">
            <label class="col-sm-2 col-form-label">Accepts Defaults</label>
            <div class="col-sm-10">
              <input class="form-check-input" type="checkbox" name="accepts_defaults" id="accepts_defaults" value="1">
            </div>
          </div>

          <div class="row mb-2">
            <label for="min_credit_score" class="col-sm-2 col-form-label">Min Credit Score</label>
            <div class="col-sm-10">
              <input type="number" class="form-control form-control-sm" name="min_credit_score" id="min_credit_score" min="0" max="850">
            </div>
          </div>

          <div class="row mb-2">
            <label for="max_nsf_per_month" class="col-sm-2 col-form-label">Max NSF/Month</label>
            <div class="col-sm-10">
              <input type="number" class="form-control form-control-sm" name="max_nsf_per_month" id="max_nsf_per_month" min="0">
            </div>
          </div>

          <div class="row mb-2">
            <label for="min_deposits_per_month" class="col-sm-2 col-form-label">Min Deposits/Month</label>
            <div class="col-sm-10">
              <input type="number" class="form-control form-control-sm" name="min_deposits_per_month" id="min_deposits_per_month" min="0">
            </div>
          </div>

          <div class="row mb-2">
            <label for="excluded_industries" class="col-sm-2 col-form-label">Excluded Industries</label>
            <div class="col-sm-10">
              <select class="form-select form-select-sm" name="excluded_industries[]" id="excluded_industries" multiple>
                <option value="Accounting">Accounting</option>
                <option value="Adult Entertainment">Adult Entertainment</option>
                <option value="Agricultural Services">Agricultural Services</option>
                <option value="Auto Repair">Auto Repair</option>
                <option value="Auto Sales">Auto Sales</option>
                <option value="Bail Bonds">Bail Bonds</option>
                <option value="Building and Constructions">Building and Constructions</option>
                <option value="Business Services">Business Services</option>
                <option value="CBD/Marijuana">CBD/Marijuana</option>
                <option value="Cell Phone Stores">Cell Phone Stores</option>
                <option value="Collection Agencies">Collection Agencies</option>
                <option value="Credit Repair">Credit Repair</option>
                <option value="Crypto/Forex">Crypto/Forex</option>
                <option value="Debt Consolidation">Debt Consolidation</option>
                <option value="Electrical Stores">Electrical Stores</option>
                <option value="Financial Services">Financial Services</option>
                <option value="Firearm Companies">Firearm Companies</option>
                <option value="Gambling">Gambling</option>
                <option value="Grocery Store">Grocery Store</option>
                <option value="Health Services">Health Services</option>
                <option value="Insurance">Insurance</option>
                <option value="Jewelry">Jewelry</option>
                <option value="Law Firms">Law Firms</option>
                <option value="Manufacturing">Manufacturing</option>
                <option value="Merchants Using Virtual Offices or Storage Units">Merchants Using Virtual Offices or Storage Units</option>
                <option value="MLM (Multi-Level Marketing)">MLM (Multi-Level Marketing)</option>
                <option value="Non-Profit Organizations">Non-Profit Organizations</option>
                <option value="Non-US Companies">Non-US Companies</option>
                <option value="Performing Arts">Performing Arts</option>
                <option value="Real Estate">Real Estate</option>
                <option value="Recruiting/Staffing">Recruiting/Staffing</option>
                <option value="Religious non-profits (e.g., Temples, Churches, food kitchens)">Religious non-profits (e.g., Temples, Churches, food kitchens)</option>
                <option value="Restaurants">Restaurants</option>
                <option value="Retail Store">Retail Store</option>
                <option value="Salon Barber Beauty Shops">Salon Barber Beauty Shops</option>
                <option value="Specialty Trade Contractor">Specialty Trade Contractor</option>
                <option value="Tech Support">Tech Support</option>
                <option value="Telemarketing">Telemarketing</option>
                <option value="Ticket Sales">Ticket Sales</option>
                <option value="Timeshares">Timeshares</option>
                <option value="Tobacco">Tobacco</option>
                <option value="Transportation Services">Transportation Services</option>
                <option value="Travel">Travel</option>
              </select>
            </div>
          </div>

          <div class="row mb-2">
            <label for="excluded_states" class="col-sm-2 col-form-label">Excluded States</label>
            <div class="col-sm-10">
              <select class="form-select form-select-sm" name="excluded_states[]" id="excluded_states" multiple>
                <option value="AL">Alabama</option>
                <option value="AK">Alaska</option>
                <option value="AZ">Arizona</option>
                <option value="AR">Arkansas</option>
                <option value="CA">California</option>
                <option value="CO">Colorado</option>
                <option value="CT">Connecticut</option>
                <option value="DE">Delaware</option>
                <option value="FL">Florida</option>
                <option value="GA">Georgia</option>
                <option value="HI">Hawaii</option>
                <option value="ID">Idaho</option>
                <option value="IL">Illinois</option>
                <option value="IN">Indiana</option>
                <option value="IA">Iowa</option>
                <option value="KS">Kansas</option>
                <option value="KY">Kentucky</option>
                <option value="LA">Louisiana</option>
                <option value="ME">Maine</option>
                <option value="MD">Maryland</option>
                <option value="MA">Massachusetts</option>
                <option value="MI">Michigan</option>
                <option value="MN">Minnesota</option>
                <option value="MS">Mississippi</option>
                <option value="MO">Missouri</option>
                <option value="MT">Montana</option>
                <option value="NE">Nebraska</option>
                <option value="NV">Nevada</option>
                <option value="NH">New Hampshire</option>
                <option value="NJ">New Jersey</option>
                <option value="NM">New Mexico</option>
                <option value="NY">New York</option>
                <option value="NC">North Carolina</option>
                <option value="ND">North Dakota</option>
                <option value="OH">Ohio</option>
                <option value="OK">Oklahoma</option>
                <option value="OR">Oregon</option>
                <option value="PA">Pennsylvania</option>
                <option value="RI">Rhode Island</option>
                <option value="SC">South Carolina</option>
                <option value="SD">South Dakota</option>
                <option value="TN">Tennessee</option>
                <option value="TX">Texas</option>
                <option value="UT">Utah</option>
                <option value="VT">Vermont</option>
                <option value="VA">Virginia</option>
                <option value="WA">Washington</option>
                <option value="WV">West Virginia</option>
                <option value="WI">Wisconsin</option>
                <option value="WY">Wyoming</option>
              </select>
            </div>
          </div>

          <div class="row mb-2">
            <label class="col-sm-2 col-form-label">Integrated API</label>
            <div class="col-sm-10">
              <input class="form-check-input" type="checkbox" name="has_integrated_api" id="has_integrated_api" value="1">
            </div>
          </div>

          <div class="row mb-2">
            <label for="api_key" class="col-sm-2 col-form-label">API Key</label>
            <div class="col-sm-10">
              <input type="text" class="form-control form-control-sm" name="api_key" id="api_key">
            </div>
          </div>

          <div class="row mb-2">
            <label class="col-sm-2 col-form-label">Submission Type</label>
            <div class="col-sm-10">
              <div class="form-check form-check-inline">
                <input class="form-check-input" type="checkbox" name="submission_type_email" id="submission_type_email" value="email" checked onclick="document.getElementById('submission_type').value='email'; document.getElementById('submission_type_api').checked=false;">
                <label class="form-check-label me-2" for="submission_type_email">Email</label>
              </div>
              <div class="form-check form-check-inline">
                <input class="form-check-input" type="checkbox" name="submission_type_api" id="submission_type_api" value="api" onclick="document.getElementById('submission_type').value='api'; document.getElementById('submission_type_email').checked=false;">
                <label class="form-check-label" for="submission_type_api">API</label>
              </div>
              <input type="hidden" id="submission_type" name="submission_type" value="email">
            </div>
          </div>
        </div>

        <div class="modal-footer">
          <button type="submit" class="btn submit_button">Submit</button>
        </div>
      </form>
    </div>
  </div>
</div>
