@auth
<div class="sidebar" id="left_sidebar">
  <div class="menu">
    <div class="item">
      <a href="#" class="sub-btn semi-active" style="color:#fff;">
        <i class='fas fa-bars icon'></i>
        Finance
        <i class='fas fa-angle-down dropdown'></i>
      </a>

      <div class="sub-menu">
        {{-- Deals --}}
        @if (Route::has('deals.index'))
          <a href="{{ route('deals.index') }}"
             class="sub-item {{ request()->routeIs('deals.*') ? 'side_active' : '' }}">
            Deals
          </a>
        @else
          <a href="/deals"
             class="sub-item {{ request()->is('deals*') ? 'side_active' : '' }}">
            Deals
          </a>
        @endif

        @role('Admin|Processor')
          {{-- Lenders --}}
          @if (Route::has('lenders'))
            <a href="{{ route('lenders') }}"
               class="sub-item {{ (request()->routeIs('lenders*') || request()->routeIs('lender.*')) ? 'side_active' : '' }}">
              Lenders
            </a>
          @endif

          {{-- Teams --}}
          @if (Route::has('team.index'))
            <a href="{{ route('team.index') }}"
               class="sub-item {{ request()->routeIs('team.*') ? 'side_active' : '' }}">
              Teams
            </a>
          @endif
        @endrole

        {{-- Imports (guarded so a missing route won’t 500 the page) --}}
        @can('import.excel')
          @if (Route::has('import.index'))
            <a href="{{ route('import.index') }}"
               class="sub-item {{ request()->routeIs('import.*') ? 'side_active' : '' }}">
              Imports
            </a>
          @endif
        @endcan

        @role('Admin')
          {{-- Users --}}
          @if (Route::has('users.index'))
            <a href="{{ route('users.index') }}"
               class="sub-item {{ request()->routeIs('users.*') ? 'side_active' : '' }}">
              Users
            </a>
          @endif

          {{-- Email --}}
          @if (Route::has('email.index'))
            <a href="{{ route('email.index') }}"
               class="sub-item {{ request()->routeIs('email.*') ? 'side_active' : '' }}">
              Email
            </a>
          @endif

          {{-- Commissions --}}
          @if (Route::has('commissions.index'))
            <a href="{{ route('commissions.index') }}"
               class="sub-item {{ request()->routeIs('commissions.*') ? 'side_active' : '' }}">
              Commissions
            </a>
          @endif

          {{-- Settings --}}
          @if (Route::has('settings.index'))
            <a href="{{ route('settings.index') }}"
               class="sub-item {{ request()->routeIs('settings.*') ? 'side_active' : '' }}">
              Settings
            </a>
          @endif

          {{-- Dashboard --}}
          @if (Route::has('dashboard.index'))
            <a href="{{ route('dashboard.index') }}"
               class="sub-item {{ request()->routeIs('dashboard.*') ? 'side_active' : '' }}">
              Dashboard
            </a>
          @endif
        @endrole

        {{-- Optional legacy links (kept commented)
        <a href="/invoice" class="sub-item {{ request()->routeIs('invoice') ? 'active' : '' }}">Invoice</a>
        <a href="/loans" class="sub-item {{ request()->routeIs('loans') ? 'active' : '' }}">Loans</a>
        <a href="/logout" class="sub-item {{ request()->routeIs('logout') ? 'active' : '' }}">Logout</a>
        --}}
      </div>
    </div>
  </div>
</div>
@endauth

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
  if (window.console) console.log('Sidebar loaded');
  fetch('/__test', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/json',
      'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
    },
    body: JSON.stringify({msg: 'sidebar_loaded'})
  }).catch(()=>{});
});
</script>
@endpush
