@extends('layouts.app')
@section('title')
    My Teams
@endsection
@section('header-custom-tags')
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
@endsection
@section('content')
    @include('partials.navbar')
    <div class="content-wrapper">
        @include('partials.sidebar')

        <main class="main-container" id="main_container">
            <div class="container-fluid w-100">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <div>
                                    <h5 class="text-info">My Teams</h5>
                                </div>
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        @can('team.create')
                                            <button style="box-shadow: -9px 0px rgb(0, 174, 255);" type="button"
                                                class="btn custom-btn" data-bs-toggle="modal" data-bs-target="#add_team">
                                                <i class='fas fa-plus'></i>
                                                Add team
                                            </button>
                                        @endcan
                                    </div>
                                    <div class="ms-2">
                                        <span>
                                            <i class='bx bx-cog'></i>
                                        </span>
                                    </div>
                                    <div class="ms-2">
                                        <span>
                                            <i class='fas fa-caret-down'></i>
                                        </span>
                                    </div>
                                    <div class="ms-2">
                                        <span>
                                            <i class='fas fa-sync'></i>
                                        </span>
                                    </div>

                                </div>

                            </div>
                            <div class="card-body">
                                <div class="table-wrapper">
                                    <div class="row">

                                        <div class="col-12">


                                            <table class="table table-striped">
                                                <tbody>

                                                    <tr class="collapse-container">
                                                        <td colspan="6">
                                                            <a data-bs-toggle="collapse" class="collapse-link"
                                                                href="#coldoffer" role="button" aria-expanded="false"
                                                                aria-controls="coldoffer">
                                                                Teams({{ $teams->count() }})
                                                            </a>

                                                        </td>

                                                        @foreach ($teams as $item)
                                                    <tr class="collapse" id="coldoffer">
                                                        <td>{{ $item->name }}</td>
                                                        @if ($item->leader->count() > 0)
                                                        <td>
                                                            @foreach ($item->leader as $item_name)
                                                             {{ $item_name->name}} ,
                                                            @endforeach  
                                                        </td>  
                                                        @else
                                                        <td>Leader Not Assigned</td>
                                                        @endif
                                                    </tr>
                                                    @endforeach
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>

                                        {{-- <div class="col-12 mt-3">
                                        </div> --}}
                                    </div>
                                </div>

                            </div>
                        </div>

                    </div>
                </div>
            </div>
    </div>
    </div>
    </main>
    </div>

    @if (Session::has('success'))
        <script>
            Swal.fire({
                position: 'top-end',
                icon: 'success',
                title: "{!! Session::get('success') !!}",
                showConfirmButton: false,
                timer: 1500
            });
        </script>
    @endif
    {{-- <script>
        var team_mem=[];
        $('.edit_team').click(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
                }
            });
            var id = $(this).attr('data-id');

            $.ajax({
                type: 'GET',
                url: 'team/edit/data/' + id,
                success: function (response) {
                    var all_members = {!! json_encode($users->pluck('id','name')) !!};
                   //loop through the users and add the checkboxes to the form
                    var membersHtml = ' <label for="members" id="team_members_div" class="col-sm-2 col-form-label">Team Members</label>';
                    $.each(all_members, function(name, id) { 
                        membersHtml += '<div class="form-check">';
                        membersHtml += '<input class="form-check-input" type="checkbox" name="members[]" value="' + id + '" id="member_' + id + '" class="member-checkbox"';
                        var team_members_this=response.members;
                        if ($.inArray(id, team_members_this) !== -1) {
                            membersHtml += ' checked';
                        }
                        membersHtml += '>';
                        membersHtml += '<label class="form-check-label" for="member_' + id + '">' + name + '</label>';
                        membersHtml += '</div>';
                    });

                    // append the checkboxes to the form
                    $('#team_members_div').html(membersHtml);

                }
            });
        });
        $(document).ready(function() {
            var s2 = $('.js-example-basic-multiple-edit').select2({
                dropdownParent: $('#edit_team'),
                placeholder: "Choose team leaders",
                width: 'resolve'
            });
            $('.edit_team').on('click', function() {
                var teamId = $(this).data('id');
                var teamName = $(this).data('name');
                var teamLeaders = $(this).data('leaders');
               // Clear the previous selection
                s2.val(null).trigger("change");

                // Select the team leader values
                s2.val(teamLeaders).trigger("change"); 

                $('#edit_team_id').val(teamId);
                $('#edit_team_name').val(teamName);
                
                $('#edit_team').modal('show');
            });
        });
    </script> --}}
    </body>
@endsection
{{-- Add team --}}
{{-- @include('partials.team_modal') --}}
{{-- Edit team --}}
{{-- @include('partials.edit_team') --}}
{{-- @push('custom-scripts')
    <script>
        $(document).ready(function() {
            $('.js-example-basic-multiple-add').select2({
             dropdownParent: $('#add_team'),
             width: 'resolve'
           });
        //    $('.js-example-basic-multiple-edit').select2({
        //      dropdownParent: $('#edit_team'),
        //      width: 'resolve'
        //    });
        });
    </script>
@endpush --}}