@extends('layouts.app')

@section('content')
    @include('partials.navbar')
    <div class="d-flex">
        @include('partials.sidebar')
        <div class="flex-grow-1">
            <div class="container mt-4">

            <h2>Users</h2>

            <div class="d-flex mb-3 justify-content-end">
                <button id="addUser" class="btn btn-success">
                    <i class="fas fa-user-plus"></i> Add User
                </button>
            </div>


    <table class="table table-bordered align-middle">
        <thead class="table-light">
            <tr>
                <th>ID</th>
                <th>First Name</th>
                <th>Last Name</th>
                <th>Email 1</th>
                <th>Email 2</th>
                <th>Phone</th>
                <th>Commission Rate</th>
                <th>Status</th>
                <th>Permissions</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach($users as $user)
                <tr>
                    <td>{{ $user->id }}</td>
                    <td>{{ $user->first_name }}</td>
                    <td>{{ $user->last_name }}</td>
                    <td>{{ $user->email }}</td>
                    <td>{{ $user->email2 }}</td>
                    <td>{{ $user->phone }}</td>
                    <td>{{ $user->commission_rate ?? '-' }}</td>
                    <td>
                        @if($user->user_status === 'active')
                            <span class="badge bg-success">Active</span>
                        @elseif($user->user_status === 'disabled')
                            <span class="badge bg-secondary">Disabled</span>
                        @else
                            <span class="badge bg-light text-dark">N/A</span>
                        @endif
                    </td>
                    <td>
                        <ul class="mb-0 ps-3">
                            <li>Deals: 
                                @if($user->can('deals.view_all'))
                                    View All
                                    @if($user->can('deals.edit_all')) (Edit) @endif
                                @else
                                    Own Only
                                @endif
                            </li>
                            <li>Lenders Tab: 
                                @if($user->can('lenders.view'))
                                    View
                                    @if($user->can('lenders.edit')) (Edit) @endif
                                @else
                                    No Access
                                @endif
                            </li>
                            <li>Can Submit to Lenders: 
                                @if($user->can('lenders.submit')) Yes @else No @endif
                            </li>
                        </ul>
                    </td>
                    <td>
                        <a href="#" class="btn btn-sm btn-info edit-user" data-id="{{ $user->id }}" title="Edit"><i class="fas fa-edit"></i></a>
                        <a href="#" class="btn btn-sm btn-danger delete-user" data-id="{{ $user->id }}" title="Delete"><i class="fas fa-trash-alt"></i></a>
                        @if($user->user_status === 'active')
                            <a href="#" class="btn btn-sm btn-secondary toggle-status" data-id="{{ $user->id }}" data-status="disabled" title="Disable"><i class="fas fa-user-slash"></i></a>
                        @else
                            <a href="#" class="btn btn-sm btn-success toggle-status" data-id="{{ $user->id }}" data-status="active" title="Activate"><i class="fas fa-user-check"></i></a>
                        @endif
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>

    {{-- Modals for Edit and Delete (to be implemented) --}}
    <!-- Edit User Modal -->
    <div class="modal fade" id="editUserModal" tabindex="-1" aria-labelledby="editUserModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-lg">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="editUserModalLabel">Edit User</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            {{-- Form fields will be loaded via JS --}}
            <div id="editUserFormContainer"></div>
          </div>
        </div>
      </div>
    </div>

    <!-- Delete User Modal -->
    <div class="modal fade" id="deleteUserModal" tabindex="-1" aria-labelledby="deleteUserModalLabel" aria-hidden="true">
      <div class="modal-dialog">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="deleteUserModalLabel">Confirm Delete</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            Are you sure you want to delete this user?
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
            <button type="button" class="btn btn-danger" id="confirmDeleteUser">Delete</button>
          </div>
        </div>
      </div>
    </div>

            </div>
        </div>
    </div>
@endsection




<div class="modal fade" id="userModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h5 id="userModalTitle" class="modal-title">User</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="×"></button>
            </div>
            <div class="modal-body">
                <div id="userFormContainer"></div>
            </div>
        </div>
    </div>
</div>

<!-- Мета для CSRF (в layout обычно уже есть) -->
<meta name="csrf-token" content="{{ csrf_token() }}">

@section('scripts')
{{--<script src="{{ asset('assets/js/users.js') }}?v={{ time() }}"></script>--}}
@endsection