<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Finance\DealController;
use App\Http\Controllers\Finance\EmployeeController;
use App\Models\AppSlug;
use App\Models\User;
use App\Models\Deal; 
use App\Models\UserTeam;
use App\Models\Team;
use App\Models\TeamLeader;
use App\Models\AppDealData;
use App\Models\SmtpConfig;
use Illuminate\Support\Facades\App;
use Carbon\Carbon;
use App\Models\EmailData;


/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::get('/get-user-by-id/{id}/{token}', function($id ,$token){
    $all_tokens = ['0932rnoiw3nr43rn34jrh43jby654njkfvno3odmalkdmskjbgfj54kwbt4hj543jkl'];
    if (!in_array($token, $all_tokens)) {
        return response()->json([]);
    } else {
        $data = User::find($id);
        return response()->json($data);
    }
});

Route::post('/deal-data-create/{token}', function($token ,Request $request){
    $all_tokens = ['0932rnoiw3nr43rn34jrh43jby654njkfvno3odmalkdmskjbgfj54kwbt4hj543jkl'];
    if (!in_array($token, $all_tokens)) {
        return response()->json([]);
    } else {
        $data = AppDealData::create([
            'sale_rep'=>$request->sale_rep,
            'deal_data'=> $request->deal_data,
            'deal_files'=> $request->deal_files
        ]);
        return response()->json($data);
    }
});

Route::get('/get-app-deal-username/{sale_rep}/{token}', function($sale_rep ,$token){
    $all_tokens = ['0932rnoiw3nr43rn34jrh43jby654njkfvno3odmalkdmskjbgfj54kwbt4hj543jkl'];
    if (!in_array($token, $all_tokens)) {
        return response()->json([]);
    } else {
        $data = AppSlug::where('app_deal_username',$sale_rep)->first();
        return response()->json($data);
    }
});

Route::get('/get-emails/{token}', function($token){
    $all_tokens = ['0932rnoiw3nr43rn34jrh43jby654njkfvno3odmalkdmskjbgfj54kwbt4hj543jkl'];
    if (!in_array($token, $all_tokens)) {
        return response()->json([]);
    } else {
        $emails = [];
        $proc_subs = EmailData::where('type','proc_sub')->orwhere('type','app_sub')->get();
        foreach($proc_subs as $em){
            $emails[] = $em->email;
        }
        return response()->json($emails);
    }
});

Route::get('/get-user-team/{user_id}/{token}', function($user_id ,$token){
    $all_tokens = ['0932rnoiw3nr43rn34jrh43jby654njkfvno3odmalkdmskjbgfj54kwbt4hj543jkl'];
    if (!in_array($token, $all_tokens)) {
        return response()->json([]);
    } else {
        $data = UserTeam::where('user_id',$user_id)->first();
        return response()->json($data);
    }
});


Route::post('/get-user-team/{token}', function($token ,Request $request){
    $all_tokens = ['0932rnoiw3nr43rn34jrh43jby654njkfvno3odmalkdmskjbgfj54kwbt4hj543jkl'];
    if (!in_array($token, $all_tokens)) {
        return response()->json([]);
    } else {
        $emails = $request->emails;
        $emails = json_decode($emails);
        $users = User::whereIn('email', $emails)->get();
        $data = [];
        if (count($users)) {
            foreach($users as $user) {
                $find_team = UserTeam::where('user_id', $user->id)->get()->last();
                if ($find_team) {
                    $team = Team::where('id', $find_team->team_id)->first();
                    if ($team) {
                        $data[$user->email] = $team->name;
                    }
                }
            }
        }
        
        return response()->json($data);
    }
}); 

Route::post('/get-sales-people/{token}', function($token ,Request $request){
    $all_tokens = ['0932rnoiw3nr43rn34jrh43jby654njkfvno3odmalkdmskjbgfj54kwbt4hj543jkl'];
    if (!in_array($token, $all_tokens)) {
        return response()->json([]);
    } else {
        $emails = $request->emails;
        $emails = json_decode($emails);
        $users = User::whereIn('email', $emails)->get();
        $data = [];
        if (count($users)) {
            foreach($users as $user) {
                $find_deals = Deal::where('sale_rep', $user->name)->orWhere('sale_rep', $user->email)->get();
                if (count($find_deals)) {
                    foreach($find_deals as $deal) {
                        if(!isset($data[$deal->email])) {
                            $data[$deal->email] = $deal;
                        }
                    }
                }
            }
        }
        
        return response()->json($data);
    }
});

Route::get('/get-team-leader-id/{team_id}/{token}', function($team_id ,$token){
    $all_tokens = ['0932rnoiw3nr43rn34jrh43jby654njkfvno3odmalkdmskjbgfj54kwbt4hj543jkl'];
    if (!in_array($token, $all_tokens)) {
        return response()->json([]);
    } else {
        $data = TeamLeader::where('team_id', $team_id)->value('leader_id');
        return response()->json($data);
    }
});


Route::post('/save-deal-data/{token}', function($token ,Request $request){
    $all_tokens = ['0932rnoiw3nr43rn34jrh43jby654njkfvno3odmalkdmskjbgfj54kwbt4hj543jkl'];
    if (!in_array($token, $all_tokens)) {
        return response()->json([]);
    } else {
        $deal =new Deal();
        $deal->sale_rep=$request->sale_rep;
        $deal->sale_rep2=$request->sale_rep2;
        $deal->company_name=$request->legal_business_name;
        $deal->marchant_name=$request->legal_business_name;
        $deal->phone_number=$request->business_phone_number;
        $deal->email=$request->email_address;
        $deal->request_amount=0;
        $deal->date_submitted=Carbon::now()->format('Y-m-d');
        $deal->team_id=NULL;
        $deal->save();
        return response()->json($deal);
    }
});

Route::post('/add_deal_files', [DealController::class, 'add_files_api'])->name('add_files_api');
Route::post('/create_user', [EmployeeController::class, 'create_new_user_api'])->name('create_new_user_api');
Route::post('/update_user', [EmployeeController::class, 'update_new_user_api'])->name('update_new_user_api');
Route::post('/delete_user', [EmployeeController::class, 'delete_new_user_api'])->name('delete_new_user_api');
Route::post('/check_app_slug', function(Request $request){
    $slug=AppSlug::where('app_deal_username',$request['app_slug'])->first();
    if($slug){
        if(isset($request['update_id'])){
            if($slug->user_id==$request['update_id']){
                return response()->json(false);
            }
        }
        return response()->json(true);
    }
    else{
        return response()->json(false);
    }
})->name('check_app_slug');
Route::post('/create_smtp', function(Request $request){
    $request->merge([
        'password'=>$request->smtp_password,    
    ]);
    $smtp=SmtpConfig::where("user_id", $request->user_id)->first();
    if($smtp){
        $smtp->update($request->all());
    }
    else{
        $smtp = SmtpConfig::create($request->all());
    }
})->name('create_new_smtp_api');


// Deals API APP maker data.
Route::get('/get-users-of/{user}/{token}', function($user ,$token){
    $all_tokens = ['0932rnoiw3nr43rn34jrh43jby654njkfvno3odmalkdmskjbgfj54kwbt4hj543jkl'];
    if (!in_array($token, $all_tokens)) {
        return response()->json([]);
    } else {
        if ($user == 'admin') {
            $data = User::get();
        } else {
            $data = User::where('added_by', $user)->get();
        }
        
        return response()->json($data);
    }
});

// Deals API APP maker data.
Route::get('/get-teams-of/{user}/{token}', function($user ,$token, Request $request){
    $all_tokens = ['0932rnoiw3nr43rn34jrh43jby654njkfvno3odmalkdmskjbgfj54kwbt4hj543jkl'];
    if (!in_array($token, $all_tokens)) {
        return [];
    } else {
        if ($user == 'admin') {
            $data = Team::paginate();
        } else {
            $data = Team::where('added_by', $user)->paginate();
        }
        
        return $data;
    }
});

// Deals API APP maker data.
Route::get('/get-users-of/{user}/{token}', function($user ,$token, Request $request){
    $all_tokens = ['0932rnoiw3nr43rn34jrh43jby654njkfvno3odmalkdmskjbgfj54kwbt4hj543jkl'];
    if (!in_array($token, $all_tokens)) {
        return [];
    } else {
        if ($user == 'admin') {
            $data = User::get();
        } else {
            $data = User::where('added_by', $user)->get();
        }
        
        $users = [];
        foreach($data as $user){
            $users[$user->id] = $user->name;
        }
        return $users;
    }
});

// Deals API APP maker data.
Route::get('/get-team-of/{user}/{token}/{id}', function($user ,$token, $id, Request $request){
    $all_tokens = ['0932rnoiw3nr43rn34jrh43jby654njkfvno3odmalkdmskjbgfj54kwbt4hj543jkl'];
    if (!in_array($token, $all_tokens)) {
        return [];
    } else {
        if ($user == 'admin') {
            $data = Team::where('id', $id)->get()->first();
        } else {
            $data = Team::where(function ($query) use ($user) {
                $query->where('added_by', $user)
                ->orWhere('added_for', $user);
                })
                ->where('id', $id)
                ->first();
        }
        return $data;
    }
});

Route::post('/update-team-of/{user}/{token}/{id}', function($user ,$token, $id, Request $request){
    $all_tokens = ['0932rnoiw3nr43rn34jrh43jby654njkfvno3odmalkdmskjbgfj54kwbt4hj543jkl'];
    if (!in_array($token, $all_tokens)) {
        return [];
    } else {
        if ($user == 'admin') {
            $data = Team::where('id', $id)->update([
                'name' => $request->input('name'), 
                'added_for' => $request->input('added_for')
            ]);
        } else {
            $data = Team::where('added_by', $user)->where('id', $id)->get()->first();
        }
        return $data;
    }
});