<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Finance\EmployeeController;
use App\Http\Controllers\Finance\LenderController;
use App\Http\Controllers\ImportController;

use App\Http\Controllers\UserController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Finance\DealController;
use App\Http\Controllers\GoogleOAuthController;


Route::match(['GET','POST'], '/__test', function () { return 'ok'; })->name('__test');

Route::middleware(['web','auth','status','role:Admin'])->group(function () {
    Route::get(
        '/permissions/all',
        [\App\Http\Controllers\PermissionController::class, 'all']
    )->name('permissions.all');
});
use App\Http\Controllers\TeamController;
use App\Http\Controllers\LoanController;
use App\Http\Controllers\EmailController;
use App\Models\DealFiles;
use App\Http\Controllers\CustomWebhookController;

if (file_exists(__DIR__.'/settings.php')) {
    require_once __DIR__.'/settings.php';
}
if (file_exists(__DIR__.'/commission.php')) {
    require_once __DIR__.'/commission.php';
}
require_once __DIR__.'/dashboard.php';


// Users management (for Admin)
Route::middleware(['auth', 'status', 'role:Admin'])->group(function () {
    Route::get('/users', [UserController::class, 'index'])->name('users.index');
    Route::get('/users/{id}/edit', [UserController::class, 'edit'])->name('users.edit');
    Route::put('/users/{id}', [UserController::class, 'update'])->name('users.update');
    Route::delete('/users/{id}', [UserController::class, 'destroy'])->name('users.destroy');
    Route::post('/users/{id}/toggle-status', [UserController::class, 'toggleStatus'])->name('users.toggleStatus');
    Route::get('/permissions/all', [UserController::class, 'allRolesPermissions'])->name('permissions.all');
    Route::post('/users', [UserController::class, 'store'])->name('users.store');
});



Route::get('/test', function () {
    return view('test');
});

Route::get('/', [LoginController::class, 'index'])->name('get_login');
Route::get('/login', [LoginController::class, 'index'])->name('login.form');
Route::post('/login', [LoginController::class, 'login'])->name('login');
Route::get('/logout', [LoginController::class, 'logout'])->name('logout');
Route::get('/profile', [LoginController::class, 'profile'])->name('profile.view');
Route::post('/update', [LoginController::class, 'update'])->name('profile.update');
Route::get('/crm_to_deal', [LoginController::class, 'crm_to_deal'])->name('profile.crm_to_deal');

// commands route
Route::get('/clear-cache', function() {
    Artisan::call('cache:clear');
    Artisan::call('route:clear');
    return 'Cache cleared successfully.';
});


Route::middleware(['auth', 'status'])->group(function () {
    Route::get('/deals', [DealController::class, 'index'])->name('deals.index');
    // Allow search via GET (e.g., visiting /deal/search) in addition to POST
    Route::get('/deal/search', [DealController::class, 'search'])->name('deals.search');
    Route::post('/deal/search', [DealController::class, 'search'])->name('deals');
    // Redirect GET /deal to the main deals listing to prevent 405 on /deal/
    Route::get('/deal', function () { return redirect()->route('deals.index'); });
    // Also handle trailing slash explicitly
    Route::get('/deal/', function () { return redirect()->route('deals.index'); });

    Route::post('/add_deal', [DealController::class, 'store'])->name('add_deal');
    Route::get('/show_deal/{id}', [DealController::class, 'show'])->name('show_deal');
    Route::post('/show_deal/find', [DealController::class, 'show_find'])->name('show_find');
    Route::post('/deal/upload', [DealController::class, 'upload'])->name('deal_upload');
    Route::delete('/deal/delete', [DealController::class, 'destroy'])->name('deals.delete');
    Route::post('/deal/approve', [DealController::class, 'approve_status'])->name('deals.approve_status');
    Route::get('/deal/edit/{deal}', [DealController::class, 'edit'])->name('deals.edit');
    Route::get('/deal/{sort}/{type}', [DealController::class, 'index'])->name('deals.sort');
    Route::POST('/deal/update', [DealController::class, 'update'])->name('deals.update');
    Route::delete('/deal/files/delete/{id}', [DealController::class, 'delete_file'])->name('deal_file_delete');
    Route::POST('/download_file/add_note', [DealController::class, 'downlode_note']);
    Route::POST('/sale_note/add_note', [DealController::class, 'sale_note']);
    Route::POST('/store_sizes', [DealController::class, 'store_sizes']);
    // Route::get('/pdf/view',[DealController::class,'upload'])->name('deal_upload');
    // employee
    Route::post('/user/search', [EmployeeController::class, 'index']);
    Route::get('/employees', [EmployeeController::class, 'index'])->name('employees');
    Route::post('/add_employee', [EmployeeController::class, 'store'])->name('add_employee');
    Route::get('/employee/edit/{user}', [EmployeeController::class, 'edit'])->name('employee.edit');
    Route::delete('/employee/delete', [EmployeeController::class, 'destroy'])->name('employees.delete');
    Route::PUT('/employee/update', [EmployeeController::class, 'update'])->name('employees.update');


// lenders
Route::middleware(['auth', 'status'])->group(function () {
    // List + search
    Route::get('/lenders', [LenderController::class, 'index'])->name('lenders');
    Route::post('/lender/search', [LenderController::class, 'index'])->name('lenders.search');

    // Edit modal loader (returns JSON for the modal)
    Route::get('/lender/edit/{id}', [LenderController::class, 'editJson'])->name('lender.editJson');

    // Create
    Route::post('/add_lender', [LenderController::class, 'store'])->name('add_lender');

    // Update (accept PUT and POST for clients that can’t send PUT)
    Route::put('/lender/update', [LenderController::class, 'update'])->name('lenders.update');
    Route::post('/lender/update', [LenderController::class, 'update']);

    // Delete
    Route::delete('/lender/delete', [LenderController::class, 'destroy'])->name('lenders.delete');

    // (rest of your lender-related routes stay as-is)
    Route::get('/invoice', [LenderController::class, 'invoice'])->name('invoice');
    Route::get('/loans', [LenderController::class, 'loans'])->name('loans');
    Route::post('/loans/update', [LenderController::class, 'update_loan'])->name('loans.update');
    Route::post('/loan/add', [LoanController::class, 'store'])->name('submit_loan');

    // deal lender
    Route::post('/assign_lender', [LenderController::class, 'assign_lender']);
    Route::get('/assign_lender_new', [LenderController::class, 'assign_lender_new'])->name('new_pos');
    Route::post('/store_notes', [LenderController::class, 'store_notes']);
    Route::post('/store_amount', [LenderController::class, 'store_amount']);
    Route::post('/send_email', [LenderController::class, 'send_email']);
    Route::post('/send_email_all', [LenderController::class, 'send_email_all']);
    Route::post('/change_status', [LenderController::class, 'change_status']);
    Route::post('/update_status', [LenderController::class, 'update_status']);
    Route::post('/send_email_all_selected', [LenderController::class, 'send_email_all_selected']);
});

    
    // email
    Route::get('emails',[EmailController::class,'index'])->name('email.index');
    Route::post('save-emails',[EmailController::class,'save'])->name('email.add');
    
    Route::post('/web/post', [CustomWebhookController::class, 'handle']);
    
    Route::get('/google/auth', [GoogleOAuthController::class, 'redirect'])->name('google.auth');
    Route::get('/google/callback', [GoogleOAuthController::class, 'callback'])->name('google.callback');
});

