
<?php $__env->startSection('title'); ?>
    Deals
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <?php echo $__env->make('partials.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="wrapper">
        <?php echo $__env->make('partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <main class="main-container" id="main_container">
            <div class="container-fluid w-100">
                <div class="row">
                    
                    <div class="col-md-6">
                        <p><span class="text-muted fw-semibold">Advanced Search ,</span>
                            <span class="text-info fw-bold">Search Results</span>
                        </p>
                    </div>
                    <div class="col-md-6">
                        <div class="input-group mb-2">
                            <input type="text" class="form-control form-control-sm" placeholder="Search by Name,Term">
                            <span class="input-group-text" id="basic-addon2">
                                <i class='fas fa-search'></i>
                            </span>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <div class="card h-100">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <div>
                                    <h5 class="text-info">SEARCH RESULTS</h5>
                                </div>
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <button style="box-shadow: -5px 0px rgb(0, 174, 255);" type="button"
                                            data-bs-toggle="modal" data-bs-target="#exampleModal2"
                                            class="btn custom-btn me-3">
                                            <i class='fas fa-dollar-sign'></i>
                                            Open
                                        </button>
                                    </div>
                                    <div>
                                        <button style="box-shadow: -5px 0px rgb(0, 174, 255);" type="button"
                                            class="btn custom-btn">
                                            <i class='fas fa-bars'></i>
                                            All
                                        </button>
                                    </div>
                                    <div>
                                        <button style="box-shadow: -5px 0px rgb(255, 238, 0);" type="button"
                                            class="btn custom-btn ms-3">
                                            <i class='fas fa-edit'></i>
                                            Line
                                        </button>
                                    </div>
                                    <div>
                                        <?php if (! (auth()->user()->hasRole('Lender'))): ?>
                                            <button style="box-shadow: -5px 0px rgb(255, 0, 0);" type="button"
                                                class="btn custom-btn ms-3" data-bs-toggle="modal" data-bs-target="#add_deal">
                                                <i class='fas fa-plus'></i>
                                                New Deal
                                            </button>
                                        <?php endif; ?>
                                    </div>

                                    <div class="ms-2">
                                        <span>
                                            <i class='fas fa-caret-down'></i>
                                        </span>
                                    </div>
                                    <div class="ms-2">
                                        <span>
                                            <i class='fas fa-sync'></i>
                                        </span>
                                    </div>

                                </div>

                            </div>
                            <div class="card-body">
                                <div class="float-right" style="text-align: right;">
                                    <span> Note Visibility:</span>
                                    <div style="display: inline-block;">
                                        <input type="checkbox" name="visibility" value="appr" onclick="toggleVisibility('appr')"> Approved
                                        <input type="checkbox" name="visibility" value="pend" onclick="toggleVisibility('pend')"> Pending
                                        <input type="checkbox" name="visibility" value="dec" onclick="toggleVisibility('dec')"> Declined
                                    </div>
                                </div>
                                <script>
                                    function toggleVisibility(visibility) {
                                            if ($('input[name=visibility][value=appr]').is(':checked')) {
                                                $('.appr_span').show();
                                            } else {
                                                $('.appr_span').hide();
                                            }
                                            if ($('input[name=visibility][value=pend]').is(':checked')) {
                                                $('.pen_span').show();
                                            } else {
                                                $('.pen_span').hide();
                                            }
                                            if ($('input[name=visibility][value=dec]').is(':checked')) {
                                                $('.dec_span').show();
                                            } else {
                                                $('.dec_span').hide();
                                            }
                                    }
                                </script>                        
                                <div class="table-wrapper">
                                    <table class="table table-striped">
                                        <thead>
                                            <tr>

                                                <th scope="col">Company</th>
                                                <th scope="col">Primary Contact</th>
                                                <th scope="col">Lender Notes</th>
                                                <th scope="col">Phone Number</th>
                                                <th scope="col">Email Address</th>
                                                <th scope="col">Rep(s) <a href="/deal/asc/rep"><button class="btn btn-sm btn-warning"> <i class="fas fa-filter"></i>filter</button></a></th>
                                                <th scope="col">Last Contacted</th>
                                                <th scope="col">Action</th>
                                            </tr>
                                            <tr>
                                                <form action="<?php echo e(url('deal/search')); ?>" method="post">
                                                    <?php echo csrf_field(); ?>
                                                    <th><input type="text" name="company_name"class="form-control" />
                                                    </th>
                                                    <th><input type="text" name="marchant_name"class="form-control" />
                                                    </th>
                                                    <th><input type="text" name="notes"class="form-control" /></th>
                                                    <th><input type="text" name="phone_number"class="form-control" />
                                                    </th>
                                                    <th><input type="email" name="email"class="form-control" /></th>
                                                    <th><input type="text" name="sale_rep"class="form-control" /></th>
                                                    <th><input type="date" name="last_contacted"class="form-control" />
                                                    </th>
                                                    <th>
                                                        <button type="submit"
                                                            class="btn btn-sm btn-primary">Search</button>
                                                    </th>
                                                </form>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            
                                            <tr class="collapse-container">
                                                <td colspan="8">
                                                    <div class="header-wrapper">
                                                        <a data-bs-toggle="collapse" class="collapse-link"
                                                            href="#submitted" role="button" aria-expanded="false"
                                                            aria-controls="submitted" style="min-width:10rem">
                                                            Submitted(<?php echo e($submitted->count()); ?>)
                                                        </a>
                                                        <?php if($submitted->count() > 0): ?>
                                                            <a href="/deal/asc/submitted">
                                                                <button class="btn btn-sm order-btn">▲</button>
                                                            </a>
                                                            <a href="/deal/desc/submitted">
                                                                <button class="btn btn-sm order-btn">▼</button>
                                                        
                                                            </a>
                                                        <?php endif; ?>
                                                    </div>
                                                    
                                                </td>
                                            <?php if($submitted->count() > 0): ?>
                                                <?php $__currentLoopData = $submitted; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr class="collapse <?php echo e(($open_s)?'show':''); ?>" id="submitted">

                                                        <td>
                                                            <a href="/show_deal/<?php echo e($item->id); ?>"
                                                                style="text-decoration: none;cursor:pointer;color:rgb(129, 124, 124);display:block;">
                                                                <?php echo e($item->company_name); ?>.
                                                            </a>
                                                        </td>
                                                        <td><?php echo e($item->marchant_name); ?></td>
                                                        <td style="display: flex;">
                                                <?php
                                                $approvedNotes = [];
                                                $pendingNotes = [];
                                                $declinedNotes = [];

                                                foreach ($item->lenders as $lender) {
                                                if ($lender->pivot->status == 'Approved') {
                                                $approvedNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Pending') {
                                                $pendingNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Declined') {
                                                $declinedNotes[] = $lender->pivot->note;
                                                }
                                                }
                                                ?>

                                                <?php $__currentLoopData = $approvedNotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p style="margin-left: 5px" class="badge appr_span text-bg-success"><?php echo e(Str::limit($note, 8)); ?></p>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                <?php $__currentLoopData = $pendingNotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p style="margin-left: 5px" class="badge pen_span text-bg-warning"><?php echo e(Str::limit($note, 8)); ?>

                                                </p>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                <?php $__currentLoopData = $declinedNotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p style="margin-left: 5px" class="badge dec_span text-bg-danger"><?php echo e(Str::limit($note, 8)); ?></p>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </td>
                                                        <td><?php echo e($item->phone_number); ?></td>
                                                        <td><?php echo e($item->email); ?></td>
                                                        <td><?php echo e($item->sale_rep); ?></td>
                                                        <td><?php echo e($item->date_submitted); ?></td>
                                                        <td style="display: flex;">
                                                            <button type="button" class="btn btn-danger delete_deal"
                                                                data-id="<?php echo e($item->id); ?>">
                                                                Delete
                                                            </button>
                                                            <button type="button" data-id="<?php echo e($item->id); ?>"
                                                                class=" ms-2 btn-info btn-sm btn edit_deal">
                                                                Edit
                                                            </button>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php else: ?>
                                                <tr></tr>
                                            <?php endif; ?>















































































                                            
                                            <td colspan="8">
                                                <div class="header-wrapper">
                                                    <a data-bs-toggle="collapse" class="collapse-link" href="#proc" role="button" aria-expanded="false" aria-controls="proc" style="min-width:10rem">
                                                        Processor(<?php echo e($proc->count()); ?>)
                                                    </a>
                                                    <?php if($proc->count() > 0): ?>
                                                        <a href="/deal/asc/proc">
                                                            <button class="btn btn-sm order-btn">▲</button>
                                                        </a>
                                                        <a href="/deal/desc/proc">
                                                            <button class="btn btn-sm order-btn">▼</button>
                                                    
                                                        </a>
                                                    <?php endif; ?>
                                                </div>
                                            </td>
                                        <?php if($proc->count() > 0): ?>
                                            <?php $__currentLoopData = $proc; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr class="collapse <?php echo e(($open_proc)?'show':''); ?>" id="proc">

                                                    <td>
                                                        <a href="/show_deal/<?php echo e($item->id); ?>"
                                                            style="text-decoration: none;cursor:pointer;color:rgb(129, 124, 124);display:block;">
                                                            <?php echo e($item->company_name); ?>.
                                                        </a>
                                                    </td>
                                                    <td><?php echo e($item->marchant_name); ?></td>
                                                    <td style="display: flex;">
                                                <?php
                                                $approvedNotes = [];
                                                $pendingNotes = [];
                                                $declinedNotes = [];

                                                foreach ($item->lenders as $lender) {
                                                if ($lender->pivot->status == 'Approved') {
                                                $approvedNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Pending') {
                                                $pendingNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Declined') {
                                                $declinedNotes[] = $lender->pivot->note;
                                                }
                                                }
                                                ?>

                                                <?php $__currentLoopData = $approvedNotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p style="margin-left: 5px" class="badge appr_span text-bg-success"><?php echo e(Str::limit($note, 8)); ?></p>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                <?php $__currentLoopData = $pendingNotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p style="margin-left: 5px" class="badge pen_span text-bg-warning"><?php echo e(Str::limit($note, 8)); ?>

                                                </p>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                <?php $__currentLoopData = $declinedNotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p style="margin-left: 5px" class="badge dec_span text-bg-danger"><?php echo e(Str::limit($note, 8)); ?></p>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </td>
                                                    <td><?php echo e($item->phone_number); ?></td>
                                                    <td><?php echo e($item->email); ?></td>
                                                    <td><?php echo e($item->sale_rep); ?></td>
                                                    <td><?php echo e($item->date_submitted); ?></td>
                                                    <td style="display: flex;">
                                                        <button type="button" class="btn btn-danger delete_deal"
                                                            data-id="<?php echo e($item->id); ?>">
                                                            Delete
                                                        </button>
                                                        <button type="button" data-id="<?php echo e($item->id); ?>"
                                                            class=" ms-2 btn-primary btn-sm btn">
                                                            Edit
                                                        </button>
                                                        <?php if($errors->any()): ?>
                                                            <script>
                                                                $(document).ready(function () {
                                                                    $('#add_deal').modal('show');
                                                                });
                                                            </script>
                                                        <?php endif; ?>             
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php else: ?>
                                            <tr></tr>
                                        <?php endif; ?>
                                        
                                            <td colspan="8">
                                                <div class="header-wrapper">
                                                    <a data-bs-toggle="collapse" class="collapse-link"
                                                        href="#underwritting" role="button" aria-expanded="false"
                                                        aria-controls="underwritting" style="min-width:10rem">
                                                        Underwriting(<?php echo e($underwritter->count()); ?>)
                                                    </a>
                                                    <?php if($underwritter->count() > 0): ?>
                                                        <a href="/deal/asc/underwritter">
                                                            <button class="btn btn-sm order-btn">▲</button>
                                                        </a>
                                                        <a href="/deal/desc/underwritter">
                                                            <button class="btn btn-sm order-btn">▼</button>
                                                    
                                                        </a>
                                                    <?php endif; ?>
                                                </div>
                                            </td>
                                        <?php if($underwritter->count() > 0): ?>
                                            <?php $__currentLoopData = $underwritter; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr class="collapse <?php echo e(($open_uw)?'show':''); ?>" id="underwritting">

                                                    <td>
                                                        <a href="/show_deal/<?php echo e($item->id); ?>"
                                                            style="text-decoration: none;cursor:pointer;color:rgb(129, 124, 124);display:block;">
                                                            <?php echo e($item->company_name); ?>.
                                                        </a>
                                                    </td>
                                                    <td><?php echo e($item->marchant_name); ?></td>
                                                    <td style="display: flex;">
                                                <?php
                                                $approvedNotes = [];
                                                $pendingNotes = [];
                                                $declinedNotes = [];

                                                foreach ($item->lenders as $lender) {
                                                if ($lender->pivot->status == 'Approved') {
                                                $approvedNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Pending') {
                                                $pendingNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Declined') {
                                                $declinedNotes[] = $lender->pivot->note;
                                                }
                                                }
                                                ?>

                                                <?php $__currentLoopData = $approvedNotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p style="margin-left: 5px" class="badge appr_span text-bg-success"><?php echo e(Str::limit($note, 8)); ?></p>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                <?php $__currentLoopData = $pendingNotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p style="margin-left: 5px" class="badge pen_span text-bg-warning"><?php echo e(Str::limit($note, 8)); ?>

                                                </p>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                <?php $__currentLoopData = $declinedNotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p style="margin-left: 5px" class="badge dec_span text-bg-danger"><?php echo e(Str::limit($note, 8)); ?></p>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </td>
                                                    <td><?php echo e($item->phone_number); ?></td>
                                                    <td><?php echo e($item->email); ?></td>
                                                    <td><?php echo e($item->sale_rep); ?></td>
                                                    <td><?php echo e($item->date_submitted); ?></td>
                                                    <td style="display: flex;">
                                                        <button type="button" class="btn btn-danger delete_deal"
                                                            data-id="<?php echo e($item->id); ?>">
                                                            Delete
                                                        </button>
                                                        <button type="button" data-id="<?php echo e($item->id); ?>"
                                                            class=" ms-2 btn-info btn-sm btn edit_deal">
                                                            Edit
                                                        </button>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php else: ?>
                                            <tr></tr>
                                        <?php endif; ?>
                                        
                                        <td colspan="8">
                                            <div class="header-wrapper">
                                                <a data-bs-toggle="collapse" class="collapse-link" href="#reshop" role="button" aria-expanded="false" aria-controls="reshop" style="min-width:10rem">
                                                    Reshop(<?php echo e($reshop->count()); ?>)
                                                </a>
                                                <?php if($reshop->count() > 0): ?>
                                                    <a href="/deal/asc/reshop">
                                                        <button class="btn btn-sm order-btn">▲</button>
                                                    </a>
                                                    <a href="/deal/desc/reshop">
                                                        <button class="btn btn-sm order-btn">▼</button>
                                                
                                                    </a>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    <?php if($reshop->count() > 0): ?>
                                        <?php $__currentLoopData = $reshop; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr class="collapse <?php echo e(($open_reshop)?'show':''); ?>" id="reshop">

                                                <td>
                                                    <a href="/show_deal/<?php echo e($item->id); ?>"
                                                        style="text-decoration: none;cursor:pointer;color:rgb(129, 124, 124);display:block;">
                                                        <?php echo e($item->company_name); ?>.
                                                    </a>
                                                </td>
                                                <td><?php echo e($item->marchant_name); ?></td>
                                                <td style="display: flex;">
                                                <?php
                                                $approvedNotes = [];
                                                $pendingNotes = [];
                                                $declinedNotes = [];

                                                foreach ($item->lenders as $lender) {
                                                if ($lender->pivot->status == 'Approved') {
                                                $approvedNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Pending') {
                                                $pendingNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Declined') {
                                                $declinedNotes[] = $lender->pivot->note;
                                                }
                                                }
                                                ?>

                                                <?php $__currentLoopData = $approvedNotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p style="margin-left: 5px" class="badge appr_span text-bg-success"><?php echo e(Str::limit($note, 8)); ?></p>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                <?php $__currentLoopData = $pendingNotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p style="margin-left: 5px" class="badge pen_span text-bg-warning"><?php echo e(Str::limit($note, 8)); ?>

                                                </p>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                <?php $__currentLoopData = $declinedNotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p style="margin-left: 5px" class="badge dec_span text-bg-danger"><?php echo e(Str::limit($note, 8)); ?></p>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </td>
                                                <td><?php echo e($item->phone_number); ?></td>
                                                <td><?php echo e($item->email); ?></td>
                                                <td><?php echo e($item->sale_rep); ?></td>
                                                <td><?php echo e($item->date_submitted); ?></td>
                                                <td style="display: flex;">
                                                    <button type="button" class="btn btn-danger delete_deal"
                                                        data-id="<?php echo e($item->id); ?>">
                                                        Delete
                                                    </button>
                                                    <button type="button" data-id="<?php echo e($item->id); ?>"
                                                        class=" ms-2 btn-primary btn-sm btn">
                                                        Edit
                                                    </button>
                                                    <?php if($errors->any()): ?>
                                                        <script>
                                                            $(document).ready(function () {
                                                                $('#add_deal').modal('show');
                                                            });
                                                        </script>
                                                    <?php endif; ?>             
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <tr></tr>
                                    <?php endif; ?>
                                    

                                        <td colspan="8">
                                            <div class="header-wrapper">
                                                <a data-bs-toggle="collapse" class="collapse-link" href="#approved" role="button" aria-expanded="false" aria-controls="approved" style="min-width:10rem">
                                                    Approved(<?php echo e($approved->count()); ?>)
                                                </a>
                                                <?php if($approved->count() > 0): ?>
                                                    <a href="/deal/asc/approved">
                                                        <button class="btn btn-sm order-btn">▲</button>
                                                    </a>
                                                    <a href="/deal/desc/approved">
                                                        <button class="btn btn-sm order-btn">▼</button>
                                                
                                                    </a>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    <?php if($approved->count() > 0): ?>
                                        <?php $__currentLoopData = $approved; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr class="collapse <?php echo e(($open_app)?'show':''); ?>" id="approved">

                                                <td>
                                                    <a href="/show_deal/<?php echo e($item->id); ?>"
                                                        style="text-decoration: none;cursor:pointer;color:rgb(129, 124, 124);display:block;">
                                                        <?php echo e($item->company_name); ?>.
                                                    </a>
                                                </td>
                                                <td><?php echo e($item->marchant_name); ?></td>
                                                <td style="display: flex;">
                                                <?php
                                                $approvedNotes = [];
                                                $pendingNotes = [];
                                                $declinedNotes = [];

                                                foreach ($item->lenders as $lender) {
                                                if ($lender->pivot->status == 'Approved') {
                                                $approvedNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Pending') {
                                                $pendingNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Declined') {
                                                $declinedNotes[] = $lender->pivot->note;
                                                }
                                                }
                                                ?>

                                                <?php $__currentLoopData = $approvedNotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p style="margin-left: 5px" class="badge appr_span text-bg-success"><?php echo e(Str::limit($note, 8)); ?></p>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                <?php $__currentLoopData = $pendingNotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p style="margin-left: 5px" class="badge pen_span text-bg-warning"><?php echo e(Str::limit($note, 8)); ?>

                                                </p>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                <?php $__currentLoopData = $declinedNotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p style="margin-left: 5px" class="badge dec_span text-bg-danger"><?php echo e(Str::limit($note, 8)); ?></p>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </td>
                                                <td><?php echo e($item->phone_number); ?></td>
                                                <td><?php echo e($item->email); ?></td>
                                                <td><?php echo e($item->sale_rep); ?></td>
                                                <td><?php echo e($item->date_submitted); ?></td>
                                                <td style="display: flex;">
                                                    <button type="button" class="btn btn-danger delete_deal"
                                                        data-id="<?php echo e($item->id); ?>">
                                                        Delete
                                                    </button>
                                                    <button type="button" data-id="<?php echo e($item->id); ?>"
                                                        class=" ms-2 btn-info btn-sm btn edit_deal">
                                                        Edit
                                                    </button>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <tr></tr>
                                    <?php endif; ?>
                                    
                                        <td colspan="8">
                                            <div class="header-wrapper">
                                                <a data-bs-toggle="collapse" class="collapse-link" href="#coldoffer" role="button" aria-expanded="false" aria-controls="coldoffer" style="min-width:10rem">
                                                    Cold offer(<?php echo e($coldoffer->count()); ?>)
                                                </a>
                                                <?php if($coldoffer->count() > 0): ?>
                                                    <a href="/deal/asc/coldoffer">
                                                        <button class="btn btn-sm order-btn">▲</button>
                                                    </a>
                                                    <a href="/deal/desc/coldoffer">
                                                        <button class="btn btn-sm order-btn">▼</button>
                                                
                                                    </a>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    <?php if($coldoffer->count() > 0): ?>
                                        <?php $__currentLoopData = $coldoffer; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr class="collapse <?php echo e(($open_cold)?'show':''); ?>" id="coldoffer">

                                                <td>
                                                    <a href="/show_deal/<?php echo e($item->id); ?>"
                                                        style="text-decoration: none;cursor:pointer;color:rgb(129, 124, 124);display:block;">
                                                        <?php echo e($item->company_name); ?>.
                                                    </a>
                                                </td>
                                                <td><?php echo e($item->marchant_name); ?></td>
                                                <td style="display: flex;">
                                                <?php
                                                $approvedNotes = [];
                                                $pendingNotes = [];
                                                $declinedNotes = [];

                                                foreach ($item->lenders as $lender) {
                                                if ($lender->pivot->status == 'Approved') {
                                                $approvedNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Pending') {
                                                $pendingNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Declined') {
                                                $declinedNotes[] = $lender->pivot->note;
                                                }
                                                }
                                                ?>

                                                <?php $__currentLoopData = $approvedNotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p style="margin-left: 5px" class="badge appr_span text-bg-success"><?php echo e(Str::limit($note, 8)); ?></p>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                <?php $__currentLoopData = $pendingNotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p style="margin-left: 5px" class="badge pen_span text-bg-warning"><?php echo e(Str::limit($note, 8)); ?>

                                                </p>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                <?php $__currentLoopData = $declinedNotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p style="margin-left: 5px" class="badge dec_span text-bg-danger"><?php echo e(Str::limit($note, 8)); ?></p>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </td>
                                                <td><?php echo e($item->phone_number); ?></td>
                                                <td><?php echo e($item->email); ?></td>
                                                <td><?php echo e($item->sale_rep); ?></td>
                                                <td><?php echo e($item->date_submitted); ?></td>
                                                <td style="display: flex;">
                                                    <button type="button" class="btn btn-danger delete_deal"
                                                        data-id="<?php echo e($item->id); ?>">
                                                        Delete
                                                    </button>
                                                    <button type="button" data-id="<?php echo e($item->id); ?>"
                                                        class=" ms-2 btn-info btn-sm btn edit_deal">
                                                        Edit
                                                    </button>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <tr></tr>
                                    <?php endif; ?>
                                    
                                        <td colspan="8">
                                            <div class="header-wrapper">
                                                <a data-bs-toggle="collapse" class="collapse-link" href="#open_team" role="button" aria-expanded="false" aria-controls="open_team" style="min-width:10rem">
                                                    Open for team(<?php echo e($open_team->count()); ?>)
                                                </a>
                                                <?php if($open_team->count() > 0): ?>
                                                    <a href="/deal/asc/open_team">
                                                        <button class="btn btn-sm order-btn">▲</button>
                                                    </a>
                                                    <a href="/deal/desc/open_team">
                                                        <button class="btn btn-sm order-btn">▼</button>
                                                
                                                    </a>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    <?php if($open_team->count() > 0): ?>
                                        <?php $__currentLoopData = $open_team; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr class="collapse <?php echo e(($open_open_team)?'show':''); ?>" id="open_team">

                                                <td>
                                                    <a href="/show_deal/<?php echo e($item->id); ?>"
                                                        style="text-decoration: none;cursor:pointer;color:rgb(129, 124, 124);display:block;">
                                                        <?php echo e($item->company_name); ?>.
                                                    </a>
                                                </td>
                                                <td><?php echo e($item->marchant_name); ?></td>
                                                <td style="display: flex;">
                                                <?php
                                                $approvedNotes = [];
                                                $pendingNotes = [];
                                                $declinedNotes = [];

                                                foreach ($item->lenders as $lender) {
                                                if ($lender->pivot->status == 'Approved') {
                                                $approvedNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Pending') {
                                                $pendingNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Declined') {
                                                $declinedNotes[] = $lender->pivot->note;
                                                }
                                                }
                                                ?>

                                                <?php $__currentLoopData = $approvedNotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p style="margin-left: 5px" class="badge appr_span text-bg-success"><?php echo e(Str::limit($note, 8)); ?></p>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                <?php $__currentLoopData = $pendingNotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p style="margin-left: 5px" class="badge pen_span text-bg-warning"><?php echo e(Str::limit($note, 8)); ?>

                                                </p>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                <?php $__currentLoopData = $declinedNotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p style="margin-left: 5px" class="badge dec_span text-bg-danger"><?php echo e(Str::limit($note, 8)); ?></p>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </td>
                                                <td><?php echo e($item->phone_number); ?></td>
                                                <td><?php echo e($item->email); ?></td>
                                                <td><?php echo e($item->sale_rep); ?></td>
                                                <td><?php echo e($item->date_submitted); ?></td>
                                                <td style="display: flex;">
                                                    <button type="button" class="btn btn-danger delete_deal"
                                                        data-id="<?php echo e($item->id); ?>">
                                                        Delete
                                                    </button>
                                                    <button type="button" data-id="<?php echo e($item->id); ?>"
                                                        class=" ms-2 btn-primary btn-sm btn">
                                                        Edit
                                                    </button>
                                                    <?php if($errors->any()): ?>
                                                        <script>
                                                            $(document).ready(function () {
                                                                $('#add_deal').modal('show');
                                                            });
                                                        </script>
                                                    <?php endif; ?>             
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <tr></tr>
                                    <?php endif; ?>
                                    
                                        <td colspan="8">
                                            <div class="header-wrapper">
                                                <a data-bs-toggle="collapse" class="collapse-link" href="#open" role="button" aria-expanded="false" aria-controls="open" style="min-width:10rem">
                                                    open(<?php echo e($open->count()); ?>)
                                                </a>
                                                <?php if($open->count() > 0): ?>
                                                    <a href="/deal/asc/open">
                                                        <button class="btn btn-sm order-btn">▲</button>
                                                    </a>
                                                    <a href="/deal/desc/open">
                                                        <button class="btn btn-sm order-btn">▼</button>
                                                
                                                    </a>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    <?php if($open->count() > 0): ?>
                                        <?php $__currentLoopData = $open; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr class="collapse <?php echo e(($open_open)?'show':''); ?>" id="open">

                                                <td>
                                                    <a href="/show_deal/<?php echo e($item->id); ?>"
                                                        style="text-decoration: none;cursor:pointer;color:rgb(129, 124, 124);display:block;">
                                                        <?php echo e($item->company_name); ?>.
                                                    </a>
                                                </td>
                                                <td><?php echo e($item->marchant_name); ?></td>
                                                <td style="display: flex;">
                                                <?php
                                                $approvedNotes = [];
                                                $pendingNotes = [];
                                                $declinedNotes = [];

                                                foreach ($item->lenders as $lender) {
                                                if ($lender->pivot->status == 'Approved') {
                                                $approvedNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Pending') {
                                                $pendingNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Declined') {
                                                $declinedNotes[] = $lender->pivot->note;
                                                }
                                                }
                                                ?>

                                                <?php $__currentLoopData = $approvedNotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p style="margin-left: 5px" class="badge appr_span text-bg-success"><?php echo e(Str::limit($note, 8)); ?></p>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                <?php $__currentLoopData = $pendingNotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p style="margin-left: 5px" class="badge pen_span text-bg-warning"><?php echo e(Str::limit($note, 8)); ?>

                                                </p>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                <?php $__currentLoopData = $declinedNotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p style="margin-left: 5px" class="badge dec_span text-bg-danger"><?php echo e(Str::limit($note, 8)); ?></p>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </td>
                                                <td><?php echo e($item->phone_number); ?></td>
                                                <td><?php echo e($item->email); ?></td>
                                                <td><?php echo e($item->sale_rep); ?></td>
                                                <td><?php echo e($item->date_submitted); ?></td>
                                                <td style="display: flex;">
                                                    <button type="button" class="btn btn-danger delete_deal"
                                                        data-id="<?php echo e($item->id); ?>">
                                                        Delete
                                                    </button>
                                                    <button type="button" data-id="<?php echo e($item->id); ?>"
                                                        class=" ms-2 btn-primary btn-sm btn">
                                                        Edit
                                                    </button>
                                                    <?php if($errors->any()): ?>
                                                        <script>
                                                            $(document).ready(function () {
                                                                $('#add_deal').modal('show');
                                                            });
                                                        </script>
                                                    <?php endif; ?>             
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <tr></tr>
                                    <?php endif; ?>
                                    
                                    <td colspan="8">
                                        <div class="header-wrapper">
                                            <a data-bs-toggle="collapse" class="collapse-link" href="#funded" role="button" aria-expanded="false" aria-controls="funded" style="min-width:10rem">
                                                Funded(<?php echo e($funded->count()); ?>)
                                            </a>
                                            <?php if($funded->count() > 0): ?>
                                                <a href="/deal/asc/funded">
                                                    <button class="btn btn-sm order-btn">▲</button>
                                                </a>
                                                <a href="/deal/desc/funded">
                                                    <button class="btn btn-sm order-btn">▼</button>
                                            
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                <?php if($funded->count() > 0): ?>
                                    <?php $__currentLoopData = $funded; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr class="collapse <?php echo e(($open_funded)?'show':''); ?>" id="funded">

                                            <td>
                                                <a href="/show_deal/<?php echo e($item->id); ?>"
                                                    style="text-decoration: none;cursor:pointer;color:rgb(129, 124, 124);display:block;">
                                                    <?php echo e($item->company_name); ?>.
                                                </a>
                                            </td>
                                            <td><?php echo e($item->marchant_name); ?></td>
                                            <td style="display: flex;">
                                                <?php
                                                $approvedNotes = [];
                                                $pendingNotes = [];
                                                $declinedNotes = [];

                                                foreach ($item->lenders as $lender) {
                                                if ($lender->pivot->status == 'Approved') {
                                                $approvedNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Pending') {
                                                $pendingNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Declined') {
                                                $declinedNotes[] = $lender->pivot->note;
                                                }
                                                }
                                                ?>

                                                <?php $__currentLoopData = $approvedNotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p style="margin-left: 5px" class="badge appr_span text-bg-success"><?php echo e(Str::limit($note, 8)); ?></p>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                <?php $__currentLoopData = $pendingNotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p style="margin-left: 5px" class="badge pen_span text-bg-warning"><?php echo e(Str::limit($note, 8)); ?>

                                                </p>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                <?php $__currentLoopData = $declinedNotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p style="margin-left: 5px" class="badge dec_span text-bg-danger"><?php echo e(Str::limit($note, 8)); ?></p>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </td>
                                            <td><?php echo e($item->phone_number); ?></td>
                                            <td><?php echo e($item->email); ?></td>
                                            <td><?php echo e($item->sale_rep); ?></td>
                                            <td><?php echo e($item->date_submitted); ?></td>
                                            <td style="display: flex;">
                                                <button type="button" class="btn btn-danger delete_deal"
                                                    data-id="<?php echo e($item->id); ?>">
                                                    Delete
                                                </button>
                                                <button type="button" data-id="<?php echo e($item->id); ?>"
                                                    class=" ms-2 btn-primary btn-sm btn">
                                                    Edit
                                                </button>
                                                <?php if($errors->any()): ?>
                                                    <script>
                                                        $(document).ready(function () {
                                                            $('#add_deal').modal('show');
                                                        });
                                                    </script>
                                                <?php endif; ?>             
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <tr></tr>
                                <?php endif; ?>
                                    
                                        <td colspan="8">
                                            <div class="header-wrapper">
                                                <a data-bs-toggle="collapse" class="collapse-link" href="#doc" role="button" aria-expanded="false" aria-controls="doc" style="min-width:10rem">
                                                    Doc's Offer(<?php echo e($doc->count()); ?>)
                                                </a>
                                                <?php if($doc->count() > 0): ?>
                                                    <a href="/deal/asc/doc">
                                                        <button class="btn btn-sm order-btn">▲</button>
                                                    </a>
                                                    <a href="/deal/desc/doc">
                                                        <button class="btn btn-sm order-btn">▼</button>
                                                
                                                    </a>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    <?php if($doc->count() > 0): ?>
                                        <?php $__currentLoopData = $doc; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr class="collapse <?php echo e(($open_doc)?'show':''); ?>" id="doc">

                                                <td>
                                                    <a href="/show_deal/<?php echo e($item->id); ?>"
                                                        style="text-decoration: none;cursor:pointer;color:rgb(129, 124, 124);display:block;">
                                                        <?php echo e($item->company_name); ?>.
                                                    </a>
                                                </td>
                                                <td><?php echo e($item->marchant_name); ?></td>
                                                <td style="display: flex;">
                                                <?php
                                                $approvedNotes = [];
                                                $pendingNotes = [];
                                                $declinedNotes = [];

                                                foreach ($item->lenders as $lender) {
                                                if ($lender->pivot->status == 'Approved') {
                                                $approvedNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Pending') {
                                                $pendingNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Declined') {
                                                $declinedNotes[] = $lender->pivot->note;
                                                }
                                                }
                                                ?>

                                                <?php $__currentLoopData = $approvedNotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p style="margin-left: 5px" class="badge appr_span text-bg-success"><?php echo e(Str::limit($note, 8)); ?></p>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                <?php $__currentLoopData = $pendingNotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p style="margin-left: 5px" class="badge pen_span text-bg-warning"><?php echo e(Str::limit($note, 8)); ?>

                                                </p>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                <?php $__currentLoopData = $declinedNotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p style="margin-left: 5px" class="badge dec_span text-bg-danger"><?php echo e(Str::limit($note, 8)); ?></p>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </td>
                                                <td><?php echo e($item->phone_number); ?></td>
                                                <td><?php echo e($item->email); ?></td>
                                                <td><?php echo e($item->sale_rep); ?></td>
                                                <td><?php echo e($item->date_submitted); ?></td>
                                                <td style="display: flex;">
                                                    <button type="button" class="btn btn-danger delete_deal"
                                                        data-id="<?php echo e($item->id); ?>">
                                                        Delete
                                                    </button>
                                                    <button type="button" data-id="<?php echo e($item->id); ?>"
                                                        class=" ms-2 btn-primary btn-sm btn">
                                                        Edit
                                                    </button>
                                                    <?php if($errors->any()): ?>
                                                        <script>
                                                            $(document).ready(function () {
                                                                $('#add_deal').modal('show');
                                                            });
                                                        </script>
                                                    <?php endif; ?>             
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <tr></tr>
                                    <?php endif; ?>

                                    
                                        <td colspan="8">
                                            <div class="header-wrapper">
                                                <a data-bs-toggle="collapse" class="collapse-link" href="#dead" role="button" aria-expanded="false" aria-controls="dead" style="min-width:10rem">
                                                    Dead(<?php echo e($dead->count()); ?>)
                                                </a>
                                                <?php if($dead->count() > 0): ?>
                                                    <a href="/deal/asc/dead">
                                                        <button class="btn btn-sm order-btn">▲</button>
                                                    </a>
                                                    <a href="/deal/desc/dead">
                                                        <button class="btn btn-sm order-btn">▼</button>
                                                
                                                    </a>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    <?php if($dead->count() > 0): ?>
                                        <?php $__currentLoopData = $dead; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr class="collapse <?php echo e(($open_dead)?'show':''); ?>" id="dead">

                                                <td>
                                                    <a href="/show_deal/<?php echo e($item->id); ?>"
                                                        style="text-decoration: none;cursor:pointer;color:rgb(129, 124, 124);display:block;">
                                                        <?php echo e($item->company_name); ?>.
                                                    </a>
                                                </td>
                                                <td><?php echo e($item->marchant_name); ?></td>
                                                <td style="display: flex;">
                                                <?php
                                                $approvedNotes = [];
                                                $pendingNotes = [];
                                                $declinedNotes = [];

                                                foreach ($item->lenders as $lender) {
                                                if ($lender->pivot->status == 'Approved') {
                                                $approvedNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Pending') {
                                                $pendingNotes[] = $lender->pivot->note;
                                                } elseif ($lender->pivot->status == 'Declined') {
                                                $declinedNotes[] = $lender->pivot->note;
                                                }
                                                }
                                                ?>

                                                <?php $__currentLoopData = $approvedNotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p style="margin-left: 5px" class="badge appr_span text-bg-success"><?php echo e(Str::limit($note, 8)); ?></p>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                <?php $__currentLoopData = $pendingNotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p style="margin-left: 5px" class="badge pen_span text-bg-warning"><?php echo e(Str::limit($note, 8)); ?>

                                                </p>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                <?php $__currentLoopData = $declinedNotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $note): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <p style="margin-left: 5px" class="badge dec_span text-bg-danger"><?php echo e(Str::limit($note, 8)); ?></p>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </td>
                                                <td><?php echo e($item->phone_number); ?></td>
                                                <td><?php echo e($item->email); ?></td>
                                                <td><?php echo e($item->sale_rep); ?></td>
                                                <td><?php echo e($item->date_submitted); ?></td>
                                                <td style="display: flex;">
                                                    <button type="button" class="btn btn-danger delete_deal"
                                                        data-id="<?php echo e($item->id); ?>">
                                                        Delete
                                                    </button>
                                                    <button type="button" data-id="<?php echo e($item->id); ?>"
                                                        class=" ms-2 btn-primary btn-sm btn">
                                                        Edit
                                                    </button>
                                                    <?php if($errors->any()): ?>
                                                        <script>
                                                            $(document).ready(function () {
                                                                $('#add_deal').modal('show');
                                                            });
                                                        </script>
                                                    <?php endif; ?>             
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <tr></tr>
                                    <?php endif; ?>






























































                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>


                </div>


            </div>
    </div>
    </main>

    </div>


    <?php if(Session::has('success')): ?>
        <script>
            Swal.fire({
                position: 'top-end',
                icon: 'success',
                title: "<?php echo Session::get('success'); ?>",
                showConfirmButton: false,
                timer: 1500
            })
        </script>
    <?php endif; ?>
    
<?php $__env->stopSection(); ?>
<!-- add deal Modal -->
<?php echo $__env->make('partials.deal_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('partials.edit_deal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>



<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/funderscrm/public_html/resources/views/deal/index.blade.php ENDPATH**/ ?>