<div class="modal fade" id="assignModal" tabindex="-1" aria-labelledby="assignModal" aria-hidden="true">
    <div class="modal-lg modal-dialog modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h6 class="modal-title fs-5 text-muted">Assign Lenders - Rep <?php echo e($deal->sale_rep); ?></h6>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>

            <div class="modal-body">
                <div class="row">
                    <div class="col-12">
                        <button class="btn w-100"
                            style="background-color: #e9ecef; box-shadow: -5px 0px rgb(0, 174, 255);">
                            Click a Lender To Assign/Unassign to This Loan
                        </button>

                        <div class="mt-2 mb-2">
                            <input type="text" id="search_pos_field" placeholder="filter by position"
                                class="form-control form-control-sm">
                        </div>
                    </div>

                    <div class="col-sm-6">

                        <!-- BUTTONS + COUNTER -->
                        <div class="mb-1 p-2 d-flex align-items-center gap-3 flex-wrap">
                            <div class="d-flex align-items-center">
                                <input type="checkbox" class="form-check-control me-2" id="checkAll">
                                <span>-Check All</span>
                            </div>

                            <button type="button" class="btn btn-sm btn-outline-success" id="selectMatches">
                                Select all matches
                            </button>

                            <button type="button" class="btn btn-sm btn-outline-secondary" id="clearSelection">
                                Clear selection
                            </button>

                            <span class="ms-auto small text-muted" id="selectionCounter">
                                Selected 0 of <?php echo e($lenders->count()); ?> active (<?php echo e($lenders->where('matches',true)->count()); ?> matches)
                            </span>
                        </div>

                        <form action="<?php echo e(url('assign_lender')); ?>" method="post">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="deal_id" value="<?php echo e($deal->id); ?>">

                            <?php $__currentLoopData = $lenders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="mb-1 p-2 border d-flex align-items-center justify-content-between check_box_parent 
                                    <?php echo e(Str::lower($item->position)); ?> border-light">

                                    <div class="d-flex align-items-center">

                                        <!-- CHECKBOX WITH FIXED MATCH ATTR -->
                                        <input type="checkbox"
                                            class="form-check-control me-3 lender-checkbox"
                                            name="lenders[]"
                                            id="lender_<?php echo e($item->id); ?>"
                                            value="<?php echo e($item->id); ?>"
                                            data-match="<?php echo e((!empty($item->matches) && $item->matches) ? '1' : '0'); ?>"
                                            <?php if(in_array($item->id, $deal_lenders_asigned)): ?> checked
                                            <?php elseif(!empty($item->matches) && $item->matches): ?> checked
                                            <?php endif; ?>
                                        >

                                        <div>
                                            <div class="d-flex align-items-center gap-2">
                                                <span><?php echo e($item->company_name); ?><?php if($item->position): ?>, <?php echo e($item->position); ?><?php endif; ?></span>

                                                <?php if(in_array($item->id, $deal_lenders_asigned)): ?>
                                                    <span class="badge bg-primary">Assigned</span>
                                                <?php endif; ?>

                                                <?php if(!empty($item->matches) && $item->matches): ?>
                                                    <span class="badge bg-success">Matches</span>
                                                <?php else: ?>
                                                    <span class="badge bg-light text-dark">No match</span>
                                                <?php endif; ?>
                                            </div>

                                            <?php if(!empty($item->criteria_summary)): ?>
                                                <div class="text-muted small" title="<?php echo e($item->criteria_summary); ?>">
                                                    <?php echo e($item->criteria_summary); ?>

                                                </div>
                                            <?php endif; ?>
                                        </div>

                                    </div>

                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>
                </div>
            </div>

            <div class="modal-footer">
                <button type="button" class="btn submit_button" data-bs-dismiss="modal">Close</button>
                <button type="submit" class="btn submit_button" id="submit_button">Submit</button>
            </div>

            </form>
        </div>
    </div>
</div>

<!-- LOAD jQuery BEFORE EVERYTHING (required) -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- FIXED JAVASCRIPT -->
<script>
$(document).ready(function () {

    function updateCounter() {
        var total = $('.lender-checkbox').length;
        var selected = $('.lender-checkbox:checked').length;
        var matches = $('.lender-checkbox[data-match="1"]').length;

        $('#selectionCounter').text(
            'Selected ' + selected + ' of ' + total + ' active (' + matches + ' matches)'
        );

        $('#submit_button').prop('disabled', selected < 1);
    }

    updateCounter();

    // --- CHECK ALL ---
    $('#checkAll').click(function () {
        var status = $(this).prop('checked');
        $('.lender-checkbox').prop('checked', status);
        updateCounter();
    });

    // --- SELECT MATCHES ---
    $('#selectMatches').click(function () {
        $('.lender-checkbox[data-match="1"]').prop('checked', true);
        updateCounter();
    });

    // --- CLEAR SELECTION ---
    $('#clearSelection').click(function () {
        $('.lender-checkbox').prop('checked', false);
        $('#checkAll').prop('checked', false);
        updateCounter();
    });

    // --- WHEN INDIVIDUAL BOXES CHANGE ---
    $(document).on('change', '.lender-checkbox', function () {
        updateCounter();
    });

    // --- FILTER BY POSITION ---
    $('#search_pos_field').keyup(function () {
        var value = $(this).val().trim().toLowerCase();

        if (value === '') {
            $('.check_box_parent').show();
        } else {
            $('.check_box_parent').each(function () {
                var match = $(this).hasClass(value);
                $(this).toggle(match);
            });
        }
    });

});
</script>
<?php /**PATH /home/funderscrm/public_html/resources/views/partials/assign_lender.blade.php ENDPATH**/ ?>