<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudSearch;

class FilterOptions extends \Google\Model
{
  protected $filterType = Filter::class;
  protected $filterDataType = '';
  /**
   * If object_type is set, only objects of that type are returned. This should
   * correspond to the name of the object that was registered within the
   * definition of schema. The maximum length is 256 characters.
   *
   * @var string
   */
  public $objectType;

  /**
   * Generic filter to restrict the search, such as `lang:en`, `site:xyz`.
   *
   * @param Filter $filter
   */
  public function setFilter(Filter $filter)
  {
    $this->filter = $filter;
  }
  /**
   * @return Filter
   */
  public function getFilter()
  {
    return $this->filter;
  }
  /**
   * If object_type is set, only objects of that type are returned. This should
   * correspond to the name of the object that was registered within the
   * definition of schema. The maximum length is 256 characters.
   *
   * @param string $objectType
   */
  public function setObjectType($objectType)
  {
    $this->objectType = $objectType;
  }
  /**
   * @return string
   */
  public function getObjectType()
  {
    return $this->objectType;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(FilterOptions::class, 'Google_Service_CloudSearch_FilterOptions');
