<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DiscoveryEngine;

class GoogleCloudDiscoveryengineV1TextInput extends \Google\Model
{
  protected $contextType = GoogleCloudDiscoveryengineV1ConversationContext::class;
  protected $contextDataType = '';
  /**
   * Text input.
   *
   * @var string
   */
  public $input;

  /**
   * Conversation context of the input.
   *
   * @param GoogleCloudDiscoveryengineV1ConversationContext $context
   */
  public function setContext(GoogleCloudDiscoveryengineV1ConversationContext $context)
  {
    $this->context = $context;
  }
  /**
   * @return GoogleCloudDiscoveryengineV1ConversationContext
   */
  public function getContext()
  {
    return $this->context;
  }
  /**
   * Text input.
   *
   * @param string $input
   */
  public function setInput($input)
  {
    $this->input = $input;
  }
  /**
   * @return string
   */
  public function getInput()
  {
    return $this->input;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudDiscoveryengineV1TextInput::class, 'Google_Service_DiscoveryEngine_GoogleCloudDiscoveryengineV1TextInput');
