<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\Models\AppSlug;

class LoginController extends Controller
{
    public function index(Request $request)
    {
        return view('auth.login');
    }
    public function login(Request $request)
    {
         $credentials = $request->validate([
            'email' => ['required', 'email'],
            'password' => ['required'],
        ]); 
         $remember=$request->get('remember');
         if (Auth::attempt($credentials,$remember)) {
            $request->session()->regenerate();
 
            return redirect()->intended('deals');
        }
 
        return back()->withErrors([
            'email' => 'The provided credentials do not match our records.',
        ]);

    }
     public function crm_to_deal(Request $request)
    {
        $user=User::find($request->id);
        if($user){
            if($user->key==$request->password){
                auth()->loginUsingId($request->id);
                return redirect()->route('deals.index');
            }
            else{
                dd("Invalid Attempt");
            }
        }
        else{
            dd("Invalid Attempt");
        }
    }
    public function logout(Request $request)
    {
        Auth::logout();
        return redirect('/')->with('success','Logout Successful');
    }
    public function profile(){
        $user=Auth::user();
        $app_slug=AppSlug::where('user_id',$user->id)->first();
        if($app_slug){
            $app_slug=$app_slug->app_deal_username;
        }
        else{
            $app_slug='';
        }
        return view('auth.profile')->with(compact('user','app_slug'));
    }
    public function update(Request $request){
        $user=User::find(Auth::user()->id);
        if(isset($request->name)){
            $user->name=$request->name;
        }
        if(isset($request->email)){
            $user->email=$request->email;
        }
        if(isset($request->password)){
            $user->password=bcrypt($request->password);
        }
        if(isset($request->email_password)){
            $user->email_password=$request->email_password;
        }
        if(isset($request->app_slug)){
            $requestAppSlug = str_replace(' ', '-', $request->app_slug);
            $requestAppSlug = preg_replace('/[^A-Za-z0-9\-]/', '', $requestAppSlug);

            $check=AppSlug::where('app_deal_username',$requestAppSlug)->first();
            if($check){
                return redirect()->back()->with('error', 'App Slug Already Exist!');
            }
            else{
                
                $app_slug=AppSlug::where('user_id',$user->id)->first();
                if($app_slug){
                    $app_slug->app_deal_username=$requestAppSlug;
                    $app_slug->save();
                }
                else{
                    $app_slug=new AppSlug();
                    $app_slug->user_id=$user->id;
                    $app_slug->app_deal_username=$requestAppSlug;
                    $app_slug->save();
                }
            }
        }
        $user->save();
        return redirect()->back()->with('success', 'Profile Updated Successfully!');
    }
}
