<?php

namespace App\Http\Controllers;

use App\Models\Deal;
use App\Models\Commission;
use App\Models\User;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        $totalDeals = Deal::count();
        $fundedDeals = Deal::where('status', 'Funded')->count();
        $totalCommissions = Commission::sum('amount');
        $totalUsers = User::count();
        return view('dashboard.index', compact('totalDeals', 'fundedDeals', 'totalCommissions', 'totalUsers'));
    }
}
