<?php

namespace App\Http\Controllers\Finance;

use App\Http\Controllers\Controller;
use App\Mail\LenderEmail;
use App\Mail\LenderPosition;
use Illuminate\Http\Request;
use App\Models\Deal;
use App\Models\Lender;
use App\Models\User;
use App\Models\Team;
use App\Models\DealFiles;
use Carbon\Carbon;
use App\Models\DealLender;
use App\Models\Loan;
use App\Models\SaleNote;
use App\Models\EmailData;
use App\Models\SystemNote;
use App\Models\UserTeam;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Storage;

use function PHPSTORM_META\argumentsSet;

class DealController extends Controller
{
  public function index(Request $request)
  {
    $this->update_auto_status();
    $loan=Loan::where('deal_id',$request->deal_id)->first();
    $reps = User::role('Sale_rep')->get();
    $teams=Team::all();
    $sort='desc';
    $open_s=$open_uw=$open_app=$open_cold=$open_reshop=$open_open=$open_open_team=$open_dead=$open_funded=$open_doc=$open_proc=false;
    // dd($reps);
    // if (auth()->user()->hasRole('Team_Lead')) {
    //   $deals = Deal::where('sale_rep2','=',auth()->user()->name)->get()->groupBy('status');
    // } else {
    //   $deals = Deal::where('sale_rep','=',auth()->user()->name)->get()->groupBy('status');
    // }
    if(auth()->user()->hasRole('Admin') || auth()->user()->hasRole('Processor') ){
      $deals = Deal::orderBy('created_at', $sort)->get();
    }
    else if(auth()->user()->hasRole('Lender') ){
      //get all deals with this lender
      $email=auth()->user()->email;
      $lender=Lender::where('email',$email)->first();
      $deals=$lender->deals;
    }
    else if ((count(auth()->user()->teams)>=1) && !auth()->user()->hasRole('Admin')) {
      // $teams = Team::where('team_leader_id', auth()->user()->id)->get();
      $teams=User::find(auth()->user()->id)->teams;
      // dd($teams);
      $deals = Deal::whereIn('team_id', $teams->pluck('id'))
      ->orWhere('sale_rep2', auth()->user()->name)
      ->orWhere('sale_rep', auth()->user()->name)
      ->orWhere('status', "Open")
      ->orderBy('created_at', $sort)->get();
    } else {
      $deals = Deal::where('sale_rep', auth()->user()->name)
      ->orWhere('sale_rep2', auth()->user()->name)
      ->orWhere('status', "Open")
      ->orderBy('created_at', $sort)
      ->get();
    }
    $submitted = $deals->where('status', 'Submitted');
    $underwritter = $deals->where('status', 'Underwritter');
    $approved = $deals->where('status', 'Approved');
    $accepted = $deals->where('status', 'Accepted');
    $coldoffer = $deals->where('status', 'Cold Offer');
    $reshop = $deals->where('status', 'Reshop');
    $need_approve = $deals->where('status', 'Need Approve');
    $open = $deals->where('status', 'Open');
    $team_id=UserTeam::where('user_id',auth()->user()->id)->pluck('team_id')->toArray();
    $open_team = $deals->where('status', 'Open For Team')->whereIn('team_id',$team_id);
    $dead = $deals->where('status', 'Dead');
    $funded = $deals->where('status', 'Funded');
    $doc = $deals->where('status', "Doc's Out");
    $proc = $deals->where('status', "Processor");
    // dd($need_approve);

    if(isset($request->type) && isset($request->sort)){
      switch($request->type) {
        case('rep'):
          $open_s=$open_app=$open_cold=$open_reshop=$open_s=false;
          $sortOrder = ($request->sort === 'asc') ? SORT_REGULAR : SORT_NATURAL;
          $submitted = $deals->where('status', 'Submitted')
                            ->sortBy('sale_rep', $sortOrder)
                            ->values();
          if ($request->sort === 'desc') {
              $submitted = $submitted->reverse();
          }
          break;
        case('submitted'):
          $open_s=true;
          $sortOrder = ($request->sort === 'asc') ? SORT_REGULAR : SORT_NATURAL;
          $submitted = $deals->where('status', 'Submitted')
                            ->sortBy('created_at', $sortOrder)
                            ->values();
          if ($request->sort === 'desc') {
              $submitted = $submitted->reverse();
          }
          break;
        case('underwritter'):
          $open_uw=true;
          $sortOrder = ($request->sort === 'asc') ? SORT_REGULAR : SORT_NATURAL;
          $underwritter = $deals->where('status', 'Underwritter')
                            ->sortBy('created_at', $sortOrder)
                            ->values();
          if ($request->sort === 'desc') {
              $underwritter = $underwritter->reverse();
          }
          break;
        case('approved'):
          $open_app=true;
          $sortOrder = ($request->sort === 'asc') ? SORT_REGULAR : SORT_NATURAL;
          $approved = $deals->where('status', 'Approved')
                            ->sortBy('created_at', $sortOrder)
                            ->values();
          if ($request->sort === 'desc') {
              $approved = $approved->reverse();
          }
          break;
//          case('accepted'):
//              $open_app=true;
//              $sortOrder = ($request->sort === 'asc') ? SORT_REGULAR : SORT_NATURAL;
//              $accepted = $deals->where('status', 'Accepted')
//                  ->sortBy('created_at', $sortOrder)
//                  ->values();
//              if ($request->sort === 'desc') {
//                  $accepted = $accepted->reverse();
//              }
//              break;
        case('coldoffer'): 
          $open_cold=true; 
          $sortOrder = ($request->sort === 'asc') ? SORT_REGULAR : SORT_NATURAL;
          $coldoffer = $deals->where('status', 'Cold Offer')
                            ->sortBy('updated_at', $sortOrder)
                            ->values();
          if ($request->sort === 'desc') {
              $coldoffer = $coldoffer->reverse();
          }
          break;
        case('reshop'): 
          $open_reshop=true; 
          $sortOrder = ($request->sort === 'asc') ? SORT_REGULAR : SORT_NATURAL;
          $reshop = $deals->where('status', 'Reshop')
                            ->sortBy('updated_at', $sortOrder)
                            ->values();
          if ($request->sort === 'desc') {
              $reshop = $reshop->reverse();
            }
        break;  
        case('reshop'): 
          $open_reshop=true; 
          $sortOrder = ($request->sort === 'asc') ? SORT_REGULAR : SORT_NATURAL;
          $reshop = $deals->where('status', 'Reshop')
                            ->sortBy('updated_at', $sortOrder)
                            ->values();
          if ($request->sort === 'desc') {
              $reshop = $reshop->reverse();
            }
        break;  
        case('open'): 
          $open_open=true; 
          $sortOrder = ($request->sort === 'asc') ? SORT_REGULAR : SORT_NATURAL;
          $open = $deals->where('status', 'Open')
                            ->sortBy('updated_at', $sortOrder)
                            ->values();
          if ($request->sort === 'desc') {
              $open = $open->reverse();
            }
        break;
        case('open_team'): 
          $open_open_team=true; 
          $sortOrder = ($request->sort === 'asc') ? SORT_REGULAR : SORT_NATURAL;
          $open_team = $deals->where('status', 'Open For Team')
                            ->sortBy('updated_at', $sortOrder)
                            ->values();
          if ($request->sort === 'desc') {
              $open_team = $open_team->reverse();
            }
        break;   
        case('funded'): 
          $open_funded=true; 
          $sortOrder = ($request->sort === 'asc') ? SORT_REGULAR : SORT_NATURAL;
          $funded = $deals->where('status', 'Funded')
                            ->sortBy('updated_at', $sortOrder)
                            ->values();
          if ($request->sort === 'desc') {
              $funded = $funded->reverse();
            }
        break;  
        case('dead'): 
          $open_dead=true; 
          $sortOrder = ($request->sort === 'asc') ? SORT_REGULAR : SORT_NATURAL;
          $dead = $deals->where('status', 'Dead')
                            ->sortBy('updated_at', $sortOrder)
                            ->values();
          if ($request->sort === 'desc') {
              $dead = $dead->reverse();
            }
        break;  
        case('doc'): 
          $open_doc=true; 
          $sortOrder = ($request->sort === 'asc') ? SORT_REGULAR : SORT_NATURAL;
          $doc = $deals->where('status', "Doc's Out")
                            ->sortBy('updated_at', $sortOrder)
                            ->values();
          if ($request->sort === 'desc') {
              $doc = $doc->reverse();
            }
        break; 
        case('proc'): 
          $open_proc=true; 
          $sortOrder = ($request->sort === 'asc') ? SORT_REGULAR : SORT_NATURAL;
          $proc = $deals->where('status', "Processor")
                            ->sortBy('updated_at', $sortOrder)
                            ->values();
          if ($request->sort === 'desc') {
              $proc = $proc->reverse();
            }
        break; 
      }    
    }

    // $deal = Deal::all();
    // $submitted = Deal::where('status', 'Submitted')->get();
    // $underwritter = Deal::where('status', 'Underwritter')->get();
    // $approved = Deal::where('status', 'Approved')->get();
    // $coldoffer = Deal::where('status', 'Submitted')->whereDate('created_at', Carbon::now()->subDays(7))->get();



    return view('deal.index', compact('submitted',
        'reps','teams','open_s','open_app','open_uw','open_cold', 'accepted',
        'open_reshop', 'reshop','proc','open_proc','need_approve','underwritter',
        'coldoffer', 'approved','loan','open','open_team','dead','funded','doc',
        'open_open','open_open_team','open_dead','open_funded','open_doc'));
  }
  public function update_auto_status(){
    // dd('asd');
    $coldoffer = Deal::where('status', 'Approved')->where('updated_at', '<=', now()->subDays(6))->get();
    foreach($coldoffer as $deal){
      $deal->update(['status' => 'Cold Offer']);
    }
    $reshop = Deal::where('status', 'Underwritter')->where('updated_at', '<=', now()->subDays(1))->get();
    foreach($reshop as $deal){
      $deal->update(['status' => 'Reshop']);
    }
    $open_team = Deal::where('status', 'Cold Offer')->where('updated_at', '<=', now()->subDays(1))->get();
    foreach($open_team as $deal){
      $deal->update(['status' => 'Open For Team']);
    }
    $open_team = Deal::where('status', 'Submitted')->where('updated_at', '<=', now()->subDays(7))->get();
    foreach($open_team as $deal){
      $deal->update(['status' => 'Open For Team']);
    }
    $open_team = Deal::where('status', 'Underwritter')->where('updated_at', '<=', now()->subDays(7))->get();
    foreach($open_team as $deal){
      $deal->update(['status' => 'Open For Team']);
    }
    $open_team = Deal::where('status', "Doc's Out")->where('updated_at', '<=', now()->subDays(7))->get();
    foreach($open_team as $deal){
      $deal->update(['status' => 'Open For Team']);
    }
    $open = Deal::where('status', "Open Team")->where('updated_at', '<=', now()->subDays(7))->get();
    foreach($open as $deal){
      $deal->update(['status' => 'Open']);
    }
  }
  // public function deal_catagory_update(Deal $deal)
  // {
  //   if($deal->updated_at >= Carbon::today()->subDays( 2 )){
  //     if($deal->status == 'Underwritter'){
  //       $deal->update(['status' => 'Reshop']);
  //     }
  //     elseif($deal->status == 'Approved'){
  //       $deal->update(['status' => 'Cold Offer']);
  //     }
  //     $deal->update(['status' => 'Underwritter']);
  //     return redirect()->back()->with('success', 'Deal Status Updated Successfully');
  //   }
  // }
  public function search(Request $request)
  {
    $this->update_auto_status();
    $loan=Loan::where('deal_id',$request->deal_id)->first();
    $disable=false;
    $old=Lender::where('old',1)->get();
    if(count($old)>0){
      $disable=true;
    }
    $reps = User::role('Sale_rep')->get();
    $teams=Team::all();
    $sort='desc';
    $open_s=$open_uw=$open_app=$open_cold=$open_reshop=$open_open=$open_open_team=$open_dead=$open_funded=$open_doc=$open_proc=false;
    $team_id=UserTeam::where('user_id',auth()->user()->id)->pluck('team_id')->toArray();
    // dd($reps);
    $need_approve = Deal::where('status', 'Need Approve');    
    if (
      $request->company_name && $request->phone_number && $request->email && $request->marchant_name
      && $request->sale_rep && $request->last_contacted
    ) {
      $submitted = Deal::where('company_name', 'LIKE', '%' . $request->company_name . '%')
        ->where('email', 'LIKE', '%' . $request->email . '%')
        ->where('phone_number', 'LIKE', '%' . $request->phone_number . '%')
        ->where('marchant_name', 'LIKE', '%' . $request->marchant_name . '%')
        ->where('sale_rep', 'LIKE', '%' . $request->sale_rep . '%')
        ->where('last_contacted', 'LIKE', '%' . $request->last_contacted . '%')
        ->where('status', 'Submitted')
        ->get();
      $underwritter = Deal::where('company_name', 'LIKE', '%' . $request->company_name . '%')
        ->where('email', 'LIKE', '%' . $request->email . '%')
        ->where('phone_number', 'LIKE', '%' . $request->phone_number . '%')
        ->where('marchant_name', 'LIKE', '%' . $request->marchant_name . '%')
        ->where('sale_rep', 'LIKE', '%' . $request->sale_rep . '%')
        ->where('last_contacted', 'LIKE', '%' . $request->last_contacted . '%')
        ->where('status', 'Underwritter')
        ->get();
      $approved = Deal::where('company_name', 'LIKE', '%' . $request->company_name . '%')
        ->where('email', 'LIKE', '%' . $request->email . '%')
        ->where('phone_number', 'LIKE', '%' . $request->phone_number . '%')
        ->where('marchant_name', 'LIKE', '%' . $request->marchant_name . '%')
        ->where('sale_rep', 'LIKE', '%' . $request->sale_rep . '%')
        ->where('last_contacted', 'LIKE', '%' . $request->last_contacted . '%')
        ->where('status', 'Approved')
        ->get();
      $coldoffer = Deal::where('company_name', 'LIKE', '%' . $request->company_name . '%')
        ->where('email', 'LIKE', '%' . $request->email . '%')
        ->where('phone_number', 'LIKE', '%' . $request->phone_number . '%')
        ->where('marchant_name', 'LIKE', '%' . $request->marchant_name . '%')
        ->where('sale_rep', 'LIKE', '%' . $request->sale_rep . '%')
        ->where('last_contacted', 'LIKE', '%' . $request->last_contacted . '%')
        ->where('status', 'Cold Offer')
        ->get();
      $reshop = Deal::where('company_name', 'LIKE', '%' . $request->company_name . '%')
        ->where('email', 'LIKE', '%' . $request->email . '%')
        ->where('phone_number', 'LIKE', '%' . $request->phone_number . '%')
        ->where('marchant_name', 'LIKE', '%' . $request->marchant_name . '%')
        ->where('sale_rep', 'LIKE', '%' . $request->sale_rep . '%')
        ->where('last_contacted', 'LIKE', '%' . $request->last_contacted . '%')
        ->where('status', 'Reshop')
        ->get();
      $open = Deal::where('company_name', 'LIKE', '%' . $request->company_name . '%')
        ->where('email', 'LIKE', '%' . $request->email . '%')
        ->where('phone_number', 'LIKE', '%' . $request->phone_number . '%')
        ->where('marchant_name', 'LIKE', '%' . $request->marchant_name . '%')
        ->where('sale_rep', 'LIKE', '%' . $request->sale_rep . '%')
        ->where('last_contacted', 'LIKE', '%' . $request->last_contacted . '%')
        ->where('status', 'Open')
        ->get();
      $open_team = Deal::where('company_name', 'LIKE', '%' . $request->company_name . '%')
        ->where('email', 'LIKE', '%' . $request->email . '%')
        ->where('phone_number', 'LIKE', '%' . $request->phone_number . '%')
        ->where('marchant_name', 'LIKE', '%' . $request->marchant_name . '%')
        ->where('sale_rep', 'LIKE', '%' . $request->sale_rep . '%')
        ->where('last_contacted', 'LIKE', '%' . $request->last_contacted . '%')
        ->where('status', 'Open For Team')->whereIn('team_id',$team_id)
        ->get();
      $dead = Deal::where('company_name', 'LIKE', '%' . $request->company_name . '%')
        ->where('email', 'LIKE', '%' . $request->email . '%')
        ->where('phone_number', 'LIKE', '%' . $request->phone_number . '%')
        ->where('marchant_name', 'LIKE', '%' . $request->marchant_name . '%')
        ->where('sale_rep', 'LIKE', '%' . $request->sale_rep . '%')
        ->where('last_contacted', 'LIKE', '%' . $request->last_contacted . '%')
        ->where('status', 'Dead')
        ->get();
      $funded = Deal::where('company_name', 'LIKE', '%' . $request->company_name . '%')
        ->where('email', 'LIKE', '%' . $request->email . '%')
        ->where('phone_number', 'LIKE', '%' . $request->phone_number . '%')
        ->where('marchant_name', 'LIKE', '%' . $request->marchant_name . '%')
        ->where('sale_rep', 'LIKE', '%' . $request->sale_rep . '%')
        ->where('last_contacted', 'LIKE', '%' . $request->last_contacted . '%')
        ->where('status', 'Funded')
        ->get();
      $doc = Deal::where('company_name', 'LIKE', '%' . $request->company_name . '%')
        ->where('email', 'LIKE', '%' . $request->email . '%')
        ->where('phone_number', 'LIKE', '%' . $request->phone_number . '%')
        ->where('marchant_name', 'LIKE', '%' . $request->marchant_name . '%')
        ->where('sale_rep', 'LIKE', '%' . $request->sale_rep . '%')
        ->where('last_contacted', 'LIKE', '%' . $request->last_contacted . '%')
        ->where('status', "Doc's Out")
        ->get();
      $proc = Deal::where('company_name', 'LIKE', '%' . $request->company_name . '%')
        ->where('email', 'LIKE', '%' . $request->email . '%')
        ->where('phone_number', 'LIKE', '%' . $request->phone_number . '%')
        ->where('marchant_name', 'LIKE', '%' . $request->marchant_name . '%')
        ->where('sale_rep', 'LIKE', '%' . $request->sale_rep . '%')
        ->where('last_contacted', 'LIKE', '%' . $request->last_contacted . '%')
        ->where('status', "Processor")
        ->get();
    } else if ($request->company_name) {
      $submitted = Deal::where('company_name', 'LIKE', '%' . $request->company_name . '%')
        ->where('status', 'Submitted')
        ->get();
      $underwritter = Deal::where('company_name', 'LIKE', '%' . $request->company_name . '%')
        ->where('status', 'Underwritter')
        ->get();
      $approved = Deal::where('company_name', 'LIKE', '%' . $request->company_name . '%')
        ->where('status', 'Approved')
        ->get();
      $coldoffer = Deal::where('company_name', 'LIKE', '%' . $request->company_name . '%')
        ->where('status', 'Cold Offer')
        ->get();
      $reshop = Deal::where('company_name', 'LIKE', '%' . $request->company_name . '%')
        ->where('status', 'Reshop')
        ->get();
      $open = Deal::where('company_name', 'LIKE', '%' . $request->company_name . '%')
        ->where('status', 'Open')
        ->get();
      $open_team = Deal::where('company_name', 'LIKE', '%' . $request->company_name . '%')
        ->where('status', 'Open For Team')->whereIn('team_id',$team_id)
        ->get();
      $funded = Deal::where('company_name', 'LIKE', '%' . $request->company_name . '%')
        ->where('status', 'Funded')
        ->get();
      $dead = Deal::where('company_name', 'LIKE', '%' . $request->company_name . '%')
        ->where('status', 'Dead')
        ->get();
      $doc = Deal::where('company_name', 'LIKE', '%' . $request->company_name . '%')
        ->where('status', "Doc's Out")
        ->get();
      $proc = Deal::where('company_name', 'LIKE', '%' . $request->company_name . '%')
        ->where('status', "Processor")
        ->get();
    } else if ($request->marchant_name) {
      $submitted = Deal::where('marchant_name', 'LIKE', '%' . $request->marchant_name . '%')
        ->where('status', 'Submitted')
        ->get();
      $underwritter = Deal::where('marchant_name', 'LIKE', '%' . $request->marchant_name . '%')
        ->where('status', 'Underwritter')
        ->get();
      $approved = Deal::where('marchant_name', 'LIKE', '%' . $request->marchant_name . '%')
        ->where('status', 'Approved')
        ->get();
      $coldoffer = Deal::where('marchant_name', 'LIKE', '%' . $request->marchant_name . '%')
        ->where('status', 'Cold Offer')
        ->get();
      $reshop = Deal::where('marchant_name', 'LIKE', '%' . $request->marchant_name . '%')
        ->where('status', 'Reshop')
        ->get();
      $open = Deal::where('marchant_name', 'LIKE', '%' . $request->marchant_name . '%')
        ->where('status', 'Open')
        ->get();
      $open_team = Deal::where('marchant_name', 'LIKE', '%' . $request->marchant_name . '%')
        ->where('status', 'Open For Team')->whereIn('team_id',$team_id)
        ->get();
      $funded = Deal::where('marchant_name', 'LIKE', '%' . $request->marchant_name . '%')
        ->where('status', 'Funded')
        ->get();
      $dead = Deal::where('marchant_name', 'LIKE', '%' . $request->marchant_name . '%')
        ->where('status', 'Dead')
        ->get();
      $doc = Deal::where('marchant_name', 'LIKE', '%' . $request->marchant_name . '%')
        ->where('status', "Doc's Out")
        ->get();
      $proc = Deal::where('marchant_name', 'LIKE', '%' . $request->marchant_name . '%')
        ->where('status', "Processor")
        ->get();
    } else if ($request->phone_number) {
      $submitted = Deal::where('phone_number', 'LIKE', '%' . $request->phone_number . '%')
        ->where('status', 'Submitted')
        ->get();
      $underwritter = Deal::where('phone_number', 'LIKE', '%' . $request->phone_number . '%')
        ->where('status', 'Underwritter')
        ->get();
      $approved = Deal::where('phone_number', 'LIKE', '%' . $request->phone_number . '%')
        ->where('status', 'Approved')
        ->get();
      $coldoffer = Deal::where('phone_number', 'LIKE', '%' . $request->phone_number . '%')
        ->where('status', 'Cold Offer')
        ->get();
      $reshop = Deal::where('phone_number', 'LIKE', '%' . $request->phone_number . '%')
        ->where('status', 'Reshop')
        ->get();
      $open = Deal::where('phone_number', 'LIKE', '%' . $request->phone_number . '%')
        ->where('status', 'Open')
        ->get();
      $open_team = Deal::where('phone_number', 'LIKE', '%' . $request->phone_number . '%')
        ->where('status', 'Open For Team')->whereIn('team_id',$team_id)
        ->get();
      $funded = Deal::where('phone_number', 'LIKE', '%' . $request->phone_number . '%')
        ->where('status', 'Funded')
        ->get();
      $dead = Deal::where('phone_number', 'LIKE', '%' . $request->phone_number . '%')
        ->where('status', 'Dead')
        ->get();
      $doc = Deal::where('phone_number', 'LIKE', '%' . $request->phone_number . '%')
        ->where('status', "Doc's Out")
        ->get();
      $proc = Deal::where('phone_number', 'LIKE', '%' . $request->phone_number . '%')
        ->where('status', "Processor")
        ->get();
    } else if ($request->email) {
      $submitted = Deal::where('email', 'LIKE', '%' . $request->email . '%')
        ->where('status', 'Submitted')
        ->get();
      $underwritter = Deal::where('email', 'LIKE', '%' . $request->email . '%')
        ->where('status', 'Underwritter')
        ->get();
      $approved = Deal::where('email', 'LIKE', '%' . $request->email . '%')
        ->where('status', 'Approved')
        ->get();
      $coldoffer = Deal::where('email', 'LIKE', '%' . $request->email . '%')
        ->where('status', 'Cold Offer')
        ->get();
      $reshop = Deal::where('email', 'LIKE', '%' . $request->email . '%')
        ->where('status', 'Reshop')
        ->get();
      $open = Deal::where('email', 'LIKE', '%' . $request->email . '%')
        ->where('status', 'Open')
        ->get();
      $open_team = Deal::where('email', 'LIKE', '%' . $request->email . '%')
        ->where('status', 'Open For Team')->whereIn('team_id',$team_id)
        ->get();
      $funded = Deal::where('email', 'LIKE', '%' . $request->email . '%')
        ->where('status', 'Funded')
        ->get();
      $dead = Deal::where('email', 'LIKE', '%' . $request->email . '%')
        ->where('status', 'Dead')
        ->get();
      $doc = Deal::where('email', 'LIKE', '%' . $request->email . '%')
        ->where('status', "Doc's Out")
        ->get();
      $proc = Deal::where('email', 'LIKE', '%' . $request->email . '%')
        ->where('status', "Processor")
        ->get();
    } else if ($request->sale_rep) {
      $submitted = Deal::where('sale_rep', 'LIKE', '%' . $request->sale_rep . '%')
        ->where('status', 'Submitted')
        ->get();
      $underwritter = Deal::where('sale_rep', 'LIKE', '%' . $request->sale_rep . '%')
        ->where('status', 'Underwritter')
        ->get();
      $approved = Deal::where('sale_rep', 'LIKE', '%' . $request->sale_rep . '%')
        ->where('status', 'Approved')
        ->get();
      $coldoffer = Deal::where('sale_rep', 'LIKE', '%' . $request->sale_rep . '%')
        ->where('status', 'Cold Offer')
        ->get();
      $reshop = Deal::where('sale_rep', 'LIKE', '%' . $request->sale_rep . '%')
        ->where('status', 'Reshop')
        ->get();
      $open = Deal::where('sale_rep', 'LIKE', '%' . $request->sale_rep . '%')
        ->where('status', 'Open')
        ->get();
      $open_team = Deal::where('sale_rep', 'LIKE', '%' . $request->sale_rep . '%')
        ->where('status', 'Open For Team')->whereIn('team_id',$team_id)
        ->get();
      $funded = Deal::where('sale_rep', 'LIKE', '%' . $request->sale_rep . '%')
        ->where('status', 'Funded')
        ->get();
      $dead = Deal::where('sale_rep', 'LIKE', '%' . $request->sale_rep . '%')
        ->where('status', 'Dead')
        ->get();
      $doc = Deal::where('sale_rep', 'LIKE', '%' . $request->sale_rep . '%')
        ->where('status', "Doc's Out")
        ->get();
      $proc = Deal::where('sale_rep', 'LIKE', '%' . $request->sale_rep . '%')
        ->where('status', "Processor")
        ->get();
    } else if ($request->last_contacted) {
      $submitted = Deal::where('last_contacted', 'LIKE', '%' . $request->last_contacted . '%')
        ->where('status', 'Submitted')
        ->get();
      $underwritter = Deal::where('last_contacted', 'LIKE', '%' . $request->last_contacted . '%')
        ->where('status', 'Underwritter')
        ->get();
      $approved = Deal::where('last_contacted', 'LIKE', '%' . $request->last_contacted . '%')
        ->where('status', 'Approved')
        ->get();
      $coldoffer = Deal::where('last_contacted', 'LIKE', '%' . $request->last_contacted . '%')
        ->where('status', 'Cold Offer')
        ->get();
      $reshop = Deal::where('last_contacted', 'LIKE', '%' . $request->last_contacted . '%')
        ->where('status', 'Reshop')
        ->get();
      $open = Deal::where('last_contacted', 'LIKE', '%' . $request->last_contacted . '%')
        ->where('status', 'Open')
        ->get();
      $open_team = Deal::where('last_contacted', 'LIKE', '%' . $request->last_contacted . '%')
        ->where('status', 'Open For Team')->whereIn('team_id',$team_id)
        ->get();
      $funded = Deal::where('last_contacted', 'LIKE', '%' . $request->last_contacted . '%')
        ->where('status', 'Funded')
        ->get();
      $dead = Deal::where('last_contacted', 'LIKE', '%' . $request->last_contacted . '%')
        ->where('status', 'Dead')
        ->get();
      $doc = Deal::where('last_contacted', 'LIKE', '%' . $request->last_contacted . '%')
        ->where('status', "Doc's Out")
        ->get();
      $proc = Deal::where('last_contacted', 'LIKE', '%' . $request->last_contacted . '%')
        ->where('status', "Processor")
        ->get();
    } else {
      $submitted = Deal::where('status', 'Submitted')->get();
      $underwritter = Deal::where('status', 'Underwritter')->get();
      $approved = Deal::where('status', 'Approved')->get();
      $reshop = Deal::where('status', 'Reshop')->get();
      $open = Deal::where('status', 'Open');
      $open_team = Deal::where('status', 'Open For Team')->whereIn('team_id',$team_id);
      $dead = Deal::where('status', 'Dead');
      $funded = Deal::where('status', 'Funded');
      $doc = Deal::where('status', "Doc's Out");
      $proc = Deal::where('status', "Processor");
      $need_approve = Deal::where('status', 'Need Approve');
      $coldoffer = Deal::where('status', 'Cold Offer')
        ->get();
    }
    if (session()->has('sizes')) {
        $size = session('sizes');
        $size = implode(',', $size);
    } else {
        $size = [24, 24, 24, 24]; // Default sizes (reduced to better fit screen)
        $size = implode(',', $size);
    }
  
    return view('deal.index', compact('submitted', 'reps','teams','open_s','open_app','disable','old','open_uw','open_cold','open_reshop', 'reshop','open_proc', 'proc','underwritter','need_approve', 'coldoffer','loan', 'approved','open','open_team','dead','funded','doc','open_open','open_open_team','open_dead','open_funded','open_doc','size'));
  }
  public function store(Request $request)
  {
    $team=UserTeam::where('user_id',auth()->user()->id)->first();
    if($team){
      $request->merge([
        'team_id' => $team->team_id,
        'date_submitted' => Carbon::now()->format('Y-m-d'),
      ]);
    }else{
      $request->merge([
        'team_id' => NULL,
        'date_submitted' => Carbon::now()->format('Y-m-d'),
      ]);
    }
    $validateData = $request->validate([
      'sale_rep' => 'required|string',
      'sale_rep2' => 'nullable|string',
      'team_id' => 'nullable|integer',
      'company_name' => 'required|string',
      'marchant_name' => 'required|string',
      'phone_number' => 'required|string',
      'cell_phone' => 'nullable|string',
      'email' => 'required|email',
      'request_amount' => 'required|numeric',
      'lead_source' => 'nullable|string',
      'lender_rule' => 'nullable|string',
      'industry' => 'required|string',
      'application_industry' => 'nullable|string',
      'loan_purpose' => 'required|string',
      'application_purpose' => 'nullable|string',
      'existing_loans' => 'nullable|integer',
      'annual_revenue' => 'nullable|numeric',
      'average_balance' => 'nullable|string',
      'business_start_date' => 'nullable|date',
      'state' => 'required|string',
      'credit_score' => 'required|integer|between:300,850',
      'status' => 'nullable|string',
      'quick_add_notes' => 'nullable|string',
      'date_submitted' => 'nullable|date',
      'last_contacted' => 'nullable|date',
      'lender_notes' => 'nullable|string'
    ]);
    $email_deal=Deal::where('email',$request->email)->first();
    $phone_deal=Deal::where('phone_number',$request->phone_number)->first();
    $copy=Deal::where('company_name',$request->company_name)
                ->where('marchant_name',$request->marchant_name)
                ->where('request_amount',$request->request_amount)
                ->where('email',$request->email)
                ->where('phone_number',$request->phone_number)
                ->first();
    if($copy){
       if(in_array($copy->status, ['Dead','Open'])){
          $request->merge([
            'fixed' => 1,
          ]);
       }
       if($copy->status =='Funded'){
          $request->merge([
            'fixed' => 1,
          ]);
          set_time_limit(0);
          $rep = User::where('name', $copy->sale_rep)->first();
          if($rep && isset($rep->email) && filter_var($rep->email, FILTER_VALIDATE_EMAIL)){
              $details = [
                  'subject' => "Duplicate Deal",
                  'title' => 'Deal Funded by you submited again !!',
                  'email' => $request->email,
                  'phone' => $request->phone_number,
                  'requested_amount' => $request->request_amount,
                  'url'=>url('/show_deal').'/'.$copy->id,
              ];
              try {
                  Mail::mailer('gmail')->to($rep->email)->send(new LenderPosition($details));
              } catch (\Throwable $e) {
                  \Log::warning('Mail send failed (rep duplicate notice): '.$e->getMessage(), ['exception' => get_class($e)]);
              }
          }
       }
    }
    $deal = Deal::create($validateData);

    if($request->submit_d=='notify'){
      $deal->update(['status' => 'Processor']);
    }
    $details = [
        'subject' => $deal->company_name,
        'title' => 'Deal need fund',
        'email' => $deal->email,
        'phone' => $deal->phone_number,
        'user'=>$deal->sale_rep,
        'company_name' => $deal->company_name,
        'requested_amount' => $deal->request_amount,
        'url' => url('/show_deal').'/'.$deal->id,
    ];
    
    $mail = new LenderEmail($details);
    $filePaths=[];
    if ($request->hasFile('files')) {
        $files = $request->file('files');
        $fileTypes = $request->input('file_types', []);
        foreach ($files as $idx => $file) {
            $image_name = time() . rand() . '.' . $file->getClientOriginalExtension();
            $file->move(public_path('files'), $image_name);
            $filePaths[] = public_path('files') . '/' . $image_name;

            $deal_files = new DealFiles();
            $deal_files->deal_id = $deal->id;
            $deal_files->files = $image_name;
            // Save selected label/type if provided
            $deal_files->label = isset($fileTypes[$idx]) && $fileTypes[$idx] !== '' ? $fileTypes[$idx] : null;
            $deal_files->save();

            // Attach the file to the email
        }
        foreach ($filePaths as $filePath) {
            $mail->attach($filePath);
        }
    }
    //processing@steadycapitalsolutions.com
    $emdRaw = EmailData::pluck('email')->toArray();
    $emd = array_values(array_filter($emdRaw, function ($addr) {
        $addr = trim((string)$addr);
        return $addr !== '' && filter_var($addr, FILTER_VALIDATE_EMAIL);
    }));
    if (!empty($emd)) {
        try {
            Mail::mailer('gmail')->to($emd)->send($mail);
        } catch (\Throwable $e) {
            \Log::warning('Mail send failed (deal submission broadcast): '.$e->getMessage(), ['exception' => get_class($e)]);
        }
    }
    //Mail::to('processing@steadycapitalsolutions.com')->send($mail);
    if($email_deal){
      $deal->update([
        'status' => 'Open', //Need Approve
      ]);
    }
    if($phone_deal){
      $deal->update([
        'status' => 'Open', //Need Approve
      ]);
    }
    return redirect()->back()->with('success', 'Deal Submitted Successfully');
  }
//   public function add_files_api(Request $request)
//   {
//     return response('in function');
//     $dealId = $request->input('deal_id');

//         $files = $request->file('files');
//         foreach ($files as $file) {
//             $image_name = time() . rand() . '.' . $file->getClientOriginalExtension();
//             $file->move(public_path('files'), $image_name);

//             $deal_files = new DealFiles();
//             $deal_files->deal_id = $dealId;
//             $deal_files->files = $image_name;
//             $deal_files->save();
//         }
//   }
  public function add_files_api(Request $request)
  {
    $dealId = $request->input('deal_id');

    $files = $request->file('files');
    foreach ($files as $file) {
        $image_name = time() . rand() . '.' . $file->getClientOriginalExtension();
        $file->move(public_path('files'), $image_name);

        $deal_files = new DealFiles();
        $deal_files->deal_id = $dealId;
        $deal_files->files = $image_name;
        $deal_files->save();
    }
  }
  public function upload(Request $request)
  {
    $request->validate([
      'deal_id' => 'required',
      'files' => 'required',
    ]);
    if ($request->file('files')) {
      foreach ($request->file('files') as $file) {
        $image_name = $file->getClientOriginalName();
        $file->move(public_path('files'), $image_name);
        $deal_files = new DealFiles();
        $deal_files->files = $image_name;
        $deal_files->deal_id = $request->deal_id;
        $deal_files->save();
      }
      SystemNote::create([
        'deal_id' => $request->deal_id,
        'details' => 'New File added to deal at : '. Carbon::now()->toDayDateTimeString() ,
        'user_id' => auth()->user()->id,
      ]);


      return redirect()->back()->with('success', 'File Uploaded Successfully!');
    }
  }
  public function show(Request $request, $id)
  {

      $loan = Loan::where('deal_id', $id)
          ->latest()
          ->get();

    $new_date=NULL;
    $deal_name=Deal::pluck('company_name')->toArray();
    $lenders = Lender::all(); //where('status','Active')->with('pivot')->get();

    $dealForMatch = Deal::find($id);
    $calcTibMonths = function ($dateStr) {
      if (!$dateStr) return null;
      try {
        $start = \Carbon\Carbon::parse($dateStr);
        return $start->diffInMonths(\Carbon\Carbon::now());
      } catch (\Throwable $e) {
        return null;
      }
    };
    $dealTibMonths = $calcTibMonths($dealForMatch->business_start_date ?? null);

    $lenders = $lenders->map(function ($l) use ($dealForMatch, $dealTibMonths) {
      $match = true;
      $reasons = [];

      $excludedIndustriesRaw = $l->excluded_industries;
      $excludedStatesRaw = $l->excluded_states;
      $excludedIndustries = is_array($excludedIndustriesRaw)
        ? $excludedIndustriesRaw
        : ($excludedIndustriesRaw ? json_decode($excludedIndustriesRaw, true) : []);
      $excludedStates = is_array($excludedStatesRaw)
        ? $excludedStatesRaw
        : ($excludedStatesRaw ? json_decode($excludedStatesRaw, true) : []);

      if (!empty($excludedIndustries) && $dealForMatch->industry) {
        if (in_array($dealForMatch->industry, $excludedIndustries, true)) {
          $match = false; $reasons[] = 'Excluded industry';
        }
      }

      if (!empty($excludedStates) && $dealForMatch->state) {
        if (in_array($dealForMatch->state, $excludedStates, true)) {
          $match = false; $reasons[] = 'Excluded state';
        }
      }

      if ($l->min_time_in_business && $dealTibMonths !== null) {
        if ($dealTibMonths < (int)$l->min_time_in_business) {
          $match = false; $reasons[] = 'TIB too low';
        }
      }

      $dealRevenue = $dealForMatch->annual_revenue ? (int)$dealForMatch->annual_revenue : null;
      if ($dealRevenue !== null) {
        if ($l->min_revenue && $dealRevenue < (int)$l->min_revenue) { $match = false; $reasons[] = 'Revenue below min'; }
        if ($l->max_revenue && $dealRevenue > (int)$l->max_revenue) { $match = false; $reasons[] = 'Revenue above max'; }
      }

      if ($l->min_credit_score && $dealForMatch->credit_score) {
        if ((int)$dealForMatch->credit_score < (int)$l->min_credit_score) { $match = false; $reasons[] = 'Credit score too low'; }
      }

      $l->matches = $match;
      $l->match_reasons = $reasons;

      $summary = [];
      if ($l->min_credit_score) $summary[] = 'Min CS ' . $l->min_credit_score;
      if ($l->min_time_in_business) $summary[] = 'Min TIB ' . $l->min_time_in_business . 'm';
      if ($l->min_revenue || $l->max_revenue) {
        $summary[] = 'Revenue ' . ($l->min_revenue ?? '0') . '-' . ($l->max_revenue ?? '∞');
      }
      if (!empty($excludedIndustries)) $summary[] = 'Excl. ind ' . count($excludedIndustries);
      if (!empty($excludedStates)) $summary[] = 'Excl. states ' . count($excludedStates);
      $l->criteria_summary = implode(' • ', $summary);
      return $l;
    });
    $totalActiveLenders = $lenders->count();
    $totalMatchingLenders = $lenders->where('matches', true)->count();
    $notes = SystemNote::where('deal_id', $id)->orderBy('created_at', 'desc')->get();
    $saleNotes = SaleNote::where('deal_id', $id)->orderBy('created_at', 'desc')->get();
    // dd($lenders);
    $old_date=NULL;
    $deal= Deal::find($id);
    if(auth()->user()->hasRole('Processor')){
      $deal->update([
        'seen_by_processor' => 1,
      ]);
    }
    $deal_lenders_asigned = $deal->lenders()->pluck('lender_id')->toArray();
    $old=$deal->lenders_old()->get()->reverse()->groupBy('pivot.date_sent');
    $reps = User::role('Sale_rep')->get();
    $teams = Team::all();
//      dd($teams);
    if(isset($request->search)){
      if (auth()->user()->hasRole('Admin') || auth()->user()->hasRole('Processor')) {
        $deals = Deal::where('company_name', 'LIKE', '%' . $request->search . '%')
        ->get();
      }  else if(auth()->user()->hasRole('Lender') ){
        //get all deals with this lender
        $email=auth()->user()->email;
        $lender=Lender::where('email',$email)->first();
        $deals=$lender->deals;
      }else if (auth()->user()->hasRole('Team_Lead')) {
        $deals = Deal::whereIn('team_id', $teams->pluck('id'))
        ->orWhere('sale_rep2', auth()->user()->name)
        ->orWhere('sale_rep', auth()->user()->name)
        ->where('company_name', 'LIKE', '%' . $request->search . '%')
        ->get();
      } else {
        $deals = Deal::where('company_name', 'LIKE', '%' . $request->search . '%')
        ->where(function ($query) {
            $query->where('sale_rep', auth()->user()->name)
                  ->orWhere('sale_rep2', auth()->user()->name);
        })
        ->get();
      }
    }
    else{
      if (auth()->user()->hasRole('Admin') || auth()->user()->hasRole('Processor') ) {
        $deals = Deal::orderBy('created_at')->get();
      } else if(auth()->user()->hasRole('Lender') ){
        //get all deals with this lender
        $email=auth()->user()->email;
        $lender=Lender::where('email',$email)->first();
        $deals=$lender->deals;
      } else if (auth()->user()->hasRole('Team_Lead')) {
        $deals = Deal::whereIn('team_id', $teams->pluck('id'))
        ->orWhere('sale_rep2', auth()->user()->name)
        ->orWhere('sale_rep', auth()->user()->name)
        ->get();
      } else {
        $deals = Deal::where('sale_rep', auth()->user()->name)
        ->orWhere('sale_rep2', auth()->user()->name)
        ->get();
      }
    }
    $submitted = $deals->where('status', 'Submitted');
    $underwritter = $deals->where('status', 'Underwritter');
    $approved = $deals->where('status', 'Approved');
    $accepted = $deals->where('status', 'Accepted');
    $coldoffer = $deals->where('status', 'Cold Offer');
    $reshop = $deals->where('status', 'Reshop');
    $open = $deals->where('status', 'Open');
    $team_id=UserTeam::where('user_id',auth()->user()->id)->pluck('team_id')->toArray();
    $open_team = $deals->where('status', 'Open For Team')->whereIn('team_id',$team_id);
    $dead = $deals->where('status', 'Dead');
    $funded = $deals->where('status', 'Funded');
    $doc = $deals->where('status', "Doc's Out");
    $proc = $deals->where('status', "Processor");
    if (session()->has('sizes')) {
        $size = session('sizes');
        $size = implode(',', $size);
    } else {
        $size = [24, 24, 24, 24]; // Default sizes (reduced to better fit screen)
        $size = implode(',', $size);
    }

      $users = User::select('name')->orderBy('name')->get();

//      dd(isset($lenders), optional($lenders)->count(), isset($totalActiveLenders), isset($totalMatchingLenders));
//    foreach ($loan as $l) {
//        dd($l->lender);
//    }

    return view('lender.new', compact('users','lenders',
        'reps','teams','old_date','old','loan', 'deal',
        'deal_name', 'submitted', 'underwritter', 'coldoffer', 'approved', 'accepted',
        'notes','saleNotes','reshop','open','open_team','dead','funded','doc',
        'proc','size','deal_lenders_asigned','totalActiveLenders','totalMatchingLenders')
    );

  }
  public function store_sizes(Request $request)
  {
    $sizes = $request->input('sizes');  
    session(['sizes' => $sizes]);
    return response()->json(['success' => true]);
  }
  public function show_find(Request $request)
  {
    $disable=false;
    $old=Lender::where('deal_id',$request->deal_id)->where('old',1)->get();
    if(count($old)>0){
      $disable=true;
    }
    $loan=Loan::where('deal_id',$request->deal_id)->get();
    $lenders = Lender::with('pivot')->get();
    $notes = SystemNote::where('deal_id', $request->deal_id)->orderBy('created_at', 'desc')->get();
    $saleNotes = SaleNote::where('deal_id', $request->deal_id)->orderBy('created_at', 'desc')->get();
    $reps = User::role('Sale_rep')->get();
    $deal_name=Deal::pluck('company_name')->toArray();
    $teams = Team::all();
    $deal= Deal::find(request()->deal_id);
    if(isset($request->company)){
      if (auth()->user()->hasRole('Admin')) {
        $deals = Deal::where('company_name', 'LIKE', '%' . $request->company . '%')
        ->get();
      } else if (auth()->user()->hasRole('Team_Lead')) {
        $deals = Deal::whereIn('team_id', $teams->pluck('id'))
        ->orWhere('sale_rep2', auth()->user()->name)
        ->orWhere('sale_rep', auth()->user()->name)
        ->where('company_name', 'LIKE', '%' . $request->company . '%')
        ->get();
      } else {
        $deals = Deal::where('company_name', 'LIKE', '%' . $request->company . '%')
        ->where(function ($query) {
            $query->where('sale_rep', auth()->user()->name)
                  ->orWhere('sale_rep2', auth()->user()->name);
        })
        ->get();
      }
    }
    else{
      if (auth()->user()->hasRole('Admin')) {
        $deals = Deal::orderBy('created_at')->get();
      } else if (auth()->user()->hasRole('Team_Lead')) {
        $deals = Deal::whereIn('team_id', $teams->pluck('id'))
        ->orWhere('sale_rep2', auth()->user()->name)
        ->orWhere('sale_rep', auth()->user()->name)
        ->get();
      } else {
        $deals = Deal::where('sale_rep', auth()->user()->name)
        ->orWhere('sale_rep2', auth()->user()->name)
        ->get();
      }
    }
    $submitted = $deals->where('status', 'Submitted');
    $underwritter = $deals->where('status', 'Underwritter');
    $approved = $deals->where('status', 'Approved');
      $accepted = $deals->where('status', 'Accepted');
    $coldoffer = $deals->where('status', 'Cold Offer');
    $reshop = $deals->where('status', 'Reshop');
    $open = $deals->where('status', 'Open');
    $open_team = $deals->where('status', 'Open Team');
    $funded = $deals->where('status', 'Funded');
    $dead = $deals->where('status', 'Dead');
    $doc =$deals->where('status', "Doc's Out");
    $proc =$deals->where('status', "Processor");
    if (session()->has('sizes')) {
        $size = session('sizes');
        $size = implode(',', $size);
    } else {
        $size = [24, 24, 24, 24]; // Default sizes (reduced to better fit screen)
        $size = implode(',', $size);
    }
  
    return view('lender.new', compact('lenders',
        'reps','teams','disable','old', 'deal',
        'doc','deal_name','submitted', 'underwritter','reshop',
        'coldoffer', 'loan','approved', 'open', 'open_team',
        'funded','dead','proc','notes','saleNotes','size', 'accepted'
    ));
  }
  public function edit(Request $request, Deal $deal)
  {
    return $deal;
  }
  // public function sort(Request $request)
  // {
  //   $reps = User::role('Sale_rep')->get();
  //   $teams=Team::all();
  //   $sort = $request->input('sort');

  //   // Retrieve a list of items from your database, sorted based on the given value of $sort
  //   if (auth()->user()->hasRole('Team_Lead')) {
  //     $deals = Deal::where('sale_rep2', auth()->user()->name)->orderBy('created_at', $sort)->get();
  //   } else {
  //     $deals = Deal::where('sale_rep', auth()->user()->name)
  //     ->orWhere('sale_rep2', auth()->user()->name)
  //     ->orderBy('created_at', $sort)
  //     ->get();
  //   }
  //   $submitted = $deals->where('status', 'Submitted');
  //   $underwritter = $deals->where('status', 'Underwritter');
  //   $approved = $deals->where('status', 'Approved');
  //   $coldoffer = $deals->where('status', 'Submitted')->where('created_at', '>=', now()->subDays(7))->values();

  //   return view('deal.index', compact('submitted', 'reps','teams', 'underwritter', 'coldoffer', 'approved'));

  // }
  public function update(Request $request)
  {
    // dd($request->all());
    $id = $request->id;
    $deal = Deal::find($id);
    $deal=$deal->update($request->all());
    $deal=Deal::find($id);
    SystemNote::create([
      'deal_id' => $deal->id,
      'details' => 'Deal Updated | Current Deal status at : '. Carbon::now()->toDayDateTimeString() . ' is : '.$deal->status ,
      'user_id' => auth()->user()->id,
    ]);
    if($deal->status=='Reshop'){
      $details = [
        'subject' => "Reshop Deal",
        'title' => 'Deal status is in reshop !!',
        'email' => "",
        'phone' => "",
        'requested_amount' => "",
        'url'=>url('/show_deal').'/'.$id,
        'message' =>'Deal status has been updated to Reshop, click link to see details'
      ];
      $emdRaw = EmailData::where('type','proc_sub')->pluck('email')->toArray();
        $emd = array_values(array_filter($emdRaw, function ($addr) {
          $addr = trim((string)$addr);
          return $addr !== '' && filter_var($addr, FILTER_VALIDATE_EMAIL);
        }));
        if (!empty($emd)) {
           try {
               Mail::mailer('gmail')->to($emd)->send(new LenderPosition($details));
           } catch (\Throwable $e) {
               \Log::warning('Mail send failed (reshop notification): '.$e->getMessage(), ['exception' => get_class($e)]);
           }
        }
    }
    return redirect()->back()->with('success', 'Deal Updated Successfully!');
  }
  public function delete_file($id)
  {
    $deal_files =DealFiles::find($id);
    $deal_files->delete();
    SystemNote::create([
      'deal_id' => $deal_files->deal_id,
      'details' => 'File Deleted at : '. Carbon::now()->toDayDateTimeString(),
      'user_id' => auth()->user()->id,
    ]);
    return redirect()->back()->with('success', 'File Deleted Successfully!');
  }

  public function downlode_note(Request $request)
  {
    $file=DealFiles::find($request->file_id);
    $deal = Deal::find($request->deal_id);
    SystemNote::create([
      'deal_id' => $deal->id,
      'details' => 'File : '. $file->files .' Downloded at : '. Carbon::now()->toDayDateTimeString(),
      'user_id' => auth()->user()->id,
    ]);
    return response()->json(['success' => 'File Downloded Successfully!']);
  }
  public function destroy(Request $request)
  {
    $id = $request->id;
    $deal = Deal::find($id);
    if ($deal) {
      $deal->delete();
      return response()->json('success');
    } else {
      return response()->json('fail');
    }
  }
  public function delete_deal(Request $request)
  {
    $id = $request->id;
    $deal = Deal::find($id);
    dd($deal);
    if ($deal) {
      $deal->delete();
      echo 'success';
    } else {
      echo 'fail';
    }
  }
  public function approve_status(Request $request)
  {
    $deal = Deal::find($request->id);
    $deal->update([
        'status' => 'Submitted',
    ]);
    SystemNote::create([
      'deal_id' => $deal->id,
      'details' => 'Deal Approved at : '. Carbon::now()->toDayDateTimeString(),
      'user_id' => auth()->user()->id,
    ]);
    return redirect()->back()->with('success', 'Deal Approved Successfully!');
  }
  public function sale_note(Request $request)
  {
    SaleNote::create([
      'deal_id' => $request->deal_id,
      'details' => $request->details,
      'user_id' => auth()->user()->id,
    ]);
    return response()->json(['success' => 'Note Added Successfully!']);
  }
}
