<?php

namespace App\Http\Controllers\Finance;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\UserTeam;
use App\Models\TeamLeader;
use Illuminate\Http\Request;
use App\Models\Deal;
use Illuminate\Support\Facades\Hash;
use DB;
use App\Models\AppSlug;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\Log;

class EmployeeController extends Controller
{
    // test
    public function index(Request $request)
    {
        if ($request->name && $request->phone && $request->email && $request->status) {
            $employees = User::where('name', 'LIKE', '%' . $request->name . '%')
                ->where('email', 'LIKE', '%' . $request->email . '%')
                ->where('phone', 'LIKE', '%' . $request->phone . '%')
                ->where('status', 'LIKE', '%' . $request->status . '%')
                ->get();
            $other = User::whereDoesntHave('roles')->where('name', 'LIKE', '%' . $request->name . '%')->where('email', 'LIKE', '%' . $request->email . '%')
            ->where('phone', 'LIKE', '%' . $request->phone . '%')
            ->where('status', 'LIKE', '%' . $request->status . '%')
            ->get();
        } else if ($request->name) {
            $employees = User::where('name', 'LIKE', '%' . $request->name . '%')->get();
            $other = User::whereDoesntHave('roles')->where('name', 'LIKE', '%' . $request->name . '%')->get();
        } else if ($request->email) {
            $employees = User::where('email', 'LIKE', '%' . $request->email . '%')->get();
            $other = User::whereDoesntHave('roles')->where('email', 'LIKE', '%' . $request->email . '%')->get();
        } else if ($request->phone) {
            $employees = User::where('phone', 'LIKE', '%' . $request->phone . '%')->get();
            $other = User::whereDoesntHave('roles')->where('phone', 'LIKE', '%' . $request->phone . '%')->get();
        } else if ($request->status) {
            $employees = User::where('status', 'LIKE', '%' . $request->status . '%')->get();
            $other = User::whereDoesntHave('roles')->where('status', 'LIKE', '%' . $request->status . '%')->get();
        } else if ($request->role) {
            $employees = User::role($request->role)->get();
            $other = NULL;
        } else {
            $employees = User::role(['Processor', 'Sale_rep','Team_Lead'])->get();
            $other = User::whereDoesntHave('roles')->get();
        }
        $all_processor = User::whereHas("roles", function ($q) {
            $q->where("name", "Processor");
        })->get();
        $all_rep = User::whereHas("roles", function ($q) {
            $q->where("name", "Sale_rep");
        })->get();
        $all_lender = User::whereHas("roles", function ($q) {
            $q->where("name", "Lender");
        })->get();
        $active_processor = User::whereHas("roles", function ($q) {
            $q->where(["name" => "Processor", "status" => "Active"]);
        })->get();
        $active_rep = User::whereHas("roles", function ($q) {
            $q->where(["name" => "Sale_rep", "status" => "Active"]);
        })->get();
        $active = User::where('status', 'Active')->get();
        return view('employee.index', compact(
            'employees',
            'all_processor',
            'all_rep',
            'all_lender',
            'active_processor',
            'active_rep',
            'active',
            'other'
        ));
    }
    public function store(Request $request)
    {
        $validateData = $request->validate([
            'name' => 'required',
            'email' => 'required',
            'phone' => 'required',
            'role_id' => 'required',
            'password'=>'required', 
            'app_slug'=>'', 
            'status' => '',
            'email_password'=>''
        ]);
        $employee = new User();
        $employee->name = $validateData['name'];
        $employee->email = $validateData['email'];
        $employee->phone = $validateData['phone'];
        $employee->password = bcrypt($validateData['password']);
        $employee->email_password = $validateData['email_password'];
        $employee->status = "Active";
        $employee->assignRole($validateData['role_id']);
        $employee->save();
        if(isset($request->app_slug)){
            $requestAppSlug = str_replace(' ', '-', $request->app_slug);
            $requestAppSlug = preg_replace('/[^A-Za-z0-9\-_]/', '', $requestAppSlug);

            $check=AppSlug::where('app_deal_username',$requestAppSlug)->first();
            if($check){
                return redirect()->back()->with('error', 'App slug already exist try to edit user with some other slug!');
            }
            else{
                $app_slug=new AppSlug();
                $app_slug->user_id=$employee->id;
                $app_slug->app_deal_username=$requestAppSlug;
                $app_slug->save();
            }
        }
        return redirect()->back()->with('success', 'Employee Added Successfully!');
    }
    public function create_new_user_api(Request $request)
    {
        $validateData = $request->validate([
            'name' => 'nullable',
            'email' => 'nullable',
            'phone' => 'nullable',
            'role' => 'nullable',
            'password'=>'nullable', 
            'app_slug'=>'', 
            'status' => '',
            'email_password'=>''
        ]);
        $employee = new User();
        $employee->name = $validateData['name'];
        $employee->email = $validateData['email'];
        $employee->phone = $validateData['phone'];
        $employee->password = Hash::make($validateData['password']);
        $employee->email_password = $validateData['email_password'];
        $employee->status = "Active";
        if ( null != $validateData['role'] && $validateData['role'] != ''){
            if($validateData['role']=='admin'){
                $employee->assignRole("Admin");
            }
            else if($validateData['role']=="processor"){
                $employee->assignRole("Processor");
            }
            else if($validateData['role']=="caller"){
                $employee->assignRole("Sale_rep");
            }
            else if($validateData['role']=="team lead"){
                $employee->assignRole("Team_Lead");
            }
        }
        $employee->save();
        if(isset($request->app_slug)){
            $requestAppSlug = str_replace(' ', '-', $request->app_slug);
            $requestAppSlug = preg_replace('/[^A-Za-z0-9\-_]/', '', $requestAppSlug);
            $app_slug=new AppSlug();
            $app_slug->user_id=$employee->id;
            $app_slug->app_deal_username=$requestAppSlug;
            $app_slug->save();
        }
        return response()->json(['success' => 'Employee Added Successfully!']);
    }
   public function delete_new_user_api(Request $request)
    {
        $validateData = $request->validate([
            'id' => 'nullable',
        ]);
    
        $id = $validateData['id'];
    
        // Delete AppSlug records
        AppSlug::where('user_id', $id)->delete();
    
        //assign deal to team leader or admin
        $team_id =  UserTeam::where('user_id', $id)->value('team_id');
        if($team_id){
            $leader_id=TeamLeader::where('team_id',$team_id)->value('leader_id');
            if($leader_id){
                $assign_to=User::find($leader_id);
                $assign_to=$assign_to->name;
            }
            else{
                $assign_to="Admin";
            }
        }
        else{
            $assign_to="Admin";
        }
        // Delete UserTeam records
        UserTeam::where('user_id', $id)->delete();
    
        // Delete TeamLeader records
        TeamLeader::where('leader_id', $id)->delete();
    
        // Delete User record
        $user = User::find($id);
        $username=$user->name;
        $user->delete();
        
        // update deal
        Deal::where('sale_rep',$username)->update([
            'sale_rep'=>$assign_to
        ]);
        Deal::where('sale_rep2',$username)->update([
            'sale_rep2'=>null
        ]);
    
        return response()->json(['success' => 'Employee Deleted Successfully!']);
    }

    public function update_new_user_api(Request $request)
    {
        
        $validateData = $request->validate([
            'name' => 'nullable',
            'email' => 'nullable',
            'phone' => 'nullable',
            'status' => 'nullable',
            'role' => 'nullable',
            'email_password' => 'nullable',
            'app_slug' => 'nullable',
            'update_id'=>'nullable',
        ]);
        $id = $validateData['update_id'];
        $employee = User::find($id);
        if($validateData['status'] == "1"){
            $validateData['status'] = "Active";
        }
        else if($validateData['status'] == "0"){
            $validateData['status'] = "Inactive";
        }
        $employee->update($validateData);
        if(isset($validateData['email_password']) && $validateData['email_password'] != ''){
            $employee->email_password = $validateData['email_password'];
            $employee->save();
        }
        if(isset($request->password) && $request->password != ''){
            $employee->password = Hash::make($request->password);
            $employee->save();
        }
        if ( null != $validateData['role'] && $validateData['role'] != ''){
            if($validateData['role']=='admin'){
                $employee->assignRole("Admin");
            }
            else if($validateData['role']=="processor"){
                $employee->assignRole("Processor");
            }
            else if($validateData['role']=="caller"){
                $employee->assignRole("Sale_rep");
            }
            else if($validateData['role']=="team leader"){
                $employee->assignRole("Team_Lead");
            }
        }
        if(isset($validateData['app_slug']) && $validateData['app_slug'] != ''){
            AppSlug::where('user_id',$validateData['update_id'])->update(['app_deal_username'=>$validateData['app_slug']]);
        }
    }
    public function update(Request $request)
    {
        $validateData = $request->validate([
            'name' => 'required',
            'email' => 'required',
            'phone' => 'required',
            'status' => 'required',
            'app_slug' => '',
        ]);
        // dd($validateData);
        $id = $request->id;
        $employee = User::find($id);
        $employee->update($validateData);
        if(isset($request->email_password)){
            $employee->email_password = $request->email_password;
            $employee->save();
        }
        if(isset($request->password)){
            $employee->password = bcrypt($request->password);
            $employee->save();
        }
        if(isset($request->app_slug)){
            $requestAppSlug = str_replace(' ', '-', $request->app_slug);
            $requestAppSlug = preg_replace('/[^A-Za-z0-9\-_]/', '', $requestAppSlug);
            $check=AppSlug::where('app_deal_username',$requestAppSlug)->first();
            if($check){
                if($check->user_id != $id){
                    return response()->json('error');
                }
                else{
                    $app_slug=AppSlug::where('user_id',$id)->first();
                    if($app_slug){
                        $app_slug->app_deal_username=$requestAppSlug;
                        $app_slug->save();
                    }
                    else{
                        $app_slug=new AppSlug();
                        $app_slug->user_id=$employee->id;
                        $app_slug->app_deal_username=$requestAppSlug;
                        $app_slug->save();
                    }
                }
            }
            else{
                $app_slug=AppSlug::where('user_id',$id)->first();
                if($app_slug){
                    $app_slug->app_deal_username=$requestAppSlug;
                    $app_slug->save();
                }
                else{
                    $app_slug=new AppSlug();
                    $app_slug->user_id=$employee->id;
                    $app_slug->app_deal_username=$requestAppSlug;
                    $app_slug->save();
                }
            }
            
        }
        if(isset($request->role_id)){
            DB::table('model_has_roles')->where('model_id', $id)->delete();
            $employee->assignRole($request->role_id);
            return response()->json([
                'employee' => $employee,
                'role_id' => $request->role_id
            ]);
        }
        return response()->json(true);
    }
    // public function show(Lender $lender)
    // {
    //     return view('lender.show',compact('lender'));
    // }
    public function edit(Request $request, User $user)
    {
        $slug=AppSlug::where('user_id',$user->id)->first();
        if($slug){
            $app_slug=$slug->app_deal_username;
        }
        else{
            $app_slug=NULL;
        }
        if($user->roles->pluck('name')->count() > 0){
            $role_id = $user->roles->pluck('name')[0];
            return response()->json([
                'user' => $user,
                'role_id' => $role_id,
                'app_slug'=>$app_slug
            ]);
        }
        else{
            return response()->json([
                'user' => $user,
                'role_id' => '',
                'app_slug'=>$app_slug
            ]);
        }


        return $user;
    }
    public function destroy(Request $request)
    {
        $id = $request->id;
        $lender = User::find($id);
        if ($lender) {
            $lender->delete();
            echo 'success';
        } else {
            echo 'fail';
        }
    }
}
