<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Google_Client;

class GoogleOAuthController extends Controller
{
    public function redirect()
    {
        $client = new Google_Client();
        $client->setClientId(env('GOOGLE_CLIENT_ID'));
        $client->setClientSecret(env('GOOGLE_CLIENT_SECRET'));
        $client->setRedirectUri(route('google.callback'));

        // REQUIRED to get a refresh token
        $client->setAccessType('offline');
        $client->setPrompt('consent');

        // Gmail send scope
        $client->addScope('https://www.googleapis.com/auth/gmail.send');

        // Redirect to Google Login Screen
        return redirect()->away($client->createAuthUrl());
    }


    public function callback(Request $request)
    {
        $client = new Google_Client();
        $client->setClientId(env('GOOGLE_CLIENT_ID'));
        $client->setClientSecret(env('GOOGLE_CLIENT_SECRET'));
        $client->setRedirectUri(route('google.callback'));

        // Exchange code for token
        $token = $client->fetchAccessTokenWithAuthCode($request->code);

        // THIS IS WHERE YOU GET THE REFRESH TOKEN!!!
        $refresh = $token['refresh_token'] ?? null;

        if (!$refresh) {
            return "❌ No refresh token returned.  
            You MUST use: access_type=offline + prompt=consent  
            AND remove old permissions at https://myaccount.google.com/permissions";
        }

        // Save token somewhere safe
        file_put_contents(storage_path('app/gmail_token.json'), json_encode($token));

        return "✅ Refresh Token Saved!  
                <br>Refresh Token: " . $refresh . "
                <br><br>You can now send email forever.";
    }
}
