<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Config;

class CheckUserStatus
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle($request, Closure $next)
    {
       if (auth()->check() && auth()->user()->status == 'Active') {
           $gmailConfigured = !empty(config('services.gmail.access_token')) || !empty(config('services.gmail.oauth_json'));

           if ($gmailConfigured) {
               // Prefer Gmail API transport when configured
               Config::set('mail.default', 'gmail');
               // Ensure from address is set if available on user smtp (used as sender identity)
               if (auth()->user()->smtp) {
                   $username = (string) auth()->user()->smtp->username;
                   if (filter_var($username, FILTER_VALIDATE_EMAIL)) {
                       Config::set('mail.from.address', $username);
                   }
               }
               Config::set('mail.from.name', 'SalesCallz');
               return $next($request);
           }

           // Fallback to per-user SMTP if Gmail is not configured
           if (auth()->user()->smtp) {
               Config::set('mail.mailers.smtp.host', (string) auth()->user()->smtp->host);
               Config::set('mail.mailers.smtp.port', (int) auth()->user()->smtp->port);
               Config::set('mail.mailers.smtp.username', (string) auth()->user()->smtp->username);
               Config::set('mail.mailers.smtp.password', (string) auth()->user()->smtp->password);
               $username = (string) auth()->user()->smtp->username;
               if (filter_var($username, FILTER_VALIDATE_EMAIL)) {
                   Config::set('mail.from.address', $username);
               }
               Config::set('mail.from.name', 'SalesCallz');
               return $next($request);
           }
           return $next($request);
        }
    
        return redirect()->route('get_login')->with('error', 'Your account is not active.');
    }
    
}
