<?php

namespace App\Imports;

use App\Models\Deal;
use Carbon\Carbon;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithStartRow;

class DealsImport implements ToModel , WithStartRow
{
    /**
     * @return int
     */
    public function startRow(): int
    {
        return 2;
    }
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        for($i=0;$i<count($row);$i++){
            if($row[$i]=="NULL" || $row[$i]=="null" || $row[$i]=="Null" || isset($row[$i])==false){
                $row[$i]=null;
            }
        }
        return new Deal([
            'sale_rep' => $row[0],
            'sale_rep2' => $row[1],
            'company_name' => $row[2],
            'marchant_name' => $row[3],
            'phone_number' => $row[4],
            'email' => $row[5],
            'request_amount' => $row[6],
            'date_submitted' => $row[7] ? Carbon::createFromFormat('d/m/Y', $row[7])->toDateString() : null,
            'last_contacted' => $row[8] ? Carbon::createFromFormat('d/m/Y', $row[8])->toDateString() : null,
            'status' => $row[9],
            'borrower'=>$row[10],
            'borrower_status'=>$row[11],
            'lender_notes'=>$row[12],
            'team_id'=>$row[13],
        ]);
    }
}
