<?php

namespace App\Imports;

use App\Models\User;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithStartRow;


class UsersImport implements ToModel, WithStartRow
{
    /**
     * @return int
     */
    public function startRow(): int
    {
        return 2;
    }
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        for($i=0;$i<count($row);$i++){
            if($row[$i]=="NULL" || $row[$i]=="null" || $row[$i]=="Null" || isset($row[$i])==false){
                $row[$i]=null;
            }
        }
        return new User([
            'name' => $row[0],
            'email' => $row[1],
            'password' => bcrypt($row[2]),
            'phone' => $row[3],
            'status'=>$row[4],
        ]);

    }
}
