<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Commission extends Model
{
    use HasFactory;

    protected $fillable = [
        'deal_id',
        'user_id',
        'lender_id',
        'loan_id',
        'amount',
        'sales_rep_cm',
        'team_leader_cm',
        'sales_rep_paid',
        'team_leader_paid',
        'sr_paid_at',
        'tl_paid_at',
        'status',
        'amount_paid',
        'paid_at',
    ];

    protected $casts = [
        'amount' => 'float',
        'sales_rep_cm' => 'float',
        'team_leader_cm' => 'float',
        'sales_rep_paid' => 'boolean',
        'team_leader_paid' => 'boolean',
        'amount_paid' => 'float',
        'paid_at' => 'date',
        'sr_paid_at' => 'date',
        'tl_paid_at' => 'date',
    ];

    public function deal()
    {
        return $this->belongsTo(Deal::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function lender()
    {
        return $this->belongsTo(Lender::class);
    }

    public function loan()
    {
        return $this->belongsTo(Loan::class, 'loan_id', 'id');
    }
}
