<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Lender extends Model
{
    use HasFactory;
    protected $fillable = [
        'deal_id',
        'company_name',
        'primary_contact',
//        'code',
        'phone',
        'email',
        'assigned',
        'password',
        'email2',
        'last_contacted',
        'processed_by',
        'notes',
        'funded_amount',
        'date_sent',
        'date_received',
        'status',
        'position',

        'min_time_in_business',
        'min_revenue',
        'max_revenue',
        'accepts_defaults',
        'min_credit_score',
        'positions',
        'max_nsf_per_month',
        'min_deposits_per_month',
        'excluded_industries',
        'excluded_states',
        'has_integrated_api',
        'api_key',
        'submission_type',
    ];
    protected $guarded = [];

    protected $casts = [
        'positions' => 'array',
        'excluded_industries' => 'array',
        'excluded_states' => 'array',
        'accepts_defaults' => 'boolean',
        'has_integrated_api' => 'boolean',
        'last_contacted' => 'date',
    ];

    /**
     * Get the lender_notes associated with the notes.
     */

    public function deals()
    {
        return $this->belongsToMany(Deal::class, 'deal_lender')->withPivot('old','date_sent')->withTimestamps();
    }
    public function pivot()
    {
        return $this->hasMany(DealLender::class, 'lender_id');
    }  

}
