<?php

namespace App\Observers;

use App\Models\Deal;
use App\Services\CommissionService;

class DealObserver
{
    public function updated(Deal $deal)
    {
        // If deal status changed to Funded, calculate commissions
        if ($deal->isDirty('status') && $deal->status === 'Funded') {
            app(CommissionService::class)->calculateForDeal($deal);
        }
    }
}
