<?php

namespace App\Providers;

use App\Models\Deal;
use App\Observers\DealObserver;
use App\Mail\Transport\GmailApiTransport;
use GuzzleHttp\Client;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Deal::observe(DealObserver::class);

        // Register custom Gmail API mail transport
        $manager = $this->app->make('mail.manager');

        $manager->extend('gmail', function (array $config) {
            $gmail = config('services.gmail') ?: [];

            // If JSON blob is provided in env, parse it and merge
            if (!empty($gmail['oauth_json']) && is_string($gmail['oauth_json'])) {
                try {
                    $json = json_decode($gmail['oauth_json'], true) ?: [];
                    $gmail = array_merge($gmail, $json);
                } catch (\Throwable $e) {
                    // ignore invalid json
                }
            }

            $accessToken = $gmail['access_token'] ?? null;

            $http = new Client([
                'base_uri' => 'https://gmail.googleapis.com/',
                'timeout' => 30,
            ]);

            return new GmailApiTransport($http, $accessToken, app('log'));
        });

        // If Gmail is configured, set as default mailer
        $gmailConfigured = !empty(config('services.gmail.access_token')) || !empty(config('services.gmail.oauth_json'));
        if ($gmailConfigured) {
            $manager->setDefaultDriver('gmail');
        }
    }
}
