<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    |
    | This file is for storing the credentials for third party services such
    | as Mailgun, Postmark, AWS and more. This file provides the de facto
    | location for this type of information, allowing packages to have
    | a conventional file to locate the various service credentials.
    |
    */

    'mailgun' => [
        'domain' => env('MAILGUN_DOMAIN'),
        'secret' => env('MAILGUN_SECRET'),
        'endpoint' => env('MAILGUN_ENDPOINT', 'api.mailgun.net'),
    ],

    'postmark' => [
        'token' => env('POSTMARK_TOKEN'),
    ],

    'ses' => [
        'key' => env('AWS_ACCESS_KEY_ID'),
        'secret' => env('AWS_SECRET_ACCESS_KEY'),
        'region' => env('AWS_DEFAULT_REGION', 'us-east-1'),
    ],

    // 'gmail' => [
    //     // Preferred: set GMAIL_ACCESS_TOKEN via .env
    //     'access_token' => env('GMAIL_ACCESS_TOKEN'),
    //     // Optional: provide full JSON from Google OAuth as a single env var
    //     // e.g., GMAIL_OAUTH_JSON='{"access_token":"...","refresh_token":"...","expires_in":3599}'
    //     'oauth_json' => env('GMAIL_OAUTH_JSON'),
    //     // Optional: store refresh token and expiry if needed in future
    //     'refresh_token' => env('GMAIL_REFRESH_TOKEN', env('GOOGLE_REFRESH_TOKEN')),
    //     'expires_in' => env('GMAIL_EXPIRES_IN'),
    //     // OAuth client credentials for token refresh (support both GOOGLE_* and GMAIL_* env names)
    //     'client_id' => env('GOOGLE_CLIENT_ID', env('GMAIL_CLIENT_ID')),
    //     'client_secret' => env('GOOGLE_CLIENT_SECRET', env('GMAIL_CLIENT_SECRET')),
    //     // Token endpoint (Google default)
    //     'token_uri' => env('GMAIL_TOKEN_URI', 'https://oauth2.googleapis.com/token'),
    //     // Optional: sender email override (From header is normally provided by Mailables)
    //     'sender' => env('GMAIL_SENDER'),
    // ],
    'gmail' => [
        'oauth_json'   => env('GMAIL_OAUTH_JSON'),
        'client_id'    => env('GOOGLE_CLIENT_ID'),
        'client_secret'=> env('GOOGLE_CLIENT_SECRET'),
        'redirect_uri' => env('GOOGLE_REDIRECT_URI'),
        'token_uri'    => 'https://oauth2.googleapis.com/token',
        'access_token' => null,
        'refresh_token'=> null,
    ],

];
