<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddLenderCriteriaFieldsToLendersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('lenders', function (Blueprint $table) {
            $table->integer('min_time_in_business')->nullable();
            $table->integer('min_revenue')->nullable();
            $table->integer('max_revenue')->nullable();
            $table->boolean('accepts_defaults')->default(false);
            $table->integer('min_credit_score')->nullable();
            $table->json('positions')->nullable();
            $table->integer('max_nsf_per_month')->nullable();
            $table->integer('min_deposits_per_month')->nullable();
            $table->json('excluded_industries')->nullable();
            $table->json('excluded_states')->nullable();
            $table->boolean('has_integrated_api')->default(false);
            $table->string('api_key')->nullable();
            $table->enum('submission_type', ['email', 'api'])->default('email');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('lenders', function (Blueprint $table) {
            $table->dropColumn([
                'min_time_in_business',
                'min_revenue',
                'max_revenue',
                'accepts_defaults',
                'min_credit_score',
                'positions',
                'max_nsf_per_month',
                'min_deposits_per_month',
                'excluded_industries',
                'excluded_states',
                'has_integrated_api',
                'api_key',
                'submission_type',
            ]);
        });
    }
}
