<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{

    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            if (!Schema::hasColumn('users', 'team_leader_commission_rate')) {
                $table->decimal('team_leader_commission_rate', 5, 2)->nullable()->after('commission_rate');
            }
        });
    }

    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            if (Schema::hasColumn('users', 'team_leader_commission_rate')) {
                $table->dropColumn('team_leader_commission_rate');
            }
        });
    }
};
