<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasColumn('lenders', 'code')) {
            Schema::table('lenders', function (Blueprint $table) {
                $table->dropColumn('code');
            });
        }
    }

    public function down(): void
    {
        if (!Schema::hasColumn('lenders', 'code')) {
            Schema::table('lenders', function (Blueprint $table) {
                $table->string('code', 50)->nullable()->after('primary_contact');
            });
        }
    }
};
