<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('commissions', function (Blueprint $table) {
            if (!Schema::hasColumn('commissions', 'sr_paid_at')) {
                $table->date('sr_paid_at')->nullable()->after('sales_rep_paid');
                $table->index('sr_paid_at', 'idx_comm_sr_paid_at');
            }
            if (!Schema::hasColumn('commissions', 'tl_paid_at')) {
                $table->date('tl_paid_at')->nullable()->after('team_leader_paid');
                $table->index('tl_paid_at', 'idx_comm_tl_paid_at');
            }

            if (!Schema::hasColumn('commissions', 'loan_id')) {
            }

            try { $table->index('user_id', 'idx_comm_user_id'); } catch (\Throwable $e) {}
            try { $table->index('lender_id', 'idx_comm_lender_id'); } catch (\Throwable $e) {}
        });
    }

    public function down(): void
    {
        Schema::table('commissions', function (Blueprint $table) {
            if (Schema::hasColumn('commissions', 'tl_paid_at')) {
                try { $table->dropIndex('idx_comm_tl_paid_at'); } catch (\Throwable $e) {}
                $table->dropColumn('tl_paid_at');
            }
            if (Schema::hasColumn('commissions', 'sr_paid_at')) {
                try { $table->dropIndex('idx_comm_sr_paid_at'); } catch (\Throwable $e) {}
                $table->dropColumn('sr_paid_at');
            }
            try { $table->dropIndex('idx_comm_user_id'); } catch (\Throwable $e) {}
            try { $table->dropIndex('idx_comm_lender_id'); } catch (\Throwable $e) {}
        });
    }
};
